/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util.backups;

import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.util.backups.Backup;
import com.feed_the_beast.ftbu.util.backups.Backups;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThreadBackup
extends Thread {
    public boolean isDone = false;
    private final File src0;
    private final String customName;

    public ThreadBackup(File w, String s) {
        this.src0 = w;
        this.customName = s;
        this.setPriority(7);
    }

    public static void doBackup(File src, String customName) {
        StringBuilder out;
        boolean success;
        Calendar time;
        block19: {
            time = Calendar.getInstance();
            File dstFile = null;
            success = false;
            out = new StringBuilder();
            if (customName.isEmpty()) {
                ThreadBackup.appendNum(out, time.get(1), '-');
                ThreadBackup.appendNum(out, time.get(2) + 1, '-');
                ThreadBackup.appendNum(out, time.get(5), '-');
                ThreadBackup.appendNum(out, time.get(11), '-');
                ThreadBackup.appendNum(out, time.get(12), '-');
                ThreadBackup.appendNum(out, time.get(13), '\u0000');
            } else {
                out.append(customName);
            }
            try {
                List files = FileUtils.listAll((File)src);
                int allFiles = files.size();
                FTBUFinals.LOGGER.info(FTBULang.BACKUP_BACKING_UP_FILES.translate(new Object[]{files.size()}));
                if (FTBUConfig.backups.compression_level > 0) {
                    out.append(".zip");
                    dstFile = FileUtils.newFile((File)new File(Backups.INSTANCE.backupsFolder, out.toString()));
                    long start = System.currentTimeMillis();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                    zos.setLevel(FTBUConfig.backups.compression_level);
                    long logMillis = System.currentTimeMillis() + 5000L;
                    byte[] buffer = new byte[4096];
                    FTBUFinals.LOGGER.info(FTBULang.BACKUP_COMPRESSING_FILES.translate(new Object[]{allFiles}));
                    for (int i = 0; i < allFiles; ++i) {
                        try {
                            int len;
                            File file = (File)files.get(i);
                            String filePath = file.getAbsolutePath();
                            ZipEntry ze = new ZipEntry(src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1, filePath.length()));
                            long millis = System.currentTimeMillis();
                            if (i == 0 || millis > logMillis || i == allFiles - 1) {
                                logMillis = millis + 5000L;
                                FTBUFinals.LOGGER.info("[" + i + " | " + StringUtils.formatDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + ze.getName());
                            }
                            zos.putNextEntry(ze);
                            FileInputStream fis = new FileInputStream(file);
                            while ((len = fis.read(buffer)) > 0) {
                                zos.write(buffer, 0, len);
                            }
                            zos.closeEntry();
                            fis.close();
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    zos.close();
                    FTBUFinals.LOGGER.info(FTBULang.BACKUP_COMPRESSING_DONE.translate(new Object[]{ThreadBackup.getDoneTime(start), FileUtils.getSizeS((File)dstFile)}));
                } else {
                    out.append('/');
                    out.append(src.getName());
                    dstFile = new File(Backups.INSTANCE.backupsFolder, out.toString());
                    dstFile.mkdirs();
                    String dstPath = dstFile.getAbsolutePath() + File.separator;
                    String srcPath = src.getAbsolutePath();
                    long logMillis = System.currentTimeMillis() + 2000L;
                    for (int i = 0; i < allFiles; ++i) {
                        try {
                            File file = (File)files.get(i);
                            long millis = System.currentTimeMillis();
                            if (i == 0 || millis > logMillis || i == allFiles - 1) {
                                logMillis = millis + 2000L;
                                FTBUFinals.LOGGER.info("[" + i + " | " + StringUtils.formatDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + file.getName());
                            }
                            File dst1 = new File(dstPath + file.getAbsolutePath().replace(srcPath, ""));
                            FileUtils.copyFile((File)file, (File)dst1);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                FTBUFinals.LOGGER.info(FTBULang.BACKUP_CREATED_FROM.translate(new Object[]{dstFile.getAbsolutePath(), src.getAbsolutePath()}));
                success = true;
                if (!FTBUConfig.backups.silent) {
                    if (FTBUConfig.backups.display_file_size) {
                        String sizeB = FileUtils.getSizeS((File)dstFile);
                        String sizeT = FileUtils.getSizeS((File)Backups.INSTANCE.backupsFolder);
                        Backups.notifyAll(player -> FTBULang.BACKUP_END_2.textComponent(player, new Object[]{ThreadBackup.getDoneTime(time.getTimeInMillis()), sizeB.equals(sizeT) ? sizeB : sizeB + " | " + sizeT}), false);
                    } else {
                        Backups.notifyAll(player -> FTBULang.BACKUP_END_1.textComponent(player, new Object[]{ThreadBackup.getDoneTime(time.getTimeInMillis())}), false);
                    }
                }
            }
            catch (Exception ex) {
                if (!FTBUConfig.backups.silent) {
                    Backups.notifyAll(player -> FTBULang.BACKUP_FAIL.textComponent(player, new Object[]{ex.getClass().getName()}), true);
                }
                ex.printStackTrace();
                if (dstFile == null) break block19;
                FileUtils.delete(dstFile);
            }
        }
        Backups.INSTANCE.backups.add(new Backup(time.getTimeInMillis(), out.toString().replace('\\', '/'), Backups.INSTANCE.getLastIndex() + 1, success));
        Backups.INSTANCE.cleanupAndSave();
    }

    private static String getDoneTime(long l) {
        l = System.currentTimeMillis() - l;
        if (l < 1000L) {
            return l + "ms";
        }
        return StringUtils.getTimeString((long)l);
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @Override
    public void run() {
        this.isDone = false;
        ThreadBackup.doBackup(this.src0, this.customName);
        this.isDone = true;
    }
}

