/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankCore
implements IFluidTank {
    protected FluidStack fluid;
    protected int capacity;
    protected boolean locked;

    public FluidTankCore(int capacity) {
        this(null, capacity);
    }

    public FluidTankCore(FluidStack stack, int capacity) {
        this.fluid = stack;
        this.capacity = capacity;
    }

    public FluidTankCore(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public FluidTankCore readFromNBT(NBTTagCompound nbt) {
        FluidStack fluid = null;
        this.locked = false;
        if (!nbt.func_74764_b("Empty")) {
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.locked = nbt.func_74767_n("Lock") && fluid != null;
        }
        this.setFluid(fluid);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
            nbt.func_74757_a("Lock", this.locked);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        return nbt;
    }

    public FluidTankCore setLock(Fluid fluid) {
        boolean bl = this.locked = fluid != null;
        if (this.locked && (this.fluid == null || !this.fluid.getFluid().equals(fluid))) {
            this.fluid = new FluidStack(fluid, 0);
        }
        return this;
    }

    public void setLocked(boolean lock) {
        if (lock) {
            this.setLocked();
        } else {
            this.clearLocked();
        }
    }

    public void setLocked() {
        if (this.locked || this.fluid == null) {
            return;
        }
        this.locked = true;
    }

    public void clearLocked() {
        this.locked = false;
        if (this.getFluidAmount() <= 0) {
            this.fluid = null;
        }
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void modifyFluidStored(int amount) {
        this.fluid.amount += amount;
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        } else if (this.fluid.amount < 0) {
            this.fluid.amount = 0;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getSpace() {
        if (this.fluid == null) {
            return this.capacity;
        }
        return this.fluid.amount >= this.capacity ? 0 : this.capacity - this.fluid.amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0) {
                if (this.locked) {
                    this.fluid.amount = 0;
                } else {
                    this.fluid = null;
                }
            }
        }
        return stack;
    }
}

