/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CorePotions {
    public static final CorePotions INSTANCE = new CorePotions();
    public static PotionType haste;
    public static PotionType hasteLong;
    public static PotionType hasteStrong;
    public static PotionType resistance;
    public static PotionType resistanceLong;
    public static PotionType resistanceStrong;
    public static PotionType levitation;
    public static PotionType levitationLong;
    public static PotionType absorption;
    public static PotionType absorptionLong;
    public static PotionType absorptionStrong;
    public static PotionType wither;
    public static PotionType witherLong;
    public static PotionType witherStrong;

    private CorePotions() {
    }

    public static void preInit() {
        int duration = 3600;
        int durationLong = 9600;
        int durationStrong = 1800;
        haste = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, duration)});
        hasteLong = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, durationLong)});
        hasteStrong = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, durationStrong, 1)});
        resistance = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, duration)});
        resistanceLong = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, durationLong)});
        resistanceStrong = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, durationStrong, 1)});
        levitation = new PotionType("levitation", new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, duration)});
        levitationLong = new PotionType("levitation", new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, durationLong)});
        absorption = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, duration)});
        absorptionLong = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, durationLong)});
        absorptionStrong = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, durationStrong, 1)});
        wither = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, duration / 4)});
        witherLong = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 2 * duration / 4)});
        witherStrong = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, durationStrong / 4, 1)});
        haste.setRegistryName("haste");
        hasteLong.setRegistryName("haste+");
        hasteStrong.setRegistryName("haste2");
        resistance.setRegistryName("resistance");
        resistanceLong.setRegistryName("resistance+");
        resistanceStrong.setRegistryName("resistance2");
        levitation.setRegistryName("levitation");
        levitationLong.setRegistryName("levitation+");
        absorption.setRegistryName("absorption");
        absorptionLong.setRegistryName("absorption+");
        absorptionStrong.setRegistryName("absorption2");
        wither.setRegistryName("wither");
        witherLong.setRegistryName("wither+");
        witherStrong.setRegistryName("wither2");
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        event.getRegistry().register((IForgeRegistryEntry)haste);
        event.getRegistry().register((IForgeRegistryEntry)hasteLong);
        event.getRegistry().register((IForgeRegistryEntry)hasteStrong);
        event.getRegistry().register((IForgeRegistryEntry)resistance);
        event.getRegistry().register((IForgeRegistryEntry)resistanceLong);
        event.getRegistry().register((IForgeRegistryEntry)resistanceStrong);
        event.getRegistry().register((IForgeRegistryEntry)levitation);
        event.getRegistry().register((IForgeRegistryEntry)levitationLong);
        event.getRegistry().register((IForgeRegistryEntry)absorption);
        event.getRegistry().register((IForgeRegistryEntry)absorptionLong);
        event.getRegistry().register((IForgeRegistryEntry)absorptionStrong);
        event.getRegistry().register((IForgeRegistryEntry)wither);
        event.getRegistry().register((IForgeRegistryEntry)witherLong);
        event.getRegistry().register((IForgeRegistryEntry)witherStrong);
        int min = 3;
        int max = 5;
        this.createStrongPotionTypes(event, PotionTypes.field_185238_j, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185243_o, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185250_v, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185252_x, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185254_z, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185220_C, 3, 5);
        this.createStrongPotionTypes(event, PotionTypes.field_185223_F, 3, 5);
        this.createStrongPotionTypes(event, haste, 3, Math.min(5, 4));
        this.createStrongPotionTypes(event, resistance, 3, 5);
        this.createStrongPotionTypes(event, absorption, 3, 5);
        this.createStrongPotionTypes(event, wither, 3, 5);
    }

    public void createStrongPotionTypes(RegistryEvent.Register<PotionType> event, PotionType type, int minAmplifier, int maxAmplifier) {
        List baseEffects = type.func_185170_a();
        String baseName = type.func_185174_b("");
        if (baseEffects.isEmpty()) {
            return;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (int i = minAmplifier; i <= maxAmplifier; ++i) {
            effects.clear();
            for (PotionEffect effect : baseEffects) {
                effects.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / (1 + i), i - 1));
            }
            PotionType potion = new PotionType(baseName, effects.toArray(new PotionEffect[effects.size()]));
            potion.setRegistryName(baseName + i);
            event.getRegistry().register((IForgeRegistryEntry)potion);
        }
    }
}

