/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.item.tool.ItemToolCore;
import cofh.core.util.RayTracer;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemHammerCore
extends ItemToolCore {
    public ItemHammerCore(Item.ToolMaterial toolMaterial) {
        super(4.0f, -3.4f, toolMaterial);
        this.addToolClass("pickaxe");
        this.addToolClass("hammer");
        this.func_77656_e(toolMaterial.func_77997_a() * 2);
        this.field_150914_c.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
        if (this.harvestLevel > 0) {
            this.field_77865_bY = 10.0f;
            this.field_185065_c = -3.5f + 0.1f * (float)this.harvestLevel;
        } else {
            this.field_77865_bY = 7.0f;
            this.field_185065_c = -3.4f + 0.1f * (float)((int)(this.field_77864_a / 5.0f));
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        int used = 0;
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace(player);
            if (traceResult == null) {
                return false;
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                        for (z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (x == pos.func_177958_n() && z == pos.func_177952_p() || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 10.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++used;
                        }
                    }
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    for (x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                        for (y = pos.func_177956_o() - 1; y <= pos.func_177956_o() + 1; ++y) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (x == pos.func_177958_n() && y == pos.func_177956_o() || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 10.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++used;
                        }
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    for (y = pos.func_177956_o() - 1; y <= pos.func_177956_o() + 1; ++y) {
                        for (z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (y == pos.func_177956_o() && z == pos.func_177952_p() || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 10.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++used;
                        }
                    }
                    break;
                }
            }
            if (used > 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(used, (EntityLivingBase)player);
            }
        }
        return false;
    }
}

