/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.achievements.Achievements;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.entity.DragonChunkLoader;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.entity.EntityChaosImplosion;
import com.brandon3055.draconicevolution.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.entity.EntityEnderEnergyManipulator;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.entity.EntityGuardianProjectile;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.handlers.ContributorHandler;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.integration.computers.CCOCIntegration;
import com.brandon3055.draconicevolution.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.brandon3055.draconicevolution.magic.EnchantmentReaper;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import com.brandon3055.draconicevolution.network.PacketConfigureTool;
import com.brandon3055.draconicevolution.network.PacketContributor;
import com.brandon3055.draconicevolution.network.PacketDislocator;
import com.brandon3055.draconicevolution.network.PacketExplosionFX;
import com.brandon3055.draconicevolution.network.PacketLootSync;
import com.brandon3055.draconicevolution.network.PacketPlaceItem;
import com.brandon3055.draconicevolution.network.PacketPlaySound;
import com.brandon3055.draconicevolution.network.PacketShieldHit;
import com.brandon3055.draconicevolution.network.PacketSimpleBoolean;
import com.brandon3055.draconicevolution.network.PacketToolProfile;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        RecipeManager.initialize();
        this.registerEventListeners(event.getSide());
        ContributorHandler.init();
        this.registerTileEntities();
        this.initializeNetwork();
        this.registerOres();
        EnchantmentReaper.init();
        LogHelper.info("Finished PreInitialization");
    }

    public void init(FMLInitializationEvent event) {
        this.registerGuiHandeler();
        this.registerEntities();
        CCOCIntegration.init();
        ModHelper.init();
        DragonChunkLoader.init();
        LogHelper.info("Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        OreDoublingRegistry.init();
        Achievements.registerAchievementPane();
        LogHelper.info("Finished PostInitialization");
    }

    public void initializeNetwork() {
        DraconicEvolution.network = NetworkRegistry.INSTANCE.newSimpleChannel("DEvolutionNC");
        DraconicEvolution.network.registerMessage(PacketSimpleBoolean.Handler.class, PacketSimpleBoolean.class, 0, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketConfigureTool.Handler.class, PacketConfigureTool.class, 1, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketPlaySound.Handler.class, PacketPlaySound.class, 2, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketShieldHit.Handler.class, PacketShieldHit.class, 3, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketDislocator.Handler.class, PacketDislocator.class, 4, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketPlaceItem.Handler.class, PacketPlaceItem.class, 5, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketLootSync.Handler.class, PacketLootSync.class, 6, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketToolProfile.Handler.class, PacketToolProfile.class, 7, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketContributor.Handler.class, PacketContributor.class, 8, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketContributor.Handler.class, PacketContributor.class, 9, Side.SERVER);
        DraconicEvolution.network.registerMessage(CrystalUpdateBatcher.Handler.class, CrystalUpdateBatcher.class, 10, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketExplosionFX.Handler.class, PacketExplosionFX.class, 11, Side.CLIENT);
    }

    public void registerTileEntities() {
    }

    public void registerEventListeners(Side s) {
        MinecraftForge.EVENT_BUS.register((Object)new DEEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new Achievements());
        MinecraftForge.EVENT_BUS.register((Object)new CustomArmorHandler());
    }

    public void registerGuiHandeler() {
    }

    public void registerOres() {
    }

    public void registerEntities() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "PersistentItem"), EntityPersistentItem.class, (String)"draconicevolution:PersistentItem", (int)1, (Object)DraconicEvolution.instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "DragonHeartItem"), EntityDragonHeart.class, (String)"draconicevolution:DragonHeartItem", (int)5, (Object)DraconicEvolution.instance, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "ChaosGuardian"), EntityChaosGuardian.class, (String)"draconicevolution:ChaosGuardian", (int)6, (Object)DraconicEvolution.instance, (int)512, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "GuardianProjectile"), EntityGuardianProjectile.class, (String)"draconicevolution:GuardianProjectile", (int)7, (Object)DraconicEvolution.instance, (int)256, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "GuardianCrystal"), EntityGuardianCrystal.class, (String)"draconicevolution:GuardianCrystal", (int)8, (Object)DraconicEvolution.instance, (int)256, (int)5, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "EntityChaosEnergyVortex"), EntityChaosImplosion.class, (String)"draconicevolution:EntityChaosEnergyVortex", (int)10, (Object)DraconicEvolution.instance, (int)512, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "CustomArrow"), EntityCustomArrow.class, (String)"draconicevolution:CustomArrow", (int)11, (Object)DraconicEvolution.instance, (int)128, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "LootCore"), EntityLootCore.class, (String)"draconicevolution:LootCore", (int)12, (Object)DraconicEvolution.instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("draconicevolution", "EnderEnergyManipulator"), EntityEnderEnergyManipulator.class, (String)"draconicevolution:EnderEnergyManipulator", (int)13, (Object)DraconicEvolution.instance, (int)128, (int)5, (boolean)true);
    }

    public void registerParticles() {
        DEParticles.registerServer();
    }

    public ENetFXHandler createENetFXHandler(TileCrystalBase tile) {
        return tile.createServerFXHandler();
    }

    public ReactorEffectHandler createReactorFXHandler(TileReactorCore tile) {
        return null;
    }

    public ISound playISound(ISound sound) {
        return null;
    }
}

