/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BooleanConfigField
extends IntegerConfigField {
    private String onTxt = "config.field.on.state";
    private String offTxt = "config.field.off.state";

    public BooleanConfigField(String name, Boolean value, String description) {
        super(name, value != false ? 1 : 0, 0, 1, description, IItemConfigField.EnumControlType.TOGGLE);
    }

    public BooleanConfigField setOnOffTxt(String onTxt, String offTxt) {
        this.onTxt = onTxt;
        this.offTxt = offTxt;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getReadableValue() {
        return this.value == 1 ? I18n.func_135052_a((String)this.onTxt, (Object[])new Object[0]) : I18n.func_135052_a((String)this.offTxt, (Object[])new Object[0]);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a(this.name, this.value == 1);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.value = compound.func_74767_n(this.name) ? 1 : 0;
    }

    @Override
    public void handleButton(IItemConfigField.EnumButton button, int data) {
        this.value = this.value == 0 ? 1 : 0;
        LogHelper.dev(this.value);
    }
}

