/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiBackground;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTexturedPointer;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IJEIClearence;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.inventory.ContainerReactor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;

public class GuiReactor
extends ModularGuiContainer<ContainerReactor>
implements IMGuiListener,
IJEIClearence {
    private EntityPlayer player;
    private final TileReactorCore tile;
    public TileReactorComponent component = null;
    private static double compPanelAnim = 0.0;
    private static boolean compPanelExtended = false;
    private MGuiElementBase compPanel;

    public GuiReactor(EntityPlayer player, TileReactorCore tile) {
        super((Container)new ContainerReactor(player, tile));
        this.player = player;
        this.tile = tile;
        this.field_146999_f = 248;
        this.field_147000_g = 222;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.manager.clear();
        this.compPanel = new MGuiBorderedRect((IModularGui)this, this.field_147003_i + this.field_146999_f, this.field_147009_r + 125, 0, 91);
        this.manager.add(this.compPanel);
        this.manager.add((MGuiElementBase)new MGuiBackground((IModularGui)this, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g, "draconicevolution:textures/gui/reactor.png"){

            public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                super.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
                RenderTileReactorCore.renderGUI(GuiReactor.this.tile, GuiReactor.this.field_147003_i + this.xSize / 2, GuiReactor.this.field_147009_r + 70);
            }
        });
        this.manager.add((MGuiElementBase)new MGuiBorderedRect((IModularGui)this, this.field_147003_i + 12, this.field_147009_r + 138, 162, 77){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD;
            }
        });
        int y = this.field_147009_r + 140;
        this.manager.add(new MGuiLabel((IModularGui)this, this.field_147003_i + 10, y, 162, 8, I18n.func_135052_a((String)"gui.reactor.coreVolume.info", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(49407).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.coreVolume.txt", (Object[])new Object[0])}).setHoverDelay(2)));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 13, y += 8, 162, 8, ""){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }

            public String getDisplayString() {
                return Utils.round((double)((((GuiReactor)GuiReactor.this).tile.reactableFuel.value + ((GuiReactor)GuiReactor.this).tile.convertedFuel.value) / 1296.0), (double)100.0) + "m^3";
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        this.manager.add(new MGuiLabel((IModularGui)this, this.field_147003_i + 10, y += 11, 162, 8, I18n.func_135052_a((String)"gui.reactor.genRate.info", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(49407).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.genRate.txt", (Object[])new Object[0])}).setHoverDelay(2)));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 13, y += 8, 162, 8, ""){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }

            public String getDisplayString() {
                return Utils.addCommas((int)((int)((GuiReactor)GuiReactor.this).tile.generationRate.value)) + " RF/t";
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        this.manager.add(new MGuiLabel((IModularGui)this, this.field_147003_i + 10, y += 11, 162, 8, I18n.func_135052_a((String)"gui.reactor.fieldInputRate.info", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(49407).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.inputRate.txt", (Object[])new Object[0])}).setHoverDelay(2)));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 13, y += 8, 162, 8, ""){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }

            public String getDisplayString() {
                double inputRate = (double)((GuiReactor)GuiReactor.this).tile.fieldDrain.value / (1.0 - ((GuiReactor)GuiReactor.this).tile.shieldCharge.value / ((GuiReactor)GuiReactor.this).tile.maxShieldCharge.value);
                return Utils.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + "RF/t";
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        this.manager.add(new MGuiLabel((IModularGui)this, this.field_147003_i + 10, y += 11, 162, 8, I18n.func_135052_a((String)"gui.reactor.fuelConversionRate.info", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(49407).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.conversionRate.txt", (Object[])new Object[0])}).setHoverDelay(2)));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 13, y += 8, 162, 8, ""){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }

            public String getDisplayString() {
                return Utils.addCommas((int)((int)Math.round(((GuiReactor)GuiReactor.this).tile.fuelUseRate.value * 1000000.0))) + "nb/t";
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 13, this.field_147009_r + 139, 161, 77, "Emergency shield reserve is now active but it wont last long! There is no way to stop the overload the stabilizers are fried. I suggest you run!"){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setWrap(true).setAlignment(EnumAlignment.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        this.manager.add(new MGuiElementBase((IModularGui)this){

            public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                if (((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.COLD) {
                    int x;
                    GuiHelper.drawPlayerSlots((Gui)GuiReactor.this, (int)(GuiReactor.this.field_147003_i + 43 - 31), (int)(GuiReactor.this.field_147009_r + 139), (boolean)false);
                    ResourceHelperBC.bindTexture((String)"textures/gui/bc_widgets.png");
                    for (x = 0; x < 3; ++x) {
                        this.drawTexturedModalRect(GuiReactor.this.field_147003_i + 182 + x * 18, GuiReactor.this.field_147009_r + 148, 138, 0, 18, 18);
                    }
                    for (x = 0; x < 3; ++x) {
                        this.drawTexturedModalRect(GuiReactor.this.field_147003_i + 182 + x * 18, GuiReactor.this.field_147009_r + 179, 138, 0, 18, 18);
                    }
                }
            }
        });
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i, this.field_147009_r + 2, this.field_146999_f, 12, I18n.func_135052_a((String)"gui.reactor.draconicReactor.txt", (Object[])new Object[0])).setAlignment(EnumAlignment.CENTER).setTextColour(65535));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 182, this.field_147009_r + 139, 54, 8, I18n.func_135052_a((String)"gui.reactor.fuelIn.txt", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.COLD;
            }
        }.setAlignment(EnumAlignment.CENTER));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 182, this.field_147009_r + 170, 54, 8, I18n.func_135052_a((String)"gui.reactor.chaosOut.txt", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.COLD;
            }
        }.setAlignment(EnumAlignment.CENTER));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 7, this.field_147009_r + 127, this.field_146999_f, 12, ""){

            public String getDisplayString() {
                String s = ((TileReactorCore.ReactorState)((GuiReactor)GuiReactor.this).tile.reactorState.value).localize();
                if (((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE && ClientEventHandler.elapsedTicks % 10 > 5) {
                    s = TextFormatting.DARK_RED + "**" + s + "**";
                } else if (((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE) {
                    s = TextFormatting.DARK_RED + "--" + s + "--";
                }
                return TextFormatting.GOLD + I18n.func_135052_a((String)"gui.reactor.status.info", (Object[])new Object[0]) + ": " + s;
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public boolean getDropShadow() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setAlignment(EnumAlignment.LEFT));
        this.manager.add(new MGuiTexturedPointer((IModularGui)this, this.field_147003_i + 11, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.temperature.value / 10000.0), (double)0.0, (double)1.0);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                return GuiReactor.this.getTempStats();
            }
        }.setHoverDelay(5)));
        this.manager.add(new MGuiTexturedPointer((IModularGui)this, this.field_147003_i + 35, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.shieldCharge.value / Math.max(((GuiReactor)GuiReactor.this).tile.maxShieldCharge.value, 1.0)), (double)0.0, (double)1.0);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                return GuiReactor.this.getShieldStats();
            }
        }.setHoverDelay(5)));
        this.manager.add(new MGuiTexturedPointer((IModularGui)this, this.field_147003_i + 199, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)((double)((GuiReactor)GuiReactor.this).tile.saturation.value / (double)Math.max(((GuiReactor)GuiReactor.this).tile.maxSaturation.value, 1)), (double)0.0, (double)1.0);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                return GuiReactor.this.getSaturationStats();
            }
        }.setHoverDelay(5)));
        this.manager.add(new MGuiTexturedPointer((IModularGui)this, this.field_147003_i + 223, this.field_147009_r + 5, 14, 112, 0, 222, 5, ResourceHelperDE.getResource("textures/gui/reactor.png")){

            public double getPos() {
                return MathHelper.clip((double)(((GuiReactor)GuiReactor.this).tile.convertedFuel.value / Math.max(((GuiReactor)GuiReactor.this).tile.reactableFuel.value + ((GuiReactor)GuiReactor.this).tile.convertedFuel.value, 1.0)), (double)0.0, (double)1.0);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                return GuiReactor.this.getFuelStats();
            }
        }.setHoverDelay(5)));
        this.manager.add((MGuiElementBase)new MGuiButtonSolid((IModularGui)this, "CHARGE", this.field_147003_i + 182, this.field_147009_r + 199, 54, 14, I18n.func_135052_a((String)"gui.reactor.charge.btn", (Object[])new Object[0])){

            public boolean isEnabled() {
                return GuiReactor.this.tile.canCharge();
            }
        });
        this.manager.add((MGuiElementBase)new MGuiButtonSolid((IModularGui)this, "ACTIVATE", this.field_147003_i + 182, this.field_147009_r + 182, 54, 14, I18n.func_135052_a((String)"gui.reactor.activate.btn", (Object[])new Object[0])){

            public boolean isEnabled() {
                return GuiReactor.this.tile.canActivate();
            }
        });
        this.manager.add((MGuiElementBase)new MGuiButtonSolid((IModularGui)this, "SHUTDOWN", this.field_147003_i + 182, this.field_147009_r + 199, 54, 14, I18n.func_135052_a((String)"gui.reactor.shutdown.btn", (Object[])new Object[0])){

            public boolean isEnabled() {
                return GuiReactor.this.tile.canStop();
            }
        });
        this.manager.add(new MGuiButtonSolid((IModularGui)this, "FAIL_SAFE", this.field_147003_i + 182, this.field_147009_r + 165, 54, 14, I18n.func_135052_a((String)"gui.reactor.failSafe.btn", (Object[])new Object[0])){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }

            public void onPressed(int mouseX, int mouseY, int mouseButton) {
                GuiReactor.this.tile.toggleFailSafe();
            }

            public int getFillColour(boolean hovering, boolean disabled) {
                if (((GuiReactor)GuiReactor.this).tile.failSafeMode.value) {
                    return -12566273;
                }
                return super.getFillColour(hovering, disabled);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.failSafe.txt", (Object[])new Object[0])})));
        this.manager.add(new MGuiLabel((IModularGui)this, this.field_147003_i + 180, this.field_147009_r + 138, 58, 24, I18n.func_135052_a((String)"gui.reactor.rsMode.btn", (Object[])new Object[0]).replaceAll("\\\\n", "\n")){

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.COLD && GuiReactor.this.component != null && ((GuiReactor)GuiReactor.this).tile.reactorState.value != TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setWrap(true).addChild((MGuiElementBase)new MGuiButtonSolid((IModularGui)this, "TOGGLE_COMP_P", this.field_147003_i + 182, this.field_147009_r + 138, 54, 24, ""){

            public String getDisplayString() {
                return super.getDisplayString();
            }
        }).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.reactor.redstoneMode.txt", (Object[])new Object[0])})));
        this.manager.add((MGuiElementBase)new MGuiLabel((IModularGui)this, this.field_147003_i + 175, this.field_147009_r + 138, 68, 80, "ETE"){

            public String getDisplayString() {
                return "Estimated\nTime\nUntil\nDetonation\n\n" + TextFormatting.UNDERLINE + (((GuiReactor)GuiReactor.this).tile.explosionCountdown.value >= 0 ? ((GuiReactor)GuiReactor.this).tile.explosionCountdown.value / 20 + "s" : "Calculating..");
            }

            public boolean isEnabled() {
                return ((GuiReactor)GuiReactor.this).tile.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE;
            }
        }.setWrap(true).setTextColour(0xFF0000).setShadow(false));
        y = 0;
        for (final TileReactorComponent.RSMode mode : TileReactorComponent.RSMode.values()) {
            this.manager.add(new MGuiButtonSolid((IModularGui)this, "RS_T", this.field_147003_i + this.field_146999_f + 2, this.field_147009_r + 127 + y, 66, 10, I18n.func_135052_a((String)("gui.reactor.rsMode_" + mode.name().toLowerCase() + ".btn"), (Object[])new Object[0])){

                public boolean isEnabled() {
                    return compPanelAnim == 1.0 && GuiReactor.this.component != null;
                }

                public int getFillColour(boolean hovering, boolean disabled) {
                    if (GuiReactor.this.component != null && GuiReactor.this.component.rsMode.value == mode) {
                        return -5636096;
                    }
                    if (hovering) {
                        return -10132123;
                    }
                    return super.getFillColour(hovering, disabled);
                }

                public int getBorderColour(boolean hovering, boolean disabled) {
                    return this.getFillColour(hovering, disabled);
                }

                public void onPressed(int mouseX, int mouseY, int mouseButton) {
                    if (GuiReactor.this.component != null) {
                        GuiReactor.this.component.setRSMode(GuiReactor.this.player, mode);
                    }
                }
            }.setColours(-12237499, -12237499, -12237499).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)("gui.reactor.rsMode_" + mode.name().toLowerCase() + ".txt"), (Object[])new Object[0])})));
            y += 11;
        }
        this.manager.initElements();
    }

    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        if (eventElement instanceof MGuiButton) {
            if (((MGuiButton)eventElement).buttonName.equals("CHARGE")) {
                this.tile.chargeReactor();
            } else if (((MGuiButton)eventElement).buttonName.equals("ACTIVATE")) {
                this.tile.activateReactor();
            } else if (((MGuiButton)eventElement).buttonName.equals("SHUTDOWN")) {
                this.tile.shutdownReactor();
            } else if (((MGuiButton)eventElement).buttonName.equals("TOGGLE_COMP_P")) {
                compPanelExtended = !compPanelExtended;
            }
        }
    }

    public List<String> getTempStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.reactor.reactionTemp.info", (Object[])new Object[0]));
        list.add(Utils.round((double)this.tile.temperature.value, (double)10.0) + "C");
        return list;
    }

    public List<String> getShieldStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.reactor.fieldStrength.info", (Object[])new Object[0]));
        if (this.tile.maxShieldCharge.value > 0.0) {
            list.add(Utils.round((double)(this.tile.shieldCharge.value / this.tile.maxShieldCharge.value * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((int)((int)this.tile.shieldCharge.value)) + " / " + Utils.addCommas((int)((int)this.tile.maxShieldCharge.value)));
        return list;
    }

    public List<String> getSaturationStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.reactor.energySaturation.info", (Object[])new Object[0]));
        if (this.tile.maxSaturation.value > 0) {
            list.add(Utils.round((double)((double)this.tile.saturation.value / (double)this.tile.maxSaturation.value * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((int)this.tile.saturation.value) + " / " + Utils.addCommas((int)this.tile.maxSaturation.value));
        return list;
    }

    public List<String> getFuelStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"gui.reactor.fuelConversion.info", (Object[])new Object[0]));
        if (this.tile.reactableFuel.value + this.tile.convertedFuel.value > 0.0) {
            list.add(Utils.round((double)(this.tile.convertedFuel.value / (this.tile.reactableFuel.value + this.tile.convertedFuel.value) * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.round((double)this.tile.convertedFuel.value, (double)100.0) + " / " + Utils.round((double)(this.tile.convertedFuel.value + this.tile.reactableFuel.value), (double)100.0));
        return list;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.tile.reactorState.value == TileReactorCore.ReactorState.COLD != ((ContainerReactor)this.container).fuelSlots) {
            ((ContainerReactor)this.container).setSlotState();
        }
        if (compPanelExtended && (compPanelAnim < 1.0 || this.compPanel.xSize != 70)) {
            if ((compPanelAnim += 0.1) > 1.0) {
                compPanelAnim = 1.0;
            }
            this.compPanel.xSize = (int)(compPanelAnim * 70.0);
        } else if (!compPanelExtended && compPanelAnim > 0.0) {
            if ((compPanelAnim -= 0.1) < 0.0) {
                compPanelAnim = 0.0;
            }
            this.compPanel.xSize = (int)(compPanelAnim * 70.0);
        }
        if (this.compPanel.isEnabled() && compPanelAnim == 0.0) {
            this.compPanel.setEnabled(false);
        } else if (!this.compPanel.isEnabled() && compPanelAnim > 0.0) {
            this.compPanel.setEnabled(true);
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        if (this.compPanel == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Rectangle(this.compPanel.xPos, this.compPanel.yPos, this.compPanel.xSize, this.compPanel.ySize));
    }
}

