/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiPopUpDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.client.Minecraft;

public class PopupEditMod
extends MGuiPopUpDialog
implements IMGuiListener {
    private final TreeBranchContent branch;
    public MGuiTextField nameField;
    public MGuiButtonSolid okButton;
    public MGuiButtonSolid cancelButton;
    public MGuiButtonSolid deleteButton;
    public MGuiButtonSolid confirmYes;
    public MGuiButtonSolid confirmNo;
    public MGuiLabel errorLabel;

    public PopupEditMod(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize, MGuiList parent, TreeBranchContent branch) {
        super(modularGui, xPos, yPos, xSize, ySize, (MGuiElementBase)parent);
        this.branch = branch;
    }

    public void initElement() {
        int y = this.yPos + 2;
        MGuiLabel label = new MGuiLabel(this.modularGui, this.xPos, y, this.xSize, 12, "Edit Name").setAlignment(EnumAlignment.LEFT);
        this.addChild((MGuiElementBase)label);
        this.nameField = new MGuiTextField(this.modularGui, this.xPos + 2, y += 12, this.xSize - 4, 16, this.modularGui.getMinecraft().field_71466_p);
        this.addChild((MGuiElementBase)this.nameField);
        this.nameField.setText(this.branch.branchName);
        this.okButton = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "OK", this.xPos + 2, y += 30, this.xSize / 2 - 2, 14, "OK").setColours(-16736256, -16777216, -1).setListener((IMGuiListener)this);
        this.addChild((MGuiElementBase)this.okButton);
        this.cancelButton = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "CANCEL", this.xPos + 1 + this.xSize / 2, y, this.xSize / 2 - 2, 14, "Cancel").setColours(-11517888, -16777216, -1).setListener((IMGuiListener)this);
        this.addChild((MGuiElementBase)this.cancelButton);
        this.deleteButton = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "DELETE", this.xPos + 1 + this.xSize / 2, this.yPos + this.ySize - 16, this.xSize / 2 - 2, 14, "Delete").setColours(-65536, -16777216, -1).setListener((IMGuiListener)this);
        this.addChild((MGuiElementBase)this.deleteButton);
        MGuiLabel confirm = new MGuiLabel(this.modularGui, this.xPos, this.yPos + this.ySize - 30, this.xSize, 12, "Are You Sure?");
        confirm.id = "CONFIRM_LABEL";
        this.addChild((MGuiElementBase)confirm);
        this.setChildIDEnabled("CONFIRM_LABEL", false);
        this.confirmYes = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "DELETE_YES", this.xPos + 2, this.yPos + this.ySize - 16, this.xSize / 2 - 2, 14, "Yes").setColours(-65536, -16777216, -1).setListener((IMGuiListener)this);
        this.addChild((MGuiElementBase)this.confirmYes);
        this.confirmNo = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "DELETE_NO", this.xPos + 1 + this.xSize / 2, this.yPos + this.ySize - 16, this.xSize / 2 - 2, 14, "No").setColours(-65536, -16777216, -1).setListener((IMGuiListener)this);
        this.addChild((MGuiElementBase)this.confirmNo);
        this.confirmYes.setEnabled(false);
        this.confirmNo.setEnabled(false);
        this.addChild((MGuiElementBase)new MGuiLabel(this.modularGui, this.xPos, y, this.xSize, 100, "Mod ID can only be edited manually because its tied to every single branch. If you need to edit it I recommend opening the xml and Find&Replace modid: with newmodid:").setWrap(true));
        this.errorLabel = new MGuiLabel(this.modularGui, this.xPos, y += 80, this.xSize, 100, "").setWrap(true).setAlignment(EnumAlignment.LEFT).setTextColour(-65536);
        this.addChild((MGuiElementBase)this.errorLabel);
        this.errorLabel.setEnabled(true);
        super.initElement();
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 1.0, -14540254, -5636096);
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.errorLabel.setEnabled(false);
        return this.isMouseOver(mouseX, mouseY);
    }

    public void onMGuiEvent(String event, MGuiElementBase element) {
        if (element == this.okButton) {
            try {
                this.editModBranch(this.nameField.getText(), false);
                this.close();
            }
            catch (Exception e) {
                this.errorLabel.setEnabled(true);
                this.errorLabel.setDisplayString("Something went wrong while saving changes...\n\n" + e.getMessage() + "\n\nSee console for stack trace");
                e.printStackTrace();
            }
        } else if (element == this.cancelButton) {
            this.close();
        } else if (element == this.deleteButton) {
            this.setChildIDEnabled("CONFIRM_LABEL", true);
            this.confirmYes.setEnabled(true);
            this.confirmNo.setEnabled(true);
            this.deleteButton.setEnabled(false);
        } else if (element == this.confirmYes) {
            try {
                this.editModBranch("", true);
                this.close();
            }
            catch (Exception e) {
                this.errorLabel.setDisplayString("Something went wrong while deleting the mod...\n\n" + e.getMessage() + "\n\nSee console for stack trace");
                e.printStackTrace();
            }
        } else if (element == this.confirmNo) {
            this.setChildIDEnabled("CONFIRM_LABEL", false);
            this.confirmYes.setEnabled(false);
            this.confirmNo.setEnabled(false);
            this.deleteButton.setEnabled(true);
        }
    }

    public void close() {
        ((MGuiList)this.parent).disableList = false;
        this.parent.removeChild((MGuiElementBase)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void editModBranch(String newName, boolean delete) throws Exception {
        if (delete) {
            File modXML = WikiDocManager.documentToFileMap.get(this.branch.branchData.getOwnerDocument());
            if (modXML == null || !modXML.exists()) throw new FileNotFoundException("Could not find the file to delete... Maby hit the reload button and try again. If that fails delete the file manually.");
            if (!modXML.delete()) throw new Exception("For some reason the file return false when deleting meaning it did not delete. Not sure why. Maby try deleting it manually");
            WikiDocManager.reload(true, true, true);
            return;
        } else {
            if (this.branch.branchName.equals(newName)) return;
            this.branch.branchName = newName;
            this.branch.branchData.setAttribute("modName", this.branch.branchName);
            WikiDocManager.saveChanges(this.branch.branchData.getOwnerDocument());
            WikiDocManager.reload(true, true, true);
        }
    }
}

