/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class CrystalFXLink
extends CrystalGLFXBase<TileCrystalBase> {
    private final Vec3D linkTarget;
    private final boolean terminateSource;
    private final boolean terminateTarget;
    public int timeout = 0;
    private static final FXHandler HANDLER = new FXHandler();

    public CrystalFXLink(World worldIn, TileCrystalBase tile, Vec3D linkTarget) {
        super(worldIn, tile);
        EnumFacing face;
        this.field_94054_b = 3 + tile.getTier();
        this.field_70546_d = worldIn.field_73012_v.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget.getPos()));
        this.terminateSource = true;
        this.linkTarget = linkTarget;
        EnumFacing enumFacing = face = tile instanceof TileCrystalWirelessIO ? ((TileCrystalWirelessIO)tile).getReceiversFaces().get(linkTarget.getPos()) : null;
        if (face != null) {
            linkTarget.add((double)face.func_82601_c() * 0.6, (double)face.func_96559_d() * 0.6, (double)face.func_82599_e() * 0.6);
        }
        this.terminateTarget = true;
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void func_189213_a() {
        if (!ClientEventHandler.playerHoldingWrench && this.timeout <= 0) {
            this.func_187112_i();
        } else if (this.timeout > 0) {
            --this.timeout;
        }
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double scale = 0.1 + (double)this.timeout * 0.005;
        Vector3 source = new Vector3(this.field_187126_f - field_70556_an, this.field_187127_g - field_70554_ao, this.field_187128_h - field_70555_ap);
        Vector3 target = this.linkTarget.toVector3().subtract(field_70556_an, field_70554_ao, field_70555_ap);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        double dist = 0.2 * Utils.getDistanceAtoB((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        double anim = (double)((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        scale *= 2.0;
        double minU = 0.0;
        double maxU = 0.53;
        double minV = 0.0;
        double maxV = 0.53;
        if (this.terminateSource) {
            buffer.func_181662_b(source.x - (double)rotationX * scale - (double)rotationXY * scale, source.y - (double)rotationZ * scale, source.z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(maxU, maxV).func_181675_d();
            buffer.func_181662_b(source.x - (double)rotationX * scale + (double)rotationXY * scale, source.y + (double)rotationZ * scale, source.z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(maxU, minV).func_181675_d();
            buffer.func_181662_b(source.x + (double)rotationX * scale + (double)rotationXY * scale, source.y + (double)rotationZ * scale, source.z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(minU, minV).func_181675_d();
            buffer.func_181662_b(source.x + (double)rotationX * scale - (double)rotationXY * scale, source.y - (double)rotationZ * scale, source.z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(minU, maxV).func_181675_d();
        }
        if (this.terminateTarget) {
            buffer.func_181662_b(target.x - (double)rotationX * scale - (double)rotationXY * scale, target.y - (double)rotationZ * scale, target.z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(maxU, maxV).func_181675_d();
            buffer.func_181662_b(target.x - (double)rotationX * scale + (double)rotationXY * scale, target.y + (double)rotationZ * scale, target.z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(maxU, minV).func_181675_d();
            buffer.func_181662_b(target.x + (double)rotationX * scale + (double)rotationXY * scale, target.y + (double)rotationZ * scale, target.z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(minU, minV).func_181675_d();
            buffer.func_181662_b(target.x + (double)rotationX * scale - (double)rotationXY * scale, target.y - (double)rotationZ * scale, target.z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(minU, maxV).func_181675_d();
        }
    }

    private void bufferQuad(BufferBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, double anim, double dist) {
        buffer.func_181662_b(p1.x, p1.y, p1.z).func_187315_a(0.5, anim).func_181675_d();
        buffer.func_181662_b(p2.x, p2.y, p2.z).func_187315_a(0.5, dist + anim).func_181675_d();
        buffer.func_181662_b(p4.x, p4.y, p4.z).func_187315_a(1.0, dist + anim).func_181675_d();
        buffer.func_181662_b(p3.x, p3.y, p3.z).func_187315_a(1.0, anim).func_181675_d();
    }

    public IGLFXHandler getFXHandler() {
        return HANDLER;
    }

    public static class FXHandler
    implements IGLFXHandler {
        public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            GlStateTracker.pushState();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
            GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            ResourceHelperDE.bindTexture("textures/particle/energy_beam_basic.png");
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }

        public void postDraw(int layer, BufferBuilder vertexbuffer, Tessellator tessellator) {
            tessellator.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateTracker.popState();
        }
    }
}

