/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderLootCore
extends Render<EntityLootCore> {
    public RenderLootCore(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityLootCore entity, double x, double y, double z, float entityYaw, float partialTicks) {
        ResourceHelperDE.bindTexture("textures/items/loot_core.png");
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181710_j);
        float yOffset = MathHelper.func_76126_a((float)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 10.0f)) * 0.1f + 0.1f;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x, y + (double)(entity.field_70131_O / 2.0f) + (double)yOffset, z), (Rotation)new Rotation((double)(((float)(ClientEventHandler.elapsedTicks + entity.timeOffset) + partialTicks) / 30.0f), new Vector3(entity.rotX, entity.rotY, 0.0).normalize()), (double)0.1);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        boolean bl = entity.isLooking = Minecraft.func_71410_x().field_71460_t.field_78528_u == entity;
        if (entity.lookAnimation > 0.0f) {
            float f = this.field_76990_c.field_78735_i;
            float f1 = this.field_76990_c.field_78732_j;
            boolean flag1 = this.field_76990_c.field_78733_k.field_74320_O == 2;
            this.renderLabel(entity, this.func_76983_a(), (float)x, (float)y, (float)z, f, f1, flag1);
        }
    }

    public void renderLabel(EntityLootCore lootCore, FontRenderer renderer, float x, float y, float z, float viewY, float viewX, boolean thirdPerson) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(thirdPerson ? -1 : 1) * viewX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int rows = lootCore.displayMap.size();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double scale = lootCore.lookAnimation;
        double heightScale = Math.min(scale * 2.0, 1.0);
        double widthScale = Math.max((scale - 0.5) * 2.0, 0.0);
        double height = (double)(rows * 8) * heightScale + 1.0;
        double width = widthScale * 40.0;
        double xPos = 10.0 - width / 2.0;
        double yPos = -4.0 - height / 2.0;
        this.renderBox(vertexbuffer, xPos - 1.0, yPos, 1.0, height, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos + width, yPos, 1.0, height, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos - 1.0, yPos - 1.0, width + 2.0, 1.0, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos - 1.0, yPos + height, width + 2.0, 1.0, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos, yPos, width, height, 0x60000000);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (lootCore.lookAnimation >= 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-5.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)9.0f, (float)9.0f, (float)9.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179121_F();
            String name = I18n.func_135052_a((String)"entity.draconicevolution.lootCore.name", (Object[])new Object[0]);
            int w = renderer.func_78256_a(name);
            renderer.func_78276_b(name, 11 - w / 2, -17, -1);
            int row = 0;
            for (ItemStack stack : lootCore.displayMap.keySet()) {
                int rowY = (int)yPos + row * 8 + 4;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-5.0f, (float)rowY, (float)0.0f);
                GlStateManager.func_179152_a((float)9.0f, (float)9.0f, (float)9.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
                renderer.func_78276_b("x" + lootCore.displayMap.get(stack), 0, -4 + rowY, -1);
                ++row;
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void renderBox(BufferBuilder buffer, double x, double y, double width, double height, int colour) {
        ColourARGB colourARGB = new ColourARGB(colour);
        double zLevel = 0.0;
        buffer.func_181662_b(x, y + height, zLevel).func_181666_a((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_181662_b(x + width, y + height, zLevel).func_181666_a((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_181662_b(x + width, y, zLevel).func_181666_a((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_181662_b(x, y, zLevel).func_181666_a((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
    }

    protected ResourceLocation getEntityTexture(EntityLootCore entity) {
        return ResourceHelperDE.getResource("textures/items/loot_core.png");
    }
}

