/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderTileReactorCore
extends TESRBase<TileReactorCore> {
    private static CCModel model = null;
    private static CCModel model_no_shade;
    private static ShaderProgram reactorProgram;
    private static ShaderProgram shieldProgram;

    public RenderTileReactorCore() {
        if (model == null) {
            Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/block/obj_models/reactor_core.obj"));
            model = CCModel.combine(map.values());
            map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/reactor_core_model.obj"));
            model_no_shade = CCModel.combine(map.values());
        }
    }

    public void render(TileReactorCore te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(200.0f);
        double diameter = te.getCoreDiameter();
        float t = (float)(te.temperature.value / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)Utils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)Utils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)Utils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float shieldPower = (float)(te.maxShieldCharge.value > 0.0 ? te.shieldCharge.value / te.maxShieldCharge.value : 0.0);
        if (MinecraftForgeClient.getRenderPass() == 0) {
            float animation = (te.coreAnimation + partialTicks * (float)te.shaderAnimationState.value) / 20.0f;
            RenderTileReactorCore.renderCore(x, y, z, partialTicks, intensity, animation, diameter, DEShaders.useShaders());
        } else if (te.shieldAnimationState > 0.0f) {
            float animation = (te.shieldAnimation + partialTicks * te.shieldAnimationState) / 20.0f;
            float power = 0.7f * shieldPower - (1.0f - te.shieldAnimationState);
            if (te.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE) {
                power = 0.05f;
            }
            RenderTileReactorCore.renderShield(x, y, z, partialTicks, power, animation, diameter, DEShaders.useShaders());
        }
        this.resetLighting();
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(200.0f);
        float scale = 1.3f;
        float animation = 0.0f;
        float intensity = 0.0f;
        RenderTileReactorCore.renderCore(0.0, 0.0, 0.0, 0.0f, intensity, animation, scale, DEShaders.useShaders());
        this.resetLighting();
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    public static void renderGUI(TileReactorCore te, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        double diameter = 100.0;
        float t = (float)(te.temperature.value / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)Utils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)Utils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)Utils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float animation = (te.coreAnimation + 0.0f * (float)te.shaderAnimationState.value) / 20.0f;
        float shieldPower = (float)(te.maxShieldCharge.value > 0.0 ? te.shieldCharge.value / te.maxShieldCharge.value : 0.0);
        RenderTileReactorCore.renderCore((double)x - 0.5, y, 100.0, 0.0f, intensity, animation, diameter, DEShaders.useShaders());
        RenderTileReactorCore.renderShield((double)x - 0.5, y, 100.0, 0.0f, 0.7f * shieldPower - (float)(1.0 - te.shaderAnimationState.value), animation, diameter, DEShaders.useShaders());
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    private static void renderCore(double x, double y, double z, float partialTicks, float intensity, float animation, double diameter, boolean useShader) {
        ResourceHelperDE.bindTexture("textures/models/reactor_core.png");
        if (useShader) {
            if (reactorProgram == null) {
                reactorProgram = new ShaderProgram();
                reactorProgram.attachShader(DEShaders.reactor);
            }
            reactorProgram.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("intensity", intensity);
            });
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)diameter);
        model.render(ccrs, new IVertexOperation[]{mat});
        ccrs.draw();
        if (useShader) {
            reactorProgram.releaseShader();
        }
    }

    private static void renderShield(double x, double y, double z, float partialTicks, float power, float animation, double diameter, boolean useShader) {
        ResourceHelperDE.bindTexture("textures/models/reactor_shield.png");
        if (useShader) {
            if (shieldProgram == null) {
                shieldProgram = new ShaderProgram();
                shieldProgram.attachShader(DEShaders.reactorShield);
            }
            shieldProgram.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("intensity", power);
            });
        } else {
            float ff = 0.5f;
            float r = ff < 0.5f ? 1.0f - ff * 2.0f : 0.0f;
            float g = ff > 0.5f ? (ff - 0.5f) * 2.0f : 0.0f;
            float b = ff * 2.0f;
            float a = ff < 0.1f ? ff * 10.0f : 1.0f;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        if (useShader) {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)(diameter * 1.05));
            model.render(ccrs, new IVertexOperation[]{mat});
        } else {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)(diameter * -0.525));
            model_no_shade.render(ccrs, new IVertexOperation[]{mat});
        }
        ccrs.draw();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (useShader) {
            shieldProgram.releaseShader();
        }
    }
}

