/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiListEntry;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiListEntryWrapper;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiStackIcon;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.FusionUpgradeRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class FusionRecipeCategory
extends BlankRecipeCategory {
    private final IDrawable background;
    private final String localizedName;
    private int xSize = 164;
    private int ySize = 111;

    public FusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceHelperDE.getResource("textures/gui/jei_fusion_background.png"), 0, 0, this.xSize, this.ySize);
        this.localizedName = I18n.func_135052_a((String)"gui.de.fusionCraftingCore.name", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return "DraconicEvolution.Fusion";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "draconicevolution";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        try {
            int i;
            IFusionRecipe recipe = ((FusionRecipeWrapper)recipeWrapper).recipe;
            IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
            stackGroup.init(0, true, this.xSize / 2 - 9, this.ySize / 2 - 9 - 23);
            stackGroup.init(1, false, this.xSize / 2 - 9, this.ySize / 2 - 9 + 23);
            List ingreds = recipe.getRecipeIngredients();
            int nColumns = ingreds.size() > 16 ? 4 : 2;
            LinkedList<MGuiList> iColumns = new LinkedList<MGuiList>();
            for (i = 0; i < nColumns; ++i) {
                int x = nColumns == 2 ? 15 + i * 128 : 7 + i % 2 * 17 + i / 2 * 126;
                MGuiList list = new MGuiList(null, x, 8, 20, 98).setScrollingEnabled(false);
                list.addChild((MGuiElementBase)new MGuiBorderedRect(null, list.xPos, list.yPos - 1, list.xSize, list.ySize + 2).setBorderColour(-5635841));
                list.bottomPadding = 0;
                list.topPadding = 0;
                iColumns.add(list);
            }
            i = 0;
            for (Object ingredient : ingreds) {
                ItemStack ingredStack = OreDictHelper.resolveObject(ingredient);
                MGuiList column = (MGuiList)iColumns.get(iColumns.size() == 4 ? i % 4 : i % 2);
                column.addEntry((MGuiListEntry)((MGuiListEntryWrapper)new MGuiListEntryWrapper(null, (MGuiElementBase)new MGuiStackIcon(null, 0, 0, 16, 16, new StackReference(ingredStack)).setDrawHoverHighlight(true)).setLinkedObject((Object)i)));
                column.sortEvenSpacing(true);
                ++i;
            }
            for (MGuiList list : iColumns) {
                for (MGuiListEntry entry : list.listEntries) {
                    stackGroup.init((Integer)entry.linkedObject + 2, true, entry.xPos - 8, entry.yPos);
                }
            }
            stackGroup.set(ingredients);
            if (recipe instanceof FusionUpgradeRecipe) {
                FusionUpgradeRecipe fRecipe = (FusionUpgradeRecipe)recipe;
                LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
                LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
                for (ItemStack stack : DEJEIPlugin.iUpgradables) {
                    IUpgradableItem item;
                    if (!(stack.func_77973_b() instanceof IUpgradableItem) || !(item = (IUpgradableItem)stack.func_77973_b()).getValidUpgrades(stack).contains(fRecipe.upgrade) || item.getMaxUpgradeLevel(stack, fRecipe.upgrade) < fRecipe.upgradeLevel) continue;
                    ItemStack input = stack.func_77946_l();
                    ItemStack output = stack.func_77946_l();
                    UpgradeHelper.setUpgradeLevel(input, fRecipe.upgrade, fRecipe.upgradeLevel - 1);
                    UpgradeHelper.setUpgradeLevel(output, fRecipe.upgrade, fRecipe.upgradeLevel);
                    inputs.add(input);
                    outputs.add(output);
                }
                stackGroup.set(0, inputs);
                stackGroup.set(1, outputs);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
    }
}

