/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransforms;
import com.brandon3055.draconicevolution.items.tools.IAOEWeapon;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.utils.DETextures;
import java.util.List;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DraconicStaffOfPower
extends MiningToolBase
implements IAOEWeapon,
IReaperItem {
    public DraconicStaffOfPower() {
        super(ToolStats.DRA_STAFF_ATTACK_DAMAGE, ToolStats.DRA_STAFF_ATTACK_SPEED, PICKAXE_OVERRIDES);
        this.baseMiningSpeed = (float)ToolStats.DRA_STAFF_MINING_SPEED;
        this.baseAOE = ToolStats.BASE_DRACONIC_MINING_AOE + 1;
        this.setEnergyStats(ToolStats.DRACONIC_BASE_CAPACITY * 3, 16000000, 0);
        this.setHarvestLevel("pickaxe", 10);
        this.setHarvestLevel("axe", 10);
        this.setHarvestLevel("shovel", 10);
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("attackDmg");
        list.add("attackAOE");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getDisabledEnchants(stack).containsKey(enchantment)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    protected double getMaxAttackAOE(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "attackAOE");
        if (level == 0) {
            return 2.0;
        }
        if (level == 1) {
            return 3.0;
        }
        if (level == 2) {
            return 5.0;
        }
        if (level == 3) {
            return 8.0;
        }
        if (level == 4) {
            return 15.0;
        }
        return 0.0;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new DoubleConfigField("attackAOE", this.getMaxAttackAOE(stack), 0.0, this.getMaxAttackAOE(stack), "config.field.attackAOE.description", IItemConfigField.EnumControlType.SLIDER));
        return super.getFields(stack, registry);
    }

    @Override
    public double getWeaponAOE(ItemStack stack) {
        return ToolConfigHelper.getDoubleField("attackAOE", stack);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return 3;
    }

    @Override
    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolOverrideList.putOverride((Item)this, DraconicStaffOfPower::handleTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    private static IModelState handleTransforms(ItemCameraTransforms.TransformType transformType, IModelState state) {
        return transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GROUND ? ToolTransforms.STAFF_STATE : state;
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DETextures.DRACONIC_STAFF_OF_POWER, (Object)new ResourceLocation("draconicevolution", "models/item/tools/draconic_staff_of_power.obj"));
    }
}

