/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRegistry;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FusionRecipeRegistry
implements FusionRegistry {
    private final List<IFusionRecipe> REGISTRY = new ArrayList<IFusionRecipe>();

    @Override
    public void add(IFusionRecipe recipe) {
        this.REGISTRY.add(recipe);
    }

    @Override
    public void remove(IFusionRecipe recipe) {
        if (this.REGISTRY.contains(recipe)) {
            this.REGISTRY.remove(recipe);
        }
    }

    @Override
    public List<IFusionRecipe> getRecipes() {
        return new ArrayList<IFusionRecipe>(this.REGISTRY);
    }

    public IFusionRecipe findRecipeForCatalyst(ItemStack catalyst) {
        if (catalyst.func_190926_b()) {
            return null;
        }
        for (IFusionRecipe recipe : this.REGISTRY) {
            if (!recipe.isRecipeCatalyst(catalyst)) continue;
            return recipe;
        }
        return null;
    }

    public IFusionRecipe findRecipe(IFusionCraftingInventory inventory, World world, BlockPos corePos) {
        if (inventory == null || inventory.getStackInCore(0).func_190926_b()) {
            return null;
        }
        for (IFusionRecipe recipe : this.REGISTRY) {
            if (!recipe.matches(inventory, world, corePos)) continue;
            return recipe;
        }
        return null;
    }
}

