/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConfigureTool
implements IMessage {
    public PlayerSlot slot;
    public int fieldIndex;
    public int button;
    public int data;

    public PacketConfigureTool() {
    }

    public PacketConfigureTool(PlayerSlot slot, int fieldIndex, int button, int data) {
        this.slot = slot;
        this.fieldIndex = fieldIndex;
        this.button = button;
        this.data = data;
    }

    public void toBytes(ByteBuf buf) {
        this.slot.toBuff(buf);
        buf.writeByte(this.fieldIndex);
        buf.writeByte(this.button);
        buf.writeShort(this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = PlayerSlot.fromBuff((ByteBuf)buf);
        this.fieldIndex = buf.readByte();
        this.button = buf.readByte();
        this.data = buf.readShort();
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketConfigureTool, IMessage> {
        public IMessage handleMessage(PacketConfigureTool message, MessageContext ctx) {
            ItemStack stack = message.slot.getStackInSlot((EntityPlayer)ctx.getServerHandler().field_147369_b);
            if (!(stack.func_77973_b() instanceof IConfigurableItem)) {
                return null;
            }
            IConfigurableItem item = (IConfigurableItem)stack.func_77973_b();
            IItemConfigField field = item.getFields(stack, new ItemConfigFieldRegistry()).getField(message.fieldIndex);
            if (field != null) {
                field.handleButton(IItemConfigField.EnumButton.getButton(message.button), message.data);
                field.writeToNBT(ToolConfigHelper.getFieldStorage(stack));
                item.onFieldChanged(stack, field);
            }
            return null;
        }
    }
}

