/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import codechicken.lib.render.particle.CustomParticleHandler;
import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.block.BlockCoreTile;
import cofh.core.block.TileCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentableSecure;
import cofh.thermalexpansion.block.TileReconfigurable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockTEBase
extends BlockCoreTile {
    protected boolean standardGui = true;
    protected boolean configGui = false;
    public static final float[] HARDNESS = new float[]{5.0f, 10.0f, 10.0f, 15.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{15, 30, 30, 45, 120};
    public static final float HARDNESS_CREATIVE = -1.0f;
    public static final float RESISTANCE_CREATIVE = 1200.0f;

    protected BlockTEBase(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ThermalExpansion.tabCommon);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTEBase) {
            ((TileTEBase)tile).setName(ItemHelper.getNameFromItemStack((ItemStack)stack));
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, traceResult.field_72307_f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (player.func_70093_af() && WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world) && this.canDismantle(world, pos, state, player)) {
                this.dismantleBlock(world, pos, state, player, false);
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        TileTEBase tile = (TileTEBase)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tile.onWrench(player, side);
            }
            WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            return true;
        }
        if (this.onBlockActivatedDelegate(world, pos, state, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (this.standardGui && ServerHelper.isServerWorld((World)world)) {
            return tile.openGui(player);
        }
        return this.standardGui;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileTEBase tile = (TileTEBase)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure) {
            return ((TileAugmentableSecure)tile).isCreative ? -1.0f : HARDNESS[((TileAugmentableSecure)tile).getLevel() % HARDNESS.length];
        }
        return this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileTEBase tile = (TileTEBase)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure) {
            return ((TileAugmentableSecure)tile).isCreative ? 1200.0f : (float)RESISTANCE[((TileAugmentableSecure)tile).getLevel() % RESISTANCE.length];
        }
        return this.field_149781_w / 5.0f;
    }

    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean openConfigGui(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileTEBase tile = (TileTEBase)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (this.configGui && ServerHelper.isServerWorld((World)world)) {
            return tile.openConfigGui(player);
        }
        return this.configGui;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return CustomParticleHandler.handleLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return CustomParticleHandler.handleDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult trace, ParticleManager manager) {
        return CustomParticleHandler.handleHitEffects((IBlockState)state, (World)world, (RayTraceResult)trace, (ParticleManager)manager);
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound retTag = new NBTTagCompound();
        if (tile instanceof TileTEBase && !((TileTEBase)tile).tileName.isEmpty()) {
            retTag = ItemHelper.setItemStackTagName((NBTTagCompound)retTag, (String)((TileTEBase)tile).tileName);
        }
        if (tile instanceof TileAugmentableSecure) {
            retTag.func_74757_a("Creative", ((TileAugmentableSecure)tile).isCreative);
            retTag.func_74774_a("Level", (byte)((TileAugmentableSecure)tile).getLevel());
            if (((TileAugmentableSecure)tile).isSecured()) {
                retTag = SecurityHelper.setItemStackTagSecure((NBTTagCompound)retTag, (ISecurable)((ISecurable)tile));
            }
        }
        if (tile instanceof IAugmentable) {
            retTag = AugmentHelper.setItemStackTagAugments((NBTTagCompound)retTag, (IAugmentable)((IAugmentable)tile));
        }
        if (tile instanceof IRedstoneControl) {
            retTag = RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)retTag, (IRedstoneControl)((IRedstoneControl)tile));
        }
        if (tile instanceof TileReconfigurable) {
            retTag = ReconfigurableHelper.setItemStackTagReconfig(retTag, (TileReconfigurable)tile);
        }
        if (tile instanceof IEnergyHandler) {
            retTag.func_74768_a("Energy", ((IEnergyHandler)tile).getEnergyStored(null));
        }
        return retTag;
    }

    public ArrayList<ItemStack> dropDelegate(NBTTagCompound nbt, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack dropBlock = new ItemStack((Block)this, 1, meta);
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(dropBlock);
        return ret;
    }

    public ArrayList<ItemStack> dismantleDelegate(NBTTagCompound nbt, World world, BlockPos pos, EntityPlayer player, boolean returnDrops, boolean simulate) {
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack dropBlock = new ItemStack((Block)this, 1, meta);
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        if (!simulate) {
            if (tile instanceof TileCore) {
                ((TileCore)tile).blockDismantled();
            }
            world.func_175698_g(pos);
            if (!returnDrops) {
                float f = 0.3f;
                double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem dropEntity = new EntityItem(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, dropBlock);
                dropEntity.func_174867_a(10);
                if (tile instanceof ISecurable && !((ISecurable)tile).getAccess().isPublic()) {
                    dropEntity.func_145797_a(player.func_70005_c_());
                }
                world.func_72838_d((Entity)dropEntity);
                if (player != null) {
                    CoreUtils.dismantleLog((String)player.func_70005_c_(), (Block)state.func_177230_c(), (int)meta, (BlockPos)pos);
                }
            }
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(dropBlock);
        return ret;
    }

    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileTEBase tile = (TileTEBase)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure && ((TileAugmentableSecure)tile).isCreative && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(world, pos, state, player);
    }
}

