/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiDiffuser;
import cofh.thermalexpansion.gui.container.device.ContainerDiffuser;
import cofh.thermalexpansion.util.managers.DiffuserManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDiffuser
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.DIFFUSER.getMetadata();
    private static final int TIME_CONSTANT = 60;
    private static final int BOOST_TIME = 15;
    private static final int FLUID_AMOUNT = 50;
    private static final int RADIUS_POTION = 3;
    private static final int RADIUS_SPLASH = 4;
    private static final int RADIUS_LINGERING = 5;
    private static final int MAX_AMPLIFIER = 4;
    private static final int MAX_DURATION = 7200;
    public static boolean enableParticles = true;
    private int inputTracker;
    private int boostAmp;
    private int boostDur;
    private int boostTime;
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid;
    private int offset;

    public static void initialize() {
        TileDiffuser.SIDE_CONFIGS[TileDiffuser.TYPE] = new TileTEBase.SideConfig();
        TileDiffuser.SIDE_CONFIGS[TileDiffuser.TYPE].numConfig = 5;
        TileDiffuser.SIDE_CONFIGS[TileDiffuser.TYPE].slotGroups = new int[][]{new int[0], {0}, {0}, new int[0], {0}};
        TileDiffuser.SIDE_CONFIGS[TileDiffuser.TYPE].sideTypes = new int[]{0, 1, 5, 6, 7};
        TileDiffuser.SIDE_CONFIGS[TileDiffuser.TYPE].defaultSides = new byte[]{0, 1, 1, 1, 1, 1};
        TileDiffuser.SLOT_CONFIGS[TileDiffuser.TYPE] = new TileTEBase.SlotConfig();
        TileDiffuser.SLOT_CONFIGS[TileDiffuser.TYPE].allowInsertionSlot = new boolean[]{true};
        TileDiffuser.SLOT_CONFIGS[TileDiffuser.TYPE].allowExtractionSlot = new boolean[]{false};
        TileDiffuser.LIGHT_VALUES[TileDiffuser.TYPE] = 5;
        GameRegistry.registerTileEntity(TileDiffuser.class, (String)"thermalexpansion:device_diffuser");
        TileDiffuser.config();
    }

    public static void config() {
        String category = "Device.Diffuser";
        BlockDevice.enable[TileDiffuser.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        category = "Device.Diffuser";
        enableParticles = ThermalExpansion.CONFIG_CLIENT.get(category, "EnableParticles", true);
    }

    public TileDiffuser() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(60);
        this.hasAutoInput = true;
        this.enableAutoInput = true;
    }

    public int getType() {
        return TYPE;
    }

    public boolean hasClientUpdate() {
        return true;
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            if (!enableParticles) {
                return;
            }
            if (!this.timeCheckOffset()) {
                return;
            }
            if (this.isActive) {
                this.diffuseClient();
            }
            return;
        }
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.diffuse();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void diffuseClient() {
        if (this.renderFluid == null) {
            return;
        }
        int radius = TileDiffuser.isSplashPotion(this.renderFluid) ? 4 : (TileDiffuser.isLingeringPotion(this.renderFluid) ? 5 : 3);
        List effects = PotionUtils.func_185185_a((NBTTagCompound)this.renderFluid.tag);
        int color = PotionUtils.func_185181_a((Collection)effects);
        int x = this.field_174879_c.func_177958_n();
        float y = (float)this.field_174879_c.func_177956_o() + 0.5f;
        int z = this.field_174879_c.func_177952_p();
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                this.field_145850_b.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), (double)((float)i + this.field_145850_b.field_73012_v.nextFloat()), (double)y, (double)((float)k + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)(color >> 16 & 0xFF) / 255.0f), (double)((float)(color >> 8 & 0xFF) / 255.0f), (double)((float)(color & 0xFF) / 255.0f), new int[0]);
            }
        }
    }

    protected void diffuse() {
        FluidStack potionFluid;
        if (this.tank.getFluidAmount() < 50) {
            if (this.renderFluid != null) {
                this.renderFluid = null;
                this.sendFluidPacket();
            }
            return;
        }
        if (this.boostTime <= 0) {
            this.boostAmp = 0;
            this.boostDur = 0;
            if (DiffuserManager.isValidReagent(this.inventory[0])) {
                this.boostAmp = DiffuserManager.getReagentAmplifier(this.inventory[0]);
                this.boostDur = DiffuserManager.getReagentDuration(this.inventory[0]);
                this.boostTime = 14;
                this.inventory[0].func_190918_g(1);
                if (this.inventory[0].func_190916_E() <= 0) {
                    this.inventory[0] = ItemStack.field_190927_a;
                }
            }
        } else {
            --this.boostTime;
        }
        if (!FluidHelper.isFluidEqual((FluidStack)(potionFluid = this.getTankFluid()), (FluidStack)this.renderFluid)) {
            this.renderFluid = new FluidStack(potionFluid, 0);
            this.sendFluidPacket();
        }
        int radius = TileDiffuser.isSplashPotion(potionFluid) ? 4 : (TileDiffuser.isLingeringPotion(potionFluid) ? 5 : 3);
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-radius, 1 - radius, -radius), this.field_174879_c.func_177982_a(1 + radius, radius, 1 + radius));
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, area);
        this.tank.drain(50, true);
        if (entities.isEmpty()) {
            return;
        }
        List effects = PotionUtils.func_185185_a((NBTTagCompound)potionFluid.tag);
        for (EntityLivingBase entity : entities) {
            if (!entity.func_184603_cC()) continue;
            for (PotionEffect effect : effects) {
                Potion potion = effect.func_188419_a();
                if (potion.func_76403_b()) {
                    potion.func_180793_a(null, null, entity, effect.func_76458_c() + this.boostAmp, 0.5);
                    continue;
                }
                entity.func_70690_d(new PotionEffect(potion, Math.min(effect.func_76459_b() / 4 * (1 + this.boostDur), 7200), Math.min(effect.func_76458_c() + this.boostAmp, 4), effect.func_82720_e(), effect.func_188418_e()));
            }
        }
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 60L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDiffuser(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDiffuser(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.round((double)(scale * this.boostTime / 15));
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getBoostAmp() {
        return this.boostAmp;
    }

    public int getBoostDur() {
        return this.boostDur;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.tank.readFromNBT(nbt);
        this.boostAmp = nbt.func_74762_e("BoostAmp");
        this.boostDur = nbt.func_74762_e("BoostDur");
        this.boostTime = nbt.func_74762_e("BoostTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("BoostAmp", this.boostAmp);
        nbt.func_74768_a("BoostDur", this.boostDur);
        nbt.func_74768_a("BoostTime", this.boostTime);
        return nbt;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.boostAmp);
        payload.addInt(this.boostDur);
        payload.addInt(this.boostTime);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addInt(this.offset);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    protected void handleFluidPacket(PacketCoFHBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.boostAmp = payload.getInt();
        this.boostDur = payload.getInt();
        this.boostTime = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.offset = payload.getInt();
        this.renderFluid = payload.getFluidStack();
    }

    protected static boolean isSplashPotion(FluidStack stack) {
        return stack != null && stack.getFluid() == TFFluids.fluidPotionSplash;
    }

    protected static boolean isLingeringPotion(FluidStack stack) {
        return stack != null && stack.getFluid() == TFFluids.fluidPotionLingering;
    }

    protected static boolean isValidPotion(FluidStack stack) {
        return stack != null && (stack.getFluid() == TFFluids.fluidPotion || stack.getFluid() == TFFluids.fluidPotionSplash || stack.getFluid() == TFFluids.fluidPotionLingering);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return DiffuserManager.isValidReagent(stack);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileDiffuser.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileDiffuser.this.allowInsertion(((TileDiffuser)TileDiffuser.this).sideConfig.sideTypes[TileDiffuser.this.sideCache[from.ordinal()]]) || !TileDiffuser.isValidPotion(resource)) {
                        return 0;
                    }
                    return TileDiffuser.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileDiffuser.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileDiffuser.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

