/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiItemBuffer;
import cofh.thermalexpansion.gui.container.device.ContainerItemBuffer;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileItemBuffer
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.ITEM_BUFFER.getMetadata();
    private int inputTracker;
    private int outputTracker;
    public int amountInput = 4;
    public int amountOutput = 4;

    public static void initialize() {
        TileItemBuffer.SIDE_CONFIGS[TileItemBuffer.TYPE] = new TileTEBase.SideConfig();
        TileItemBuffer.SIDE_CONFIGS[TileItemBuffer.TYPE].numConfig = 5;
        TileItemBuffer.SIDE_CONFIGS[TileItemBuffer.TYPE].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}};
        TileItemBuffer.SIDE_CONFIGS[TileItemBuffer.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileItemBuffer.SIDE_CONFIGS[TileItemBuffer.TYPE].defaultSides = new byte[]{2, 1, 1, 1, 1, 1};
        TileItemBuffer.SLOT_CONFIGS[TileItemBuffer.TYPE] = new TileTEBase.SlotConfig();
        TileItemBuffer.SLOT_CONFIGS[TileItemBuffer.TYPE].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true};
        TileItemBuffer.SLOT_CONFIGS[TileItemBuffer.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true};
        GameRegistry.registerTileEntity(TileItemBuffer.class, (String)"thermalexpansion:device_item_buffer");
        TileItemBuffer.config();
    }

    public static void config() {
        String category = "Device.ItemBuffer";
        BlockDevice.enable[TileItemBuffer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileItemBuffer() {
        this.inventory = new ItemStack[9];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 16L != 0L) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.transferOutput();
            this.transferInput();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.enableAutoInput || this.amountInput <= 0) {
            return;
        }
        block0: for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 0; j < this.inventory.length; ++j) {
                if (!this.extractItem(j, this.amountInput, EnumFacing.field_82609_l[side])) continue;
                this.inputTracker = side;
                continue block0;
            }
        }
    }

    protected void transferOutput() {
        if (!this.enableAutoOutput || this.amountOutput <= 0) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = this.inventory.length - 1; j >= 0; --j) {
                if (!this.transferItem(j, this.amountOutput, EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiItemBuffer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerItemBuffer(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.amountInput = MathHelper.clamp((int)nbt.func_74762_e("AmountIn"), (int)0, (int)64);
        this.amountOutput = MathHelper.clamp((int)nbt.func_74762_e("AmountOut"), (int)0, (int)64);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addInt(MathHelper.clamp((int)this.amountInput, (int)0, (int)64));
        payload.addInt(MathHelper.clamp((int)this.amountOutput, (int)0, (int)64));
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
    }

    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.amountInput);
        payload.addInt(this.amountOutput);
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addInt(this.amountInput);
        payload.addInt(this.amountOutput);
        return payload;
    }

    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
    }
}

