/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.dynamo.ItemBlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoEnervation;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.dynamo.TileDynamoNumismatic;
import cofh.thermalexpansion.block.dynamo.TileDynamoReactant;
import cofh.thermalexpansion.block.dynamo.TileDynamoSteam;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.BakeryDynamo;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.ItemUpgrade;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockDynamo
extends BlockTEBase
implements IModelRegister,
IBakeryProvider {
    public static final PropertyEnum<Type> VARIANT;
    static AxisAlignedBB[] boundingBox;
    public static boolean[] enable;
    public static boolean enableClassicRecipes;
    public static boolean enableUpgradeKitCrafting;
    public static ItemStack dynamoSteam;
    public static ItemStack dynamoMagmatic;
    public static ItemStack dynamoCompression;
    public static ItemStack dynamoReactant;
    public static ItemStack dynamoEnervation;
    public static ItemStack dynamoNumismatic;
    public static ItemBlockDynamo itemBlock;

    public BlockDynamo() {
        super(Material.field_151573_f);
        this.func_149663_c("thermalexpansion.dynamo");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.STEAM)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_DYNAMO});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            if (!enable[i]) continue;
            if (TEProps.creativeTabShowAllLevels) {
                for (int j = 0; j < 5; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), TEProps.creativeTabLevel));
            }
            if (!TEProps.creativeTabShowCreative) continue;
            items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata >= Type.values().length) {
            return null;
        }
        switch (Type.values()[metadata]) {
            case STEAM: {
                return new TileDynamoSteam();
            }
            case MAGMATIC: {
                return new TileDynamoMagmatic();
            }
            case COMPRESSION: {
                return new TileDynamoCompression();
            }
            case REACTANT: {
                return new TileDynamoReactant();
            }
            case ENERVATION: {
                return new TileDynamoEnervation();
            }
            case NUMISMATIC: {
                return new TileDynamoNumismatic();
            }
        }
        return null;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        byte facing = ((TileDynamoBase)world.func_175625_s((BlockPos)pos)).facing;
        AxisAlignedBB base = boundingBox[facing].func_186670_a(pos);
        AxisAlignedBB coil = boundingBox[facing + 6].func_186670_a(pos);
        if (coil.func_72326_a(entityBox)) {
            collidingBoxes.add(coil);
        }
        if (base.func_72326_a(entityBox)) {
            collidingBoxes.add(base);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileDynamoBase tile = (TileDynamoBase)world.func_175625_s(pos);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.readAugmentsFromNBT(stack.func_77978_p());
            tile.updateAugmentStatus();
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer != BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileDynamoBase)) {
            return false;
        }
        TileDynamoBase theTile = (TileDynamoBase)tile;
        return theTile.facing == BlockHelper.SIDE_OPPOSITE[side.ordinal()];
    }

    @Override
    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileDynamoBase tile = (TileDynamoBase)world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ItemStack heldItem = player.func_184586_b(hand);
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (FluidHelper.isFluidHandler((ItemStack)heldItem)) {
                FluidHelper.drainItemToHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null) {
            byte facing = ((TileDynamoBase)tile).facing;
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, (AxisAlignedBB[])new AxisAlignedBB[]{boundingBox[facing], boundingBox[facing + 6]});
        }
        return super.func_180636_a(blockState, worldIn, pos, start, end);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryDynamo.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            TileDynamoBase dynamo = (TileDynamoBase)((Object)((Object)state.getValue(TEProps.TILE_DYNAMO)));
            builder.append(",creative=").append(dynamo.isCreative);
            builder.append(",level=").append(dynamo.getLevel());
            builder.append(",facing=").append(dynamo.getFacing());
            builder.append(",active=").append(dynamo.isActive);
            builder.append(",coil=").append(dynamo.getCoil());
            builder.append(",coil_anim=").append(dynamo.getCoilUnderlayTexture().func_94215_i());
            builder.append(",base_anim=").append(dynamo.getBaseUnderlayTexture().func_94215_i());
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean initialize() {
        this.setRegistryName("dynamo");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockDynamo((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileDynamoBase.config();
        TileDynamoSteam.initialize();
        TileDynamoMagmatic.initialize();
        TileDynamoCompression.initialize();
        TileDynamoReactant.initialize();
        TileDynamoEnervation.initialize();
        TileDynamoNumismatic.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        dynamoSteam = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.STEAM.getMetadata()));
        dynamoMagmatic = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.MAGMATIC.getMetadata()));
        dynamoCompression = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.COMPRESSION.getMetadata()));
        dynamoReactant = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.REACTANT.getMetadata()));
        dynamoEnervation = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ENERVATION.getMetadata()));
        dynamoNumismatic = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.NUMISMATIC.getMetadata()));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable[Type.STEAM.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoSteam, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
        if (enable[Type.MAGMATIC.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoMagmatic, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
        if (enable[Type.COMPRESSION.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoCompression, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
        if (enable[Type.REACTANT.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoReactant, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearLead", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
        if (enable[Type.ENERVATION.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoEnervation, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
        if (enable[Type.NUMISMATIC.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)dynamoNumismatic, (Object[])new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('G'), "gearConstantan", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        }
    }

    private void addUpgradeRecipes() {
        if (!enableUpgradeKitCrafting) {
            return;
        }
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            int j;
            if (!enable[i]) continue;
            ItemStack[] block = new ItemStack[5];
            for (j = 0; j < 5; ++j) {
                block[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes) {
            return;
        }
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            if (!enable[i]) continue;
            ItemStack[] dynamo = new ItemStack[5];
            for (int j = 0; j < 5; ++j) {
                dynamo[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)dynamo[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), dynamo[0], Character.valueOf('I'), "ingotInvar"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)dynamo[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), dynamo[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)dynamo[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), dynamo[2], Character.valueOf('I'), "ingotSignalum"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)dynamo[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), dynamo[3], Character.valueOf('I'), "ingotEnderium"});
        }
    }

    static {
        int i;
        VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
        boundingBox = new AxisAlignedBB[12];
        Cuboid6 bb = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
        Vector3 p = new Vector3(0.5, 0.5, 0.5);
        BlockDynamo.boundingBox[1] = bb.aabb();
        BlockDynamo.boundingBox[0] = bb.apply(Rotation.sideRotations[1].at(p)).aabb();
        for (i = 2; i < 6; ++i) {
            BlockDynamo.boundingBox[i] = bb.copy().apply(Rotation.sideRotations[i].at(p)).aabb();
        }
        bb = new Cuboid6(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
        BlockDynamo.boundingBox[7] = bb.aabb();
        BlockDynamo.boundingBox[6] = bb.apply(Rotation.sideRotations[1].at(p)).aabb();
        for (i = 2; i < 6; ++i) {
            BlockDynamo.boundingBox[i + 6] = bb.copy().apply(Rotation.sideRotations[i].at(p)).aabb();
        }
        enable = new boolean[Type.values().length];
    }

    public static enum Type implements IStringSerializable
    {
        STEAM(0, "steam"),
        MAGMATIC(1, "magmatic"),
        COMPRESSION(2, "compression"),
        REACTANT(3, "reactant"),
        ENERVATION(4, "enervation"),
        NUMISMATIC(5, "numismatic");

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

