/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ICustomInventory;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiExtruder;
import cofh.thermalexpansion.gui.container.machine.ContainerExtruder;
import cofh.thermalexpansion.init.TETextures;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileExtruder
extends TileMachineBase
implements ICustomInventory {
    private static final int TYPE = BlockMachine.Type.EXTRUDER.getMetadata();
    public static int basePower = 20;
    public static ItemStack ANDESITE;
    public static ItemStack DIORITE;
    public static ItemStack GRANITE;
    private static int[] processLava;
    private static int[] processWater;
    private static int[] processEnergy;
    private static ItemStack[] processItems;
    private int outputTracker;
    private byte curSelection;
    private byte prevSelection;
    private ItemStack[] outputItems = new ItemStack[3];
    private FluidTankCore hotTank = new FluidTankCore(4000);
    private FluidTankCore coldTank = new FluidTankCore(4000);
    protected boolean augmentNoWater;
    protected boolean augmentAndesite;
    protected boolean augmentDiorite;
    protected boolean augmentGranite;
    protected boolean flagNoWater;

    public static void initialize() {
        processItems = new ItemStack[3];
        TileExtruder.processItems[0] = new ItemStack(Blocks.field_150347_e);
        TileExtruder.processItems[1] = new ItemStack(Blocks.field_150348_b);
        TileExtruder.processItems[2] = new ItemStack(Blocks.field_150343_Z);
        GRANITE = new ItemStack(Blocks.field_150348_b, 1, 1);
        DIORITE = new ItemStack(Blocks.field_150348_b, 1, 3);
        ANDESITE = new ItemStack(Blocks.field_150348_b, 1, 5);
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE] = new TileTEBase.SideConfig();
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].numConfig = 5;
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}, {0}};
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE] = new TileTEBase.SlotConfig();
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TileExtruder.VALID_AUGMENTS[TileExtruder.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineExtruderNoWater");
        VALID_AUGMENTS[TYPE].add("machineExtruderAndesite");
        VALID_AUGMENTS[TYPE].add("machineExtruderDiorite");
        VALID_AUGMENTS[TYPE].add("machineExtruderGranite");
        TileExtruder.LIGHT_VALUES[TileExtruder.TYPE] = 14;
        GameRegistry.registerTileEntity(TileExtruder.class, (String)"thermalexpansion:machine_extruder");
        TileExtruder.config();
    }

    public static void config() {
        String category = "Machine.Extruder";
        BlockMachine.enable[TileExtruder.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Igneous Extruder. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileExtruder.ENERGY_CONFIGS[TileExtruder.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileExtruder() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        for (int i = 0; i < 3; ++i) {
            this.outputItems[i] = processItems[i].func_77946_l();
        }
        this.hotTank.setLock(FluidRegistry.LAVA);
        this.coldTank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.hotTank.getFluidAmount() < 1000) {
            return false;
        }
        if (!this.augmentNoWater && this.coldTank.getFluidAmount() < 1000) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.inventory[0].func_190926_b()) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(this.outputItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].func_190916_E() + this.outputItems[this.curSelection].func_190916_E() <= this.outputItems[this.prevSelection].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = processEnergy[this.curSelection] * this.energyMod / 100;
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        if (this.inventory[0].func_190926_b()) {
            this.inventory[0] = this.outputItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].func_190917_f(this.outputItems[this.prevSelection].func_190916_E());
        }
        this.hotTank.drain(processLava[this.prevSelection], true);
        if (!this.augmentNoWater) {
            this.coldTank.drain(processWater[this.prevSelection], true);
        }
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        if (tag.func_74764_b("Sel")) {
            this.curSelection = tag.func_74771_c("Sel");
            if (!this.isActive) {
                this.prevSelection = this.curSelection;
            }
        }
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74774_a("Sel", this.curSelection);
        return true;
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiExtruder(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerExtruder(inventory, (TileEntity)this);
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.hotTank;
        }
        return this.coldTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.hotTank.getFluid();
        }
        return this.coldTank.getFluid();
    }

    public boolean augmentNoWater() {
        return this.augmentNoWater && this.flagNoWater;
    }

    public void setMode(int selection) {
        byte lastSelection = this.curSelection;
        this.curSelection = (byte)selection;
        this.sendModePacket();
        this.curSelection = lastSelection;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.prevSelection = nbt.func_74771_c("Prev");
        this.curSelection = nbt.func_74771_c("Sel");
        this.hotTank.readFromNBT(nbt.func_74775_l("HotTank"));
        this.coldTank.readFromNBT(nbt.func_74775_l("ColdTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74774_a("Prev", this.prevSelection);
        nbt.func_74774_a("Sel", this.curSelection);
        nbt.func_74782_a("HotTank", (NBTBase)this.hotTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("ColdTank", (NBTBase)this.coldTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addByte(this.curSelection);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.curSelection = payload.getByte();
        if (!this.isActive) {
            this.prevSelection = this.curSelection;
        }
        this.callNeighborTileChange();
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addBool(this.augmentNoWater);
        return payload;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addByte(this.curSelection);
        payload.addByte(this.prevSelection);
        payload.addFluidStack(this.hotTank.getFluid());
        payload.addFluidStack(this.coldTank.getFluid());
        payload.addBool(this.augmentNoWater);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.flagNoWater = this.augmentNoWater = payload.getBool();
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.curSelection = payload.getByte();
        this.prevSelection = payload.getByte();
        this.hotTank.setFluid(payload.getFluidStack());
        this.coldTank.setFluid(payload.getFluidStack());
        this.flagNoWater = this.augmentNoWater = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.outputItems[1] = processItems[1].func_77946_l();
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b)) {
            this.flagNoWater = this.augmentNoWater;
        }
        this.augmentNoWater = false;
        this.augmentGranite = false;
        this.augmentDiorite = false;
        this.augmentAndesite = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentNoWater && this.isActive && this.coldTank.getFluidAmount() < 1000) {
            this.processOff();
        }
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b) && this.flagNoWater != this.augmentNoWater) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentNoWater && "machineExtruderNoWater".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentNoWater && "machineExtruderNoWater".equals(id)) {
            this.augmentNoWater = true;
            return true;
        }
        if (!this.augmentGranite && "machineExtruderGranite".equals(id)) {
            this.outputItems[1] = GRANITE.func_77946_l();
            this.augmentGranite = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentDiorite && "machineExtruderDiorite".equals(id)) {
            this.outputItems[1] = DIORITE.func_77946_l();
            this.augmentDiorite = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentAndesite && "machineExtruderAndesite".equals(id)) {
            this.outputItems[1] = ANDESITE.func_77946_l();
            this.augmentAndesite = true;
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public ItemStack[] getInventorySlots(int inventoryIndex) {
        return this.outputItems;
    }

    public int getSlotStackLimit(int slotIndex) {
        return 64;
    }

    public void onSlotUpdate(int slotIndex) {
        this.markChunkDirty();
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? (this.augmentNoWater ? RenderHelper.getFluidTexture((Fluid)FluidRegistry.LAVA) : TETextures.MACHINE_ACTIVE_EXTRUDER_UNDERLAY) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo hotInfo = TileExtruder.this.hotTank.getInfo();
                    FluidTankInfo coldInfo = TileExtruder.this.coldTank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(hotInfo.fluid, hotInfo.capacity, true, false), new FluidTankProperties(coldInfo.fluid, coldInfo.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileExtruder.this.allowInsertion(((TileExtruder)TileExtruder.this).sideConfig.sideTypes[TileExtruder.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    if (resource.getFluid() == FluidRegistry.LAVA) {
                        return TileExtruder.this.hotTank.fill(resource, doFill);
                    }
                    if (resource.getFluid() == FluidRegistry.WATER) {
                        return TileExtruder.this.coldTank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }

    static {
        processLava = new int[]{0, 0, 1000};
        processWater = new int[]{0, 1000, 1000};
        processEnergy = new int[]{400, 800, 1600};
    }
}

