/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSmelter;
import cofh.thermalexpansion.gui.container.machine.ContainerSmelter;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileSmelter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.SMELTER.getMetadata();
    public static int basePower = 20;
    public static final int FLUID_AMOUNT = 100;
    public static final int PYROTHEUM_ENERGY_MOD = 50;
    public static final int PYROTHEUM_SECONDARY_MOD = 30;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    public boolean lockPrimary = true;
    private FluidTankCore tank = new FluidTankCore(4000);
    protected boolean augmentPyrotheum;
    protected boolean flagPyrotheum;

    public static void initialize() {
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE] = new TileTEBase.SideConfig();
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].numConfig = 9;
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE] = new TileTEBase.SlotConfig();
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false};
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE].allowExtractionSlot = new boolean[]{false, false, true, true, false};
        TileSmelter.VALID_AUGMENTS[TileSmelter.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSmelterFlux");
        VALID_AUGMENTS[TYPE].add("machineSmelterPyrotheum");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileSmelter.LIGHT_VALUES[TileSmelter.TYPE] = 14;
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"thermalexpansion:machine_smelter");
        TileSmelter.config();
    }

    public static void config() {
        String category = "Machine.Smelter";
        BlockMachine.enable[TileSmelter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Induction Smelter. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileSmelter.ENERGY_CONFIGS[TileSmelter.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public static int getPyrotheumOutputAmount(ItemStack stack) {
        int amount = stack.func_190916_E();
        return amount + Math.max(1, amount * 50 / 100);
    }

    public TileSmelter() {
        this.inventory = new ItemStack[5];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidPyrotheum);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        boolean augmentPyrotheumCheck;
        if (this.inventory[0].func_190926_b() || this.inventory[1].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.inventory[1], this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().func_190916_E() > this.inventory[1].func_190916_E() || recipe.getSecondaryInput().func_190916_E() > this.inventory[0].func_190916_E() : recipe.getPrimaryInput().func_190916_E() > this.inventory[0].func_190916_E() || recipe.getSecondaryInput().func_190916_E() > this.inventory[1].func_190916_E()) {
            return false;
        }
        boolean bl = augmentPyrotheumCheck = this.augmentPyrotheum && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1]));
        if (augmentPyrotheumCheck && this.tank.getFluidAmount() < 100) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (!(secondaryItem.func_190926_b() || this.inventory[3].func_190926_b() || this.augmentSecondaryNull)) {
            if (!this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[3].func_190916_E() + secondaryItem.func_190916_E() > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[2].func_190926_b() || this.inventory[2].func_77969_a(primaryItem) && this.inventory[2].func_190916_E() + (augmentPyrotheumCheck ? TileSmelter.getPyrotheumOutputAmount(primaryItem) : primaryItem.func_190916_E()) <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.inventory[1], this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.augmentPyrotheum && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1])) && this.tank.getFluidAmount() < 100) {
            return false;
        }
        return !(SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().func_190916_E() > this.inventory[1].func_190916_E() || recipe.getSecondaryInput().func_190916_E() > this.inventory[0].func_190916_E() : recipe.getPrimaryInput().func_190916_E() > this.inventory[0].func_190916_E() || recipe.getSecondaryInput().func_190916_E() > this.inventory[1].func_190916_E());
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SmelterManager.getRecipe(this.inventory[1], this.inventory[0]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        boolean augmentPyrotheumCheck;
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.inventory[1], this.inventory[0]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        boolean bl = augmentPyrotheumCheck = this.augmentPyrotheum && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1])) && this.tank.getFluidAmount() >= 100;
        if (augmentPyrotheumCheck) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem, (int)TileSmelter.getPyrotheumOutputAmount(primaryItem));
            } else {
                this.inventory[2].func_190917_f(TileSmelter.getPyrotheumOutputAmount(primaryItem));
            }
            this.tank.modifyFluidStored(-100);
        } else if (this.inventory[2].func_190926_b()) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[2].func_190917_f(primaryItem.func_190916_E());
        }
        if (!secondaryItem.func_190926_b()) {
            int modifiedChance = augmentPyrotheumCheck ? this.secondaryChance - 30 : this.secondaryChance;
            int recipeChance = recipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[3].func_190926_b()) {
                    this.inventory[3] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                    }
                } else if (this.inventory[3].func_77969_a(secondaryItem)) {
                    this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                    }
                }
                if (this.inventory[3].func_190916_E() > this.inventory[3].func_77976_d()) {
                    this.inventory[3].func_190920_e(this.inventory[3].func_77976_d());
                }
            }
        }
        if (recipe.hasFlux()) {
            int countInput = recipe.getPrimaryInput().func_190916_E();
            int countFlux = recipe.getSecondaryInput().func_190916_E();
            if (this.reuseChance > 0) {
                if (SmelterManager.isItemFlux(this.inventory[0])) {
                    if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                        this.inventory[0].func_190918_g(countFlux);
                    }
                    this.inventory[1].func_190918_g(countInput);
                } else {
                    if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                        this.inventory[1].func_190918_g(countFlux);
                    }
                    this.inventory[0].func_190918_g(countInput);
                }
            } else if (SmelterManager.isItemFlux(this.inventory[0])) {
                this.inventory[0].func_190918_g(countFlux);
                this.inventory[1].func_190918_g(countInput);
            } else {
                this.inventory[1].func_190918_g(countFlux);
                this.inventory[0].func_190918_g(countInput);
            }
        } else {
            int count1 = recipe.getPrimaryInput().func_190916_E();
            int count2 = recipe.getSecondaryInput().func_190916_E();
            if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
                this.inventory[1].func_190918_g(count1);
                this.inventory[0].func_190918_g(count2);
            } else {
                this.inventory[0].func_190918_g(count1);
                this.inventory[1].func_190918_g(count2);
            }
        }
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
        if (this.inventory[1].func_190916_E() <= 0) {
            this.inventory[1] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.enableAutoInput) {
            return;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerPrimary = side;
            break;
        }
        for (i = this.inputTrackerSecondary + 1; i <= this.inputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.enableAutoOutput) {
            return;
        }
        if (!this.inventory[2].func_190926_b()) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[3].func_190926_b()) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(3, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiSmelter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerSmelter(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentPyrotheum() {
        return this.augmentPyrotheum && this.flagPyrotheum;
    }

    public boolean fluidArrow() {
        return this.augmentPyrotheum && this.tank.getFluidAmount() >= 100 && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1]));
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTrackerPrimary = nbt.func_74762_e("TrackOut1");
        this.outputTrackerSecondary = nbt.func_74762_e("TrackOut2");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("TrackOut1", this.outputTrackerPrimary);
        nbt.func_74768_a("TrackOut2", this.outputTrackerSecondary);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        this.callNeighborTileChange();
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addBool(this.augmentPyrotheum);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.flagPyrotheum = this.augmentPyrotheum = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentPyrotheum = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentPyrotheum) {
            this.tank.modifyFluidStored(-this.tank.getCapacity());
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machineSmelterFlux".equals(id)) {
            this.reuseChance += 10;
            this.energyMod += 10;
        }
        if (!this.augmentPyrotheum && "machineSmelterPyrotheum".equals(id)) {
            this.augmentPyrotheum = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.lockPrimary) {
            if (slot == 0) {
                return SmelterManager.isItemFlux(stack);
            }
            if (slot == 1) {
                return !SmelterManager.isItemFlux(stack) && SmelterManager.isItemValid(stack);
            }
        }
        return slot > 1 || SmelterManager.isItemValid(stack);
    }

    @Override
    public SoundEvent getSoundEvent() {
        return TESounds.machineSmelter;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentPyrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentPyrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileSmelter.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileSmelter.this.allowInsertion(((TileSmelter)TileSmelter.this).sideConfig.sideTypes[TileSmelter.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileSmelter.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileSmelter.this.isActive) {
                        return null;
                    }
                    return TileSmelter.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileSmelter.this.isActive) {
                        return null;
                    }
                    return TileSmelter.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

