/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IInventoryContainerItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.ItemBlockTEBase;
import cofh.thermalexpansion.block.storage.TileCache;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBlockCache
extends ItemBlockTEBase
implements IInventoryContainerItem,
IEnchantableItem {
    public ItemBlockCache(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public boolean isLocked(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("Lock");
    }

    @Override
    public ItemStack setDefaultTag(ItemStack stack, int level) {
        ReconfigurableHelper.setFacing(stack, 3);
        stack.func_77978_p().func_74774_a("Level", (byte)level);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return "tile.thermalexpansion.storage.cache.name";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SecurityHelper.addOwnerInformation((ItemStack)stack, tooltip);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.storage.cache"));
        if (this.isCreative(stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.capacity") + ": " + StringHelper.localize((String)"info.cofh.infinite"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.capacity") + ": " + StringHelper.formatNumber((long)this.getSizeInventory(stack)));
        }
        if (stack.func_77978_p().func_74764_b("Item")) {
            ItemStack stored = ItemHelper.readItemStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Item"));
            tooltip.add(StringHelper.localize((String)"info.cofh.contents") + ":");
            if (this.isCreative(stack)) {
                tooltip.add("    \u00a76" + StringHelper.getItemName((ItemStack)stored));
            } else {
                tooltip.add("    \u00a76" + StringHelper.formatNumber((long)stored.func_190916_E()) + " " + StringHelper.getItemName((ItemStack)stored));
            }
            if (this.isLocked(stack)) {
                tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.locked"));
            } else {
                tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.unlocked"));
            }
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.empty"));
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public int getSizeInventory(ItemStack container) {
        return TileCache.getCapacity(this.getLevel(container), EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container));
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }
}

