/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import cofh.thermalexpansion.block.ItemBlockTEBase;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockCell
extends ItemBlockTEBase
implements IEnergyContainerItem,
IEnchantableItem {
    public ItemBlockCell(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    @Override
    public ItemStack setDefaultTag(ItemStack stack, int level) {
        ReconfigurableHelper.setFacing(stack, 3);
        ReconfigurableHelper.setSideCache(stack, TileCell.DEFAULT_SIDES);
        RedstoneControlHelper.setControl((ItemStack)stack, (IRedstoneControl.ControlMode)IRedstoneControl.ControlMode.DISABLED);
        EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        stack.func_77978_p().func_74774_a("Level", (byte)level);
        stack.func_77978_p().func_74768_a("Send", TileCell.SEND[level]);
        stack.func_77978_p().func_74768_a("Recv", TileCell.RECV[level]);
        return stack;
    }

    @Override
    public ItemStack setCreativeTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack, 4);
        }
        ReconfigurableHelper.setSideCache(stack, TileCell.CREATIVE_SIDES);
        EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)TileCell.CAPACITY[4]);
        stack.func_77978_p().func_74757_a("Creative", true);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return "tile.thermalexpansion.storage.cell.name";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SecurityHelper.addOwnerInformation((ItemStack)stack, tooltip);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.storage.cell"));
        if (this.isCreative(stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Send")) + "/" + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Recv")) + " RF/t");
        RedstoneControlHelper.addRSControlInformation((ItemStack)stack, tooltip);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Energy"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack);
    }

    public int func_77619_b() {
        return 10;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.isCreative(container)) {
            return 0;
        }
        int level = this.getLevel(container);
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, TileCell.RECV[level]));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.isCreative(container)) {
            return Math.min(maxExtract, TileCell.SEND[4]);
        }
        int level = this.getLevel(container);
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, Math.min(stored, TileCell.SEND[level]));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return TileCell.getCapacity(this.getLevel(container), EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container));
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

