/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ITileInfo;
import cofh.core.gui.container.ICustomInventory;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.ISidedTexture;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.storage.BlockCache;
import cofh.thermalexpansion.gui.client.storage.GuiCache;
import cofh.thermalexpansion.gui.container.storage.ContainerCache;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.plugins.top.PluginTOP;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository", modid="storagedrawers")
public class TileCache
extends TileInventory
implements ISidedInventory,
IReconfigurableFacing,
ISidedTexture,
ITileInfo,
ICustomInventory,
IInventoryRetainer,
IItemRepository {
    public static final int CAPACITY_BASE = 20000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int[] SLOTS = new int[]{0, 1};
    private int compareTracker;
    private int meterTracker;
    byte facing = (byte)3;
    public byte enchantHolding;
    boolean lock = false;
    int cacheStackSize;
    int maxCacheStackSize;
    int maxCapacity;
    public ItemStack storedStack = ItemStack.field_190927_a;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCache.class, (String)"thermalexpansion:storage_cache");
        TileCache.config();
    }

    public static void config() {
        String category = "Storage.Cache";
        String comment = "If TRUE, Caches are enabled.";
        BlockCache.enable = ThermalExpansion.CONFIG.get(category, "Enable", BlockCache.enable, comment);
        comment = "If TRUE, Caches may be turned into Creative versions using a Creative Conversion Kit.";
        BlockCache.enableCreative = ThermalExpansion.CONFIG.get(category, "Creative", BlockCache.enableCreative, comment);
        comment = "If TRUE, Caches are securable.";
        BlockCache.enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", BlockCache.enableSecurity, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockCache.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockCache.enableClassicRecipes, comment);
        comment = "If TRUE, Caches can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockCache.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockCache.enableUpgradeKitCrafting, comment);
        int capacity = 20000;
        comment = "Adjust this value to change the amount of Items stored by a Basic Cache. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    public TileCache() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.maxCapacity = TileCache.getCapacity(0, 0);
        this.maxCacheStackSize = this.maxCapacity - 128;
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.cache.name";
    }

    public int getType() {
        return 0;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    @Override
    public boolean enableSecurity() {
        return BlockCache.enableSecurity;
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockCache.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockCache.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && BlockCache.enableCreative;
            }
        }
        return false;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            if (!this.storedStack.func_190926_b()) {
                this.maxCapacity = TileCache.getCapacity(level, this.enchantHolding);
                this.maxCacheStackSize = this.maxCapacity - this.storedStack.func_77976_d() * 2;
                this.balanceStacks();
            } else {
                this.maxCapacity = TileCache.getCapacity(level, this.enchantHolding);
                this.maxCacheStackSize = this.maxCapacity - 128;
            }
            return true;
        }
        return false;
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public static int getCapacity(int level, int enchant) {
        return CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * enchant / 2;
    }

    protected void balanceStacks() {
        this.inventory[0] = ItemStack.field_190927_a;
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.storedStack.func_77976_d(), this.cacheStackSize));
        this.cacheStackSize -= this.inventory[1].func_190916_E();
        if (this.cacheStackSize > this.maxCacheStackSize) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)(this.cacheStackSize - this.maxCacheStackSize));
            this.cacheStackSize = this.maxCacheStackSize;
        }
    }

    protected void clearInventory() {
        if (!this.lock) {
            this.storedStack = ItemStack.field_190927_a;
            this.cacheStackSize = 0;
            this.sendTilePacket(Side.CLIENT);
        } else if (!this.storedStack.func_190926_b()) {
            this.cacheStackSize = 0;
        }
        this.inventory[0] = ItemStack.field_190927_a;
        this.inventory[1] = ItemStack.field_190927_a;
    }

    protected void updateTrackers() {
        int curScale = this.getScaledItemsStored(14) + (this.getStoredCount() > 0 ? 1 : 0);
        if (this.compareTracker != curScale) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        if (this.meterTracker != (curScale = Math.min(8, this.getScaledItemsStored(9)))) {
            this.meterTracker = curScale;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public void setLocked(boolean lock) {
        if (this.storedStack.func_190926_b()) {
            lock = false;
        }
        this.lock = lock;
        if (this.getStoredCount() <= 0 && !lock) {
            this.clearInventory();
        }
        this.sendTilePacket(Side.CLIENT);
    }

    public boolean isLocked() {
        return this.lock;
    }

    public int getScaledItemsStored(int scale) {
        return MathHelper.round((double)((long)this.getStoredCount() * (long)scale / (long)TileCache.getCapacity(this.level, this.enchantHolding)));
    }

    public int getStoredCount() {
        return this.storedStack.func_190926_b() ? 0 : this.cacheStackSize + this.inventory[0].func_190916_E() + this.inventory[1].func_190916_E();
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.isCreative) {
            if (!simulate && !this.lock) {
                this.setStoredItemType(stack, TileCache.getCapacity(this.level, this.enchantHolding));
            }
            return stack;
        }
        if (this.storedStack.func_190926_b()) {
            if (!simulate) {
                this.setStoredItemType(stack, stack.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }
        if (this.getStoredCount() == TileCache.getCapacity(this.level, this.enchantHolding)) {
            return stack;
        }
        if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack)) {
            if (this.getStoredCount() + stack.func_190916_E() > TileCache.getCapacity(this.level, this.enchantHolding)) {
                ItemStack retStack = ItemHelper.cloneStack((ItemStack)stack, (int)(TileCache.getCapacity(this.level, this.enchantHolding) - this.getStoredCount()));
                if (!simulate) {
                    this.setStoredItemCount(TileCache.getCapacity(this.level, this.enchantHolding));
                }
                return retStack;
            }
            if (!simulate) {
                this.setStoredItemCount(this.getStoredCount() + stack.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack extractItem(int maxExtract, boolean simulate) {
        if (this.storedStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.getStoredCount(), Math.min(maxExtract, this.storedStack.func_77976_d())));
        if (!simulate && !this.isCreative) {
            this.setStoredItemCount(this.getStoredCount() - ret.func_190916_E());
        }
        return ret;
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return new GuiCache(inventory, (TileEntity)this);
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return new ContainerCache(inventory, (TileEntity)this);
    }

    public boolean hasConfigGui() {
        return false;
    }

    public void toggleLock() {
        this.lock = !this.lock;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.facing = nbt.func_74771_c("Facing");
        this.lock = nbt.func_74767_n("Lock");
        if (nbt.func_74764_b("Item")) {
            this.storedStack = ItemHelper.readItemStackFromNBT((NBTTagCompound)nbt.func_74775_l("Item"));
            this.cacheStackSize = nbt.func_74762_e("CacheCount");
            this.maxCapacity = TileCache.getCapacity(this.level, this.enchantHolding);
            this.maxCacheStackSize = this.maxCapacity - this.storedStack.func_77976_d() * 2;
        } else {
            this.maxCapacity = TileCache.getCapacity(this.level, this.enchantHolding);
            this.maxCacheStackSize = this.maxCapacity - 128;
            this.lock = false;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        nbt.func_74757_a("Lock", this.lock);
        if (!this.storedStack.func_190926_b()) {
            nbt.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)this.storedStack, (NBTTagCompound)new NBTTagCompound()));
            nbt.func_74768_a("CacheCount", this.cacheStackSize);
        }
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addBool(this.lock);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.setLocked(payload.getBool());
    }

    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.lock);
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.facing);
        payload.addByte(this.enchantHolding);
        payload.addBool(this.lock);
        payload.addItemStack(this.storedStack);
        if (!this.storedStack.func_190926_b()) {
            payload.addInt(this.getStoredCount());
        }
        return payload;
    }

    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.lock = payload.getBool();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.facing = payload.getByte();
        this.enchantHolding = payload.getByte();
        this.lock = payload.getBool();
        this.storedStack = payload.getItemStack();
        if (!this.storedStack.func_190926_b()) {
            this.cacheStackSize = payload.getInt();
            this.inventory[1] = ItemStack.field_190927_a;
            this.balanceStacks();
        } else {
            this.cacheStackSize = 0;
            this.storedStack = ItemStack.field_190927_a;
            this.inventory[0] = ItemStack.field_190927_a;
            this.inventory[1] = ItemStack.field_190927_a;
        }
    }

    public ItemStack getStoredItemType() {
        return ItemHelper.cloneStack((ItemStack)this.storedStack, (int)this.getStoredCount());
    }

    public void setStoredItemCount(int amount) {
        if (this.storedStack.func_190926_b()) {
            return;
        }
        this.cacheStackSize = Math.min(amount, this.getMaxStoredCount());
        if (amount > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.markChunkDirty();
    }

    public void setStoredItemType(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            this.clearInventory();
        } else {
            this.storedStack = ItemHelper.cloneStack((ItemStack)stack, (int)1);
            this.cacheStackSize = Math.min(amount, this.getMaxStoredCount());
            this.maxCapacity = TileCache.getCapacity(this.level, this.enchantHolding);
            this.maxCacheStackSize = this.maxCapacity - this.storedStack.func_77976_d() * 2;
            this.balanceStacks();
        }
        this.updateTrackers();
        this.sendTilePacket(Side.CLIENT);
        this.markChunkDirty();
    }

    public int getMaxStoredCount() {
        return TileCache.getCapacity(this.level, this.enchantHolding);
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.isCreative) {
            return ItemHelper.cloneStack((ItemStack)this.inventory[slot], (int)amount);
        }
        if (this.inventory[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.inventory[slot].func_190916_E() <= amount) {
            amount = this.inventory[slot].func_190916_E();
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].func_190916_E() <= 0) {
            this.inventory[slot] = ItemStack.field_190927_a;
        }
        this.cacheStackSize += this.inventory[0].func_190916_E() + this.inventory[1].func_190916_E();
        if (this.cacheStackSize > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.markChunkDirty();
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (this.isCreative) {
            return;
        }
        this.inventory[slot] = stack;
        boolean stackCheck = this.storedStack.func_190926_b();
        if (slot == 0) {
            if (this.inventory[0].func_190926_b()) {
                return;
            }
            if (this.storedStack.func_190926_b()) {
                this.storedStack = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.cacheStackSize = this.inventory[0].func_190916_E();
                this.inventory[0] = ItemStack.field_190927_a;
                this.maxCapacity = TileCache.getCapacity(this.level, this.enchantHolding);
                this.maxCacheStackSize = this.maxCapacity - this.storedStack.func_77976_d() * 2;
            } else {
                this.cacheStackSize += this.inventory[0].func_190916_E() + this.inventory[1].func_190916_E();
            }
            this.balanceStacks();
        } else {
            this.cacheStackSize += this.inventory[0].func_190916_E() + this.inventory[1].func_190916_E();
            if (this.cacheStackSize > 0) {
                this.balanceStacks();
            } else {
                this.clearInventory();
            }
        }
        this.updateTrackers();
        this.markChunkDirty();
        if (stackCheck != this.storedStack.func_190926_b()) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && (this.storedStack.func_190926_b() || ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0 && (this.storedStack.func_190926_b() || ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack));
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    public int getNumPasses() {
        return 2;
    }

    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return this.isCreative ? TETextures.CACHE_BOTTOM_C : TETextures.CACHE_BOTTOM[this.level];
            }
            if (side == 1) {
                return this.isCreative ? TETextures.CACHE_TOP_C : TETextures.CACHE_TOP[this.level];
            }
            return side != this.facing ? (this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level]) : (this.isCreative ? TETextures.CACHE_FACE_C : TETextures.CACHE_FACE[this.level]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG_NONE : (this.isCreative ? TETextures.CACHE_METER_C : TETextures.CACHE_METER[MathHelper.clamp((int)this.getScaledItemsStored(9), (int)0, (int)8)]);
        }
        return this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level];
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (!this.storedStack.func_190926_b()) {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.getItemName((ItemStack)this.storedStack)));
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.amount") + ": " + StringHelper.formatNumber((long)this.getStoredCount()) + " / " + StringHelper.formatNumber((long)TileCache.getCapacity(this.level, this.enchantHolding))));
            info.add((ITextComponent)new TextComponentString(this.lock ? StringHelper.localize((String)"info.cofh.locked") : StringHelper.localize((String)"info.cofh.unlocked")));
        } else {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.localize((String)"info.cofh.empty")));
        }
    }

    public ItemStack[] getInventorySlots(int inventoryIndex) {
        return new ItemStack[]{this.storedStack};
    }

    public int getSlotStackLimit(int slotIndex) {
        return 1;
    }

    public void onSlotUpdate(int slotIndex) {
        this.markChunkDirty();
    }

    public boolean retainInventory() {
        return true;
    }

    @Override
    public void provideInfo(ProbeMode mode, IProbeInfo info, EnumFacing facing, EntityPlayer player) {
        if (mode != ProbeMode.NORMAL) {
            IProbeInfo infoSub = info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).borderColor(Integer.valueOf(PluginTOP.chestContentsBorderColor)).spacing(10));
            ItemStack stored = this.getStoredItemType();
            infoSub.item(stored, info.defaultItemStyle().width(16).height(16)).text(TextStyleClass.INFO + stored.func_82833_r());
        }
    }

    @Nonnull
    public NonNullList<IItemRepository.ItemRecord> getAllItems() {
        return NonNullList.func_193580_a((Object)new IItemRepository.ItemRecord(this.storedStack.func_77946_l(), this.getStoredCount()), (Object[])new IItemRepository.ItemRecord[0]);
    }

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
        return this.insertItem(stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
        return ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack) ? this.extractItem(amount, simulate) : ItemStack.field_190927_a;
    }
}

