/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.device;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementFluidTank;
import cofh.core.gui.element.ElementSimple;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.device.TileFluidBuffer;
import cofh.thermalexpansion.gui.client.device.GuiDeviceBase;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiFluidBuffer
extends GuiDeviceBase {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/device/fluid_buffer.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/device/fluid_buffer.png");
    private TileFluidBuffer myTile;
    private ElementButton decInput;
    private ElementButton incInput;
    private ElementButton decOutput;
    private ElementButton incOutput;
    private ElementButton[] lock = new ElementButton[3];

    public GuiFluidBuffer(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerTEBase(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.device.fluid_buffer");
        this.myTile = (TileFluidBuffer)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ElementSimple infoInput = (ElementSimple)new ElementSimple((GuiContainerCore)this, 24, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_input.png", 20, 20);
        ElementSimple infoOutput = (ElementSimple)new ElementSimple((GuiContainerCore)this, 132, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_output.png", 20, 20);
        this.addElement((ElementBase)infoInput);
        this.addElement((ElementBase)infoOutput);
        this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 62, 19, (IFluidTank)this.myTile.getTank(0)).setGauge(0).setAlwaysShow(true).setSmall());
        this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 80, 19, (IFluidTank)this.myTile.getTank(1)).setGauge(0).setAlwaysShow(true).setSmall());
        this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 98, 19, (IFluidTank)this.myTile.getTank(2)).setGauge(0).setAlwaysShow(true).setSmall());
        this.decInput = new ElementButton((GuiContainerCore)this, 19, 56, "DecInput", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incInput = new ElementButton((GuiContainerCore)this, 35, 56, "IncInput", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decOutput = new ElementButton((GuiContainerCore)this, 127, 56, "DecOutput", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incOutput = new ElementButton((GuiContainerCore)this, 143, 56, "IncOutput", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decInput);
        this.addElement((ElementBase)this.incInput);
        this.addElement((ElementBase)this.decOutput);
        this.addElement((ElementBase)this.incOutput);
        for (int i = 0; i < this.lock.length; ++i) {
            this.lock[i] = new ElementButton((GuiContainerCore)this, 62 + i * 18, 54, "Lock" + i, 176, 48, 176, 64, 176, 80, 16, 16, TEX_PATH).setToolTipLocalized(true);
            this.addElement((ElementBase)this.lock[i]);
        }
    }

    protected void updateElementInformation() {
        int change2;
        int change;
        super.updateElementInformation();
        if (GuiScreen.func_146272_n()) {
            change = 8000;
            change2 = 4000;
        } else if (GuiScreen.func_146271_m()) {
            change = 500;
            change2 = 100;
        } else {
            change = 2000;
            change2 = 1000;
        }
        if (this.myTile.amountInput > 0) {
            this.decInput.setActive();
            this.decInput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.decInput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decInput.setDisabled();
            this.decInput.clearToolTip();
        }
        if (this.myTile.amountInput < 8000) {
            this.incInput.setActive();
            this.incInput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.incInput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incInput.setDisabled();
            this.incInput.clearToolTip();
        }
        if (this.myTile.amountOutput > 0) {
            this.decOutput.setActive();
            this.decOutput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.decOutput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decOutput.setDisabled();
            this.decOutput.clearToolTip();
        }
        if (this.myTile.amountOutput < 8000) {
            this.incOutput.setActive();
            this.incOutput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.incOutput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incOutput.setDisabled();
            this.incOutput.clearToolTip();
        }
        for (int i = 0; i < this.lock.length; ++i) {
            if (this.myTile.getTank(i).getFluid() == null) {
                this.lock[i].setDisabled();
            } else {
                this.lock[i].setActive();
            }
            if (this.myTile.locks[i]) {
                String color = "\u00a7f";
                FluidStack fluid = this.myTile.getTank(i).getFluid();
                if (fluid.getFluid().getRarity() == EnumRarity.UNCOMMON) {
                    color = "\u00a7e";
                } else if (fluid.getFluid().getRarity() == EnumRarity.RARE) {
                    color = "\u00a7b";
                } else if (fluid.getFluid().getRarity() == EnumRarity.EPIC) {
                    color = "\u00a7d";
                }
                this.lock[i].setToolTip(StringHelper.localize((String)"info.cofh.locked") + ": " + color + StringHelper.localize((String)fluid.getFluid().getLocalizedName(fluid)) + "\u00a7r");
                this.lock[i].setSheetX(176);
                this.lock[i].setHoverX(176);
                continue;
            }
            this.lock[i].setToolTip(StringHelper.localize((String)"info.cofh.unlocked"));
            this.lock[i].setSheetX(192);
            this.lock[i].setHoverX(192);
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        float pitch;
        int change;
        if (GuiScreen.func_146272_n()) {
            change = 8000;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 4000;
                pitch = 0.8f;
            }
        } else if (GuiScreen.func_146271_m()) {
            change = 500;
            pitch = 0.5f;
            if (mouseButton == 1) {
                change = 100;
                pitch = 0.4f;
            }
        } else {
            change = 2000;
            pitch = 0.7f;
            if (mouseButton == 1) {
                change = 1000;
                pitch = 0.6f;
            }
        }
        int curInput = this.myTile.amountInput;
        int curOutput = this.myTile.amountOutput;
        boolean[] curLocks = (boolean[])this.myTile.locks.clone();
        if (buttonName.equalsIgnoreCase("DecInput")) {
            this.myTile.amountInput -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncInput")) {
            this.myTile.amountInput += change;
            pitch += 0.1f;
        } else if (buttonName.equalsIgnoreCase("DecOutput")) {
            this.myTile.amountOutput -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncOutput")) {
            this.myTile.amountOutput += change;
            pitch += 0.1f;
        } else if (buttonName.equalsIgnoreCase("Lock0")) {
            if (this.myTile.locks[0]) {
                this.myTile.locks[0] = false;
                pitch = 0.4f;
            } else {
                this.myTile.locks[0] = true;
                pitch = 0.8f;
            }
        } else if (buttonName.equalsIgnoreCase("Lock1")) {
            if (this.myTile.locks[1]) {
                this.myTile.locks[1] = false;
                pitch = 0.4f;
            } else {
                this.myTile.locks[1] = true;
                pitch = 0.8f;
            }
        } else if (buttonName.equalsIgnoreCase("Lock2")) {
            if (this.myTile.locks[2]) {
                this.myTile.locks[2] = false;
                pitch = 0.4f;
            } else {
                this.myTile.locks[2] = true;
                pitch = 0.8f;
            }
        }
        GuiFluidBuffer.playClickSound((float)pitch);
        this.myTile.sendModePacket();
        this.myTile.amountInput = curInput;
        this.myTile.amountOutput = curOutput;
        this.myTile.locks = curLocks;
    }

    protected void func_146979_b(int x, int y) {
        String input = "" + this.myTile.amountInput;
        String output = "" + this.myTile.amountOutput;
        int xInput = 26;
        int xOutput = 134;
        if (this.myTile.amountInput < 100) {
            xInput += 6;
        }
        if (this.myTile.amountOutput < 100) {
            xOutput += 6;
        }
        if (this.myTile.amountInput >= 1000) {
            xInput -= 3;
        }
        if (this.myTile.amountOutput >= 1000) {
            xOutput -= 3;
        }
        this.field_146289_q.func_78276_b(input, xInput, 42, 0x404040);
        this.field_146289_q.func_78276_b(output, xOutput, 42, 0x404040);
        super.func_146979_b(x, y);
    }
}

