/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.init.CoreProps;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.container.storage.ContainerSatchel;
import cofh.thermalexpansion.item.ItemSatchel;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class GuiSatchel
extends GuiContainerCore {
    int level;
    boolean secure;
    UUID playerName;
    int storageIndex;

    public GuiSatchel(InventoryPlayer inventory, ContainerSatchel container) {
        super((Container)container);
        this.level = ItemSatchel.getLevel(container.getContainerStack());
        this.secure = SecurityHelper.isSecure((ItemStack)container.getContainerStack());
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.storageIndex = ItemSatchel.getStorageIndex(container.getContainerStack());
        this.texture = CoreProps.TEXTURE_STORAGE[this.storageIndex];
        this.name = container.getInventoryName();
        this.field_146291_p = false;
        this.field_146999_f = 14 + 18 * MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        this.field_147000_g = 112 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        this.generateInfo("tab.thermalexpansion.storage.satchel");
        if (container.getContainerStack().func_77956_u() && !ItemSatchel.hasHoldingEnchant(container.getContainerStack())) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.storage.enchant");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        if (ItemSatchel.enableSecurity && this.secure) {
            this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.field_147002_h, this.playerName));
        }
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        if (this.field_146999_f > 256 || this.field_147000_g > 256) {
            this.drawSizedTexturedModalRect(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g, 512.0f, 512.0f);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GlStateManager.func_179121_F();
    }
}

