/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import baubles.api.cap.IBaublesItemHandler;
import cofh.api.fluid.IFluidContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import com.google.common.collect.Iterables;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReservoir
extends ItemMulti
implements IInitializer,
IMultiModeItem,
IFluidContainerItem,
IEnchantableItem,
INBTCopyIngredient {
    @CapabilityInject(value=IBaublesItemHandler.class)
    private static Capability<IBaublesItemHandler> CAPABILITY_BAUBLES = null;
    private static TIntObjectHashMap<TypeEntry> typeMap = new TIntObjectHashMap();
    public static final int BUCKET_FILL = 0;
    public static final int BUCKET_EMPTY = 1;
    public static final int CAPACITY_BASE = 5000;
    public static final int CREATIVE = 32000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static boolean enable = true;
    public static ItemStack reservoirBasic;
    public static ItemStack reservoirHardened;
    public static ItemStack reservoirReinforced;
    public static ItemStack reservoirSignalum;
    public static ItemStack reservoirResonant;
    public static ItemStack reservoirCreative;

    public ItemReservoir() {
        super("thermalexpansion");
        this.func_77625_d(1);
        this.func_77655_b("reservoir");
        this.func_77637_a(ThermalExpansion.tabItems);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (this.isActive(stack)) {
            tooltip.add(StringHelper.getInfoText((String)("info.thermalexpansion.capacitor.a." + this.getMode(stack))));
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.capacitor.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.c.0"));
        } else {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.capacitor.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.c.1"));
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null) {
            String color = "\u00a77";
            if (fluid.getFluid().getRarity() == EnumRarity.UNCOMMON) {
                color = "\u00a7e";
            } else if (fluid.getFluid().getRarity() == EnumRarity.RARE) {
                color = "\u00a7b";
            } else if (fluid.getFluid().getRarity() == EnumRarity.EPIC) {
                color = "\u00a7d";
            }
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName(fluid) + "\u00a77");
            if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)fluid.amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (CoreUtils.isFakePlayer((Entity)entity)) {
            return;
        }
        if (!this.isActive(stack)) {
            return;
        }
        Iterable equipment = Iterables.concat((Iterable)entity.func_184209_aF(), ItemReservoir.getBaubles(entity));
        for (ItemStack equipmentStack : equipment) {
            IFluidHandlerItem handler;
            if (equipmentStack.equals(stack) || !FluidHelper.isFluidHandler((ItemStack)equipmentStack) || (handler = FluidUtil.getFluidHandler((ItemStack)equipmentStack)) == null || this.getFluid(stack) == null) continue;
            this.drain(stack, handler.fill(new FluidStack(this.getFluid(stack), 1000), true), true);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return ((TypeEntry)ItemReservoir.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Fluid"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000;
    }

    public int func_77619_b() {
        return 10;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        this.drain(stack, 1000, true);
        return stack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (this.setActiveState(stack, !this.isActive(stack))) {
                if (this.isActive(stack)) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
                } else {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
                }
            }
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.getMode(stack) == 0) {
            return this.doBucketFill(stack, world, player, hand);
        }
        if (this.getMode(stack) == 1) {
            return this.doBucketEmpty(stack, world, player, hand);
        }
        player.func_184609_a(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    ActionResult<ItemStack> doBucketFill(ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && this.getCapacity(stack) - fluid.amount < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    ActionResult<ItemStack> doBucketEmpty(ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null || fluid.amount < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getFluid(stack) != null) {
            stack.func_77978_p().func_74757_a("Active", state);
            return true;
        }
        stack.func_77978_p().func_74757_a("Active", false);
        return false;
    }

    public int getFluidAmount(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        return fluid == null ? 0 : fluid.amount;
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        switch (this.getMode(stack)) {
            case 0: {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.6f, 1.0f);
                break;
            }
            case 1: {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 1.0f);
            }
        }
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.reservoir.a." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("mode=%s,type=%s", this.getMode(stack), ((TypeEntry)ItemReservoir.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int mode = 0; mode < 3; ++mode) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("mode=%s,type=%s", mode, ((ItemMulti.ItemEntry)entry.getValue()).name))});
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemReservoir.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (resource == null || ItemHelper.getItemDamage((ItemStack)container) == 32000) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (!doFill) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            if (maxDrain >= stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack)) && ((TypeEntry)ItemReservoir.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable && enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this);
    }

    private static Iterable<ItemStack> getBaubles(Entity entity) {
        if (CAPABILITY_BAUBLES == null) {
            return Collections.emptyList();
        }
        IBaublesItemHandler handler = (IBaublesItemHandler)entity.getCapability(CAPABILITY_BAUBLES, null);
        if (handler == null) {
            return Collections.emptyList();
        }
        return IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IBaublesItemHandler)handler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public boolean initialize() {
        ItemReservoir.config();
        reservoirBasic = this.addEntryItem(0, "standard0", CAPACITY[0], EnumRarity.COMMON);
        reservoirHardened = this.addEntryItem(1, "standard1", CAPACITY[1], EnumRarity.COMMON);
        reservoirReinforced = this.addEntryItem(2, "standard2", CAPACITY[2], EnumRarity.UNCOMMON);
        reservoirSignalum = this.addEntryItem(3, "standard3", CAPACITY[3], EnumRarity.UNCOMMON);
        reservoirResonant = this.addEntryItem(4, "standard4", CAPACITY[4], EnumRarity.RARE);
        reservoirCreative = this.addEntryItem(32000, "creative", CAPACITY[4], EnumRarity.EPIC, false);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)reservoirBasic, (Object[])new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"});
        return true;
    }

    private static void config() {
    }

    private void addEntry(int metadata, String name, int capacity, boolean enchantable) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity, enchantable));
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, EnumRarity rarity, boolean enchantable) {
        this.addEntry(metadata, name, capacity, enchantable);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity, true);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;
        public final boolean enchantable;

        TypeEntry(String name, int capacity, boolean enchantable) {
            this.name = name;
            this.capacity = capacity;
            this.enchantable = enchantable;
        }
    }
}

