/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.forestry;

import cofh.core.util.ModPlugin;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class PluginGendustry
extends ModPlugin {
    public static final String PARENT_ID = "forestry";
    public static final String MOD_ID = "gendustry";
    public static final String MOD_NAME = "Gendustry";

    public PluginGendustry() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Gendustry is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)PARENT_ID) && Loader.isModLoaded((String)MOD_ID) && ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack dropHoney = this.getItemStack(PARENT_ID, "honey_drop", 1, 0);
            ItemStack wax = this.getItemStack(PARENT_ID, "beeswax", 1, 0);
            ItemStack[] tintedCombs = new ItemStack[16];
            ItemStack[] tintedDrops = new ItemStack[16];
            int tintedStart = 10;
            for (int i = 0; i < 16; ++i) {
                tintedCombs[i] = this.getItemStack("honey_comb", 1, i + tintedStart);
                tintedDrops[i] = this.getItemStack("honey_drop", 1, i + tintedStart);
            }
            int energy = 4000;
            for (int i = 0; i < 16; ++i) {
                CentrifugeManager.addRecipe(energy, tintedCombs[i], Arrays.asList(tintedDrops[i], dropHoney, wax), Arrays.asList(100, 30, 50), null);
            }
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Gendustry Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Gendustry Plugin Enabled.");
        }
        return !this.error;
    }
}

