/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.brewer;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiBrewer;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.brewer.BrewerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeCategory
extends BaseRecipeCategory<BrewerRecipeWrapper> {
    public static boolean enable = true;
    final IDrawableStatic progress;
    final IDrawableStatic speed;
    final IDrawableStatic tank;
    final IDrawableStatic tankOverlayInput;
    final IDrawableStatic tankOverlayOutput;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BrewerRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(BrewerRecipeCategory.getRecipes(guiHelper), "thermalexpansion.brewer");
        registry.addRecipeClickArea(GuiBrewer.class, 112, 34, 24, 16, new String[]{"thermalexpansion.brewer"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineBrewer, new String[]{"thermalexpansion.brewer"});
    }

    public static List<BrewerRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<BrewerRecipeWrapper> recipes = new ArrayList<BrewerRecipeWrapper>();
        for (BrewerManager.BrewerRecipe recipe : BrewerManager.getRecipeList()) {
            recipes.add(new BrewerRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public BrewerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiBrewer.TEXTURE, 26, 11, 72, 62, 0, 0, 16, 76);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.brewer.name");
        this.speed = Drawables.getDrawables(guiHelper).getScale(0);
        this.progress = Drawables.getDrawables(guiHelper).getProgress(2);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlayInput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
        this.tankOverlayOutput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.brewer";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 94, 23);
        this.speed.draw(minecraft, 46, 23);
        this.tank.draw(minecraft, 125, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BrewerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputItems = ingredients.getInputs(ItemStack.class);
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputFluids = ingredients.getOutputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 69, 22);
        guiFluidStacks.init(0, true, 22, 16, 16, 30, 1000, false, (IDrawable)this.tankOverlayInput);
        guiFluidStacks.init(1, false, 126, 1, 16, 60, 1000, false, (IDrawable)this.tankOverlayOutput);
        guiItemStacks.set(0, (List)inputItems.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        guiFluidStacks.set(1, (List)outputFluids.get(0));
        guiFluidStacks.addTooltipCallback((i, b, fluidStack, list) -> {
            if (FluidHelper.isPotionFluid((FluidStack)fluidStack)) {
                FluidHelper.addPotionTooltip((FluidStack)fluidStack, (List)list);
            }
        });
    }
}

