/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.enchanter;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiEnchanter;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.enchanter.EnchanterRecipeCategoryEmpowered;
import cofh.thermalexpansion.plugins.jei.crafting.enchanter.EnchanterRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class EnchanterRecipeCategory
extends BaseRecipeCategory<EnchanterRecipeWrapper> {
    public static boolean enable = true;
    final IDrawableStatic progress;
    final IDrawableStatic speed;
    final IDrawableStatic tank;
    final IDrawableStatic tankOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategoryEmpowered(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(EnchanterRecipeCategory.getRecipes(guiHelper), "thermalexpansion.enchanter");
        registry.addRecipeClickArea(GuiEnchanter.class, 79, 34, 24, 16, new String[]{"thermalexpansion.enchanter", "thermalexpansion.enchanter_treasure", "thermalexpansion.enchanter_empowered"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineEnchanter, new String[]{"thermalexpansion.enchanter"});
    }

    public static List<EnchanterRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<EnchanterRecipeWrapper> recipes = new ArrayList<EnchanterRecipeWrapper>();
        for (EnchanterManager.EnchanterRecipe recipe : EnchanterManager.getRecipeList()) {
            if (recipe.getType() != EnchanterManager.Type.STANDARD) continue;
            recipes.add(new EnchanterRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public EnchanterRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiEnchanter.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.enchanter.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(11);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankLargeOverlay(0);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.enchanter";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 33);
        this.tank.draw(minecraft, 140, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnchanterRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 21, 14);
        guiItemStacks.init(1, true, 45, 14);
        guiItemStacks.init(2, false, 105, 23);
        guiFluidStacks.init(0, true, 141, 1, 16, 60, 10000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)inputs.get(1));
        guiItemStacks.set(2, (List)outputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
    }
}

