/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.pulverizer;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiPulverizer;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.pulverizer.PulverizerRecipeCategoryPetrotheum;
import cofh.thermalexpansion.plugins.jei.crafting.pulverizer.PulverizerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class PulverizerRecipeCategory
extends BaseRecipeCategory<PulverizerRecipeWrapper> {
    public static boolean enable = true;
    final IDrawableStatic progress;
    final IDrawableStatic speed;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new PulverizerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PulverizerRecipeCategoryPetrotheum(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(PulverizerRecipeCategory.getRecipes(guiHelper), "thermalexpansion.pulverizer");
        registry.addRecipeClickArea(GuiPulverizer.class, 79, 34, 24, 16, new String[]{"thermalexpansion.pulverizer", "thermalexpansion.pulverizer_petrotheum"});
        registry.addRecipeCatalyst((Object)BlockMachine.machinePulverizer, new String[]{"thermalexpansion.pulverizer"});
        PulverizerRecipeCategoryPetrotheum.initialize(registry);
    }

    public static List<PulverizerRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<PulverizerRecipeWrapper> recipes = new ArrayList<PulverizerRecipeWrapper>();
        for (PulverizerManager.PulverizerRecipe recipe : PulverizerManager.getRecipeList()) {
            recipes.add(new PulverizerRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public PulverizerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiPulverizer.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.pulverizer.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(3);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.pulverizer";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PulverizerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 14);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
        if (outputs.size() > 1) {
            guiItemStacks.init(2, false, 105, 41);
            guiItemStacks.set(2, (List)outputs.get(1));
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 2) {
                    tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
                }
            });
        }
    }
}

