/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.pulverizer;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.TilePulverizer;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class PulverizerRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<List<FluidStack>> inputFluids;
    final List<ItemStack> outputs;
    final int chance;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public PulverizerRecipeWrapper(IGuiHelper guiHelper, PulverizerManager.PulverizerRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.pulverizer");
    }

    public PulverizerRecipeWrapper(IGuiHelper guiHelper, PulverizerManager.PulverizerRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        int oreID = PulverizerManager.ComparableItemStackPulverizer.getOreID(recipe.getInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        if (this.uId.equals("thermalexpansion.pulverizer_petrotheum")) {
            recipeInputFluids.add(new FluidStack(TFFluids.fluidPetrotheum, 100));
            this.inputFluids = Collections.singletonList(recipeInputFluids);
            recipeOutputs.add(ItemHelper.cloneStack((ItemStack)recipe.getPrimaryOutput(), (int)TilePulverizer.getPetrotheumOutputAmount(recipe.getPrimaryOutput())));
            this.energy = recipe.getEnergy() * 150 / 100;
        } else {
            this.inputFluids = Collections.emptyList();
            recipeOutputs.add(recipe.getPrimaryOutput());
            this.energy = recipe.getEnergy();
        }
        if (recipe.getSecondaryOutput() != null) {
            recipeOutputs.add(recipe.getSecondaryOutput());
        }
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputs = recipeOutputs;
        this.chance = recipe.getSecondaryOutputChance();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(this.uId.equals("thermalexpansion.pulverizer_petrotheum") ? 1 : 0);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(3);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TilePulverizer.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TilePulverizer.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setInputLists(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.uId.equals("thermalexpansion.pulverizer_petrotheum")) {
            JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0).get(0), 24, 16);
            this.fluid.draw(minecraft, 69, 23);
        }
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
        if (this.chance > 0) {
            String dispChance = StringHelper.formatNumber((long)this.chance) + "%";
            minecraft.field_71466_p.func_78276_b(dispChance, 102 - 6 * dispChance.length(), 48, 0x808080);
        }
    }
}

