/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.refinery;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiRefinery;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.refinery.RefineryRecipeCategoryOil;
import cofh.thermalexpansion.plugins.jei.crafting.refinery.RefineryRecipeCategoryPotion;
import cofh.thermalexpansion.plugins.jei.crafting.refinery.RefineryRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeCategory
extends BaseRecipeCategory<RefineryRecipeWrapper> {
    public static boolean enable = true;
    final IDrawableStatic progress;
    final IDrawableStatic speed;
    final IDrawableStatic slot;
    final IDrawableStatic tank;
    final IDrawableStatic tankOverlayInput;
    final IDrawableStatic tankOverlayOutput;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new RefineryRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RefineryRecipeCategoryOil(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RefineryRecipeCategoryPotion(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(RefineryRecipeCategory.getRecipes(guiHelper), "thermalexpansion.refinery");
        registry.addRecipeClickArea(GuiRefinery.class, 76, 34, 24, 16, new String[]{"thermalexpansion.refinery", "thermalexpansion.refinery_oil", "thermalexpansion.refinery_potion"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineRefinery, new String[]{"thermalexpansion.refinery"});
        RefineryRecipeCategoryOil.initialize(registry);
        RefineryRecipeCategoryPotion.initialize(registry);
    }

    public static List<RefineryRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<RefineryRecipeWrapper> recipes = new ArrayList<RefineryRecipeWrapper>();
        for (RefineryManager.RefineryRecipe recipe : RefineryManager.getRecipeList()) {
            recipes.add(new RefineryRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public RefineryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiRefinery.TEXTURE, 38, 11, 24, 62, 0, 0, 16, 124);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.refinery.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(2);
        this.speed = Drawables.getDrawables(guiHelper).getScale(4);
        this.slot = Drawables.getDrawables(guiHelper).getSlot(1);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlayInput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
        this.tankOverlayOutput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.refinery";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 46, 23);
        this.speed.draw(minecraft, 22, 40);
        this.slot.draw(minecraft, 77, 19);
        this.tank.draw(minecraft, 116, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RefineryRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputFluids = ingredients.getOutputs(FluidStack.class);
        List outputItems = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, false, 81, 23);
        guiFluidStacks.init(0, true, 22, 8, 16, 30, 1000, false, (IDrawable)this.tankOverlayInput);
        guiFluidStacks.init(1, false, 117, 1, 16, 60, 1000, false, (IDrawable)this.tankOverlayOutput);
        guiItemStacks.set(0, (List)outputItems.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        guiFluidStacks.set(1, (List)outputFluids.get(0));
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 0 && recipeWrapper.chance < 100) {
                tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
            }
        });
        guiFluidStacks.addTooltipCallback((i, b, fluidStack, list) -> {
            if (FluidHelper.isPotionFluid((FluidStack)fluidStack)) {
                FluidHelper.addPotionTooltip((FluidStack)fluidStack, (List)list);
            }
        });
    }
}

