/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.sawmill;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiSawmill;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.sawmill.SawmillRecipeCategoryTapper;
import cofh.thermalexpansion.plugins.jei.crafting.sawmill.SawmillRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class SawmillRecipeCategory
extends BaseRecipeCategory<SawmillRecipeWrapper> {
    public static boolean enable = true;
    final IDrawableStatic progress;
    final IDrawableStatic speed;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategoryTapper(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(SawmillRecipeCategory.getRecipes(guiHelper), "thermalexpansion.sawmill");
        registry.addRecipeClickArea(GuiSawmill.class, 79, 34, 24, 16, new String[]{"thermalexpansion.sawmill", "thermalexpansion.sawmill_tapper"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineSawmill, new String[]{"thermalexpansion.sawmill"});
        SawmillRecipeCategoryTapper.initialize(registry);
    }

    public static List<SawmillRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<SawmillRecipeWrapper> recipes = new ArrayList<SawmillRecipeWrapper>();
        for (SawmillManager.SawmillRecipe recipe : SawmillManager.getRecipeList()) {
            recipes.add(new SawmillRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public SawmillRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiSawmill.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.sawmill.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(7);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.sawmill";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SawmillRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 14);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
        if (outputs.size() > 1) {
            guiItemStacks.init(2, false, 105, 41);
            guiItemStacks.set(2, (List)outputs.get(1));
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 2) {
                    tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
                }
            });
        }
    }
}

