/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.block.storage.BlockCell;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakeryCell
implements ILayeredBlockBakery {
    public static final BakeryCell INSTANCE = new BakeryCell();
    static CCModel modelCenter = CCModel.quadModel((int)24);
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public void renderCenter(CCRenderState ccrs) {
        modelCenter.render(ccrs, new IVertexOperation[]{new IconTransformation(TETextures.CELL_CENTER_1)});
    }

    public void renderFrame(CCRenderState ccrs, boolean creative, int level, byte[] sideCache, int facing, TextureAtlasSprite faceTexture) {
        if (creative) {
            level = 5;
        }
        for (int i = 0; i < 6; ++i) {
            modelFrame.render(ccrs, i * 4, i * 4 + 4, new IVertexOperation[]{new IconTransformation(TETextures.CELL_SIDE[level])});
            modelFrame.render(ccrs, i * 4 + 24, i * 4 + 28, new IVertexOperation[]{new IconTransformation(TETextures.CELL_INNER[level])});
        }
        if (sideCache != null) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                modelFrame.render(ccrs, face.ordinal() * 4, face.ordinal() * 4 + 4, new IVertexOperation[]{new IconTransformation(TETextures.CELL_CONFIG[sideCache[face.ordinal()]])});
            }
            modelFrame.render(ccrs, facing * 4, facing * 4 + 4, new IVertexOperation[]{new IconTransformation(faceTexture)});
        }
    }

    private int getScaledEnergyStored(ItemStack container, int scale) {
        IEnergyContainerItem containerItem = (IEnergyContainerItem)container.func_77973_b();
        return (int)((long)containerItem.getEnergyStored(container) * (long)scale / (long)containerItem.getMaxEnergyStored(container));
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileCell cell = (TileCell)world.func_175625_s(pos);
        if (cell == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(TEProps.TILE_CELL, (Object)cell);
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        if (face == null && !stack.func_190926_b()) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            boolean creative = BlockCell.itemBlock.isCreative(stack);
            int level = BlockCell.itemBlock.getLevel(stack);
            int scale = Math.min(8, this.getScaledEnergyStored(stack, 9));
            this.renderFrame(ccrs, creative, level, null, 0, null);
            ccrs.brightness = 160 + scale * 10;
            this.renderCenter(ccrs);
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        if (face == null && state != null) {
            TileCell cell = (TileCell)((Object)state.getValue(TEProps.TILE_CELL));
            boolean creative = cell.isCreative;
            int level = cell.getLevel();
            int scale = cell.getLightValue();
            TextureAtlasSprite meter = creative ? TETextures.CELL_METER_C : TETextures.CELL_METER[scale];
            int facing = cell.getFacing();
            byte[] sideCache = cell.sideCache;
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            if (layer == BlockRenderLayer.CUTOUT) {
                this.renderFrame(ccrs, creative, level, sideCache, facing, meter);
            } else if (layer == BlockRenderLayer.TRANSLUCENT) {
                ccrs.brightness = 160 + scale * 10;
                this.renderCenter(ccrs);
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    static {
        modelCenter.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        double inset = 0.1875;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, box);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            BakeryCell.modelFrame.verts[i].vec.add(modelFrame.normals()[i].copy().multiply(inset));
        }
        modelFrame.shrinkUVs(0.001953125);
    }
}

