/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util;

import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.dynamo.CompressionManager;
import cofh.thermalexpansion.util.managers.dynamo.MagmaticManager;
import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    public static final IMCHandler INSTANCE = new IMCHandler();
    static final String ENERGY = "energy";
    static final String EXPERIENCE = "experience";
    static final String FLUID = "fluid";
    static final String FLUID_NAME = "fluidName";
    static final String REVERSIBLE = "reversible";
    static final String CHANCE = "chance";
    static final String INPUT = "input";
    static final String OUTPUT = "output";
    static final String PRIMARY_INPUT = "primaryInput";
    static final String SECONDARY_INPUT = "secondaryInput";
    static final String PRIMARY_OUTPUT = "primaryOutput";
    static final String SECONDARY_OUTPUT = "secondaryOutput";
    public static final String ADD_FURNACE_RECIPE = "addfurnacerecipe";
    public static final String ADD_PULVERIZER_RECIPE = "addpulverizerrecipe";
    public static final String ADD_SAWMILL_RECIPE = "addsawmillrecipe";
    public static final String ADD_SMELTER_RECIPE = "addsmelterrecipe";
    public static final String ADD_INSOLATOR_RECIPE = "addinsolatorrecipe";
    public static final String ADD_COMPACTOR_PRESS_RECIPE = "addcompactorpressrecipe";
    public static final String ADD_COMPACTOR_STORAGE_RECIPE = "addcompactorstoragerecipe";
    public static final String ADD_COMPACTOR_MINT_RECIPE = "addcompactormintrecipe";
    public static final String ADD_CRUCIBLE_RECIPE = "addcruciblerecipe";
    public static final String ADD_REFINERY_RECIPE = "addrefineryrecipe";
    public static final String ADD_TRANSPOSER_FILL_RECIPE = "addtransposerfillrecipe";
    public static final String ADD_TRANSPOSER_EXTRACT_RECIPE = "addtransposerextractrecipe";
    public static final String ADD_CHARGER_RECIPE = "addchargerrecipe";
    public static final String ADD_CENTRIFUGE_RECIPE = "addcentrifugerecipe";
    public static final String ADD_BREWER_RECIPE = "addbrewerrecipe";
    public static final String ADD_ENCHANTER_RECIPE = "addenchanterrecipe";
    public static final String REMOVE_FURNACE_RECIPE = "removefurnacerecipe";
    public static final String REMOVE_PULVERIZER_RECIPE = "removepulverizerrecipe";
    public static final String REMOVE_SAWMILL_RECIPE = "removesawmillrecipe";
    public static final String REMOVE_SMELTER_RECIPE = "removesmelterrecipe";
    public static final String REMOVE_INSOLATOR_RECIPE = "removeinsolatorrecipe";
    public static final String REMOVE_COMPACTOR_PRESS_RECIPE = "removecompactorpressrecipe";
    public static final String REMOVE_COMPACTOR_STORAGE_RECIPE = "removecompactorstoragerecipe";
    public static final String REMOVE_COMPACTOR_MINT_RECIPE = "removecompactormintrecipe";
    public static final String REMOVE_CRUCIBLE_RECIPE = "removecruciblerecipe";
    public static final String REMOVE_REFINERY_RECIPE = "removerefineryrecipe";
    public static final String REMOVE_TRANSPOSER_FILL_RECIPE = "removetransposerfillrecipe";
    public static final String REMOVE_TRANSPOSER_EXTRACT_RECIPE = "removetransposerextractrecipe";
    public static final String REMOVE_CHARGER_RECIPE = "removechargerrecipe";
    public static final String REMOVE_CENTRIFUGE_RECIPE = "removecentrifugerecipe";
    public static final String REMOVE_BREWER_RECIPE = "removebrewerrecipe";
    public static final String REMOVE_ENCHANTER_RECIPE = "removeenchanterrecipe";
    public static final String ADD_MAGMATIC_FUEL = "addmagmaticfuel";
    public static final String ADD_COMPRESSION_FUEL = "addcompressionfuel";

    public void handleIMC(List<FMLInterModComms.IMCMessage> messages) {
        block74: for (FMLInterModComms.IMCMessage message : messages) {
            try {
                String operation;
                if (!message.isNBTMessage()) continue;
                NBTTagCompound nbt = message.getNBTValue();
                switch (operation = message.key.toLowerCase(Locale.US)) {
                    case "addfurnacerecipe": {
                        FurnaceManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)));
                        continue block74;
                    }
                    case "addpulverizerrecipe": {
                        if (nbt.func_74764_b(CHANCE)) {
                            PulverizerManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)), nbt.func_74762_e(CHANCE));
                            continue block74;
                        }
                        if (nbt.func_74764_b(SECONDARY_OUTPUT)) {
                            PulverizerManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)));
                            continue block74;
                        }
                        PulverizerManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)));
                        continue block74;
                    }
                    case "addsawmillrecipe": {
                        if (nbt.func_74764_b(CHANCE)) {
                            SawmillManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)), nbt.func_74762_e(CHANCE));
                            continue block74;
                        }
                        if (nbt.func_74764_b(SECONDARY_OUTPUT)) {
                            SawmillManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)));
                            continue block74;
                        }
                        SawmillManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)));
                        continue block74;
                    }
                    case "addsmelterrecipe": {
                        if (nbt.func_74764_b(CHANCE)) {
                            SmelterManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)), nbt.func_74762_e(CHANCE));
                            continue block74;
                        }
                        if (nbt.func_74764_b(SECONDARY_OUTPUT)) {
                            SmelterManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)));
                            continue block74;
                        }
                        SmelterManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)));
                        continue block74;
                    }
                    case "addinsolatorrecipe": {
                        if (nbt.func_74764_b(CHANCE)) {
                            InsolatorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)), nbt.func_74762_e(CHANCE));
                            continue block74;
                        }
                        if (nbt.func_74764_b(SECONDARY_OUTPUT)) {
                            InsolatorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)));
                            continue block74;
                        }
                        InsolatorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)));
                        continue block74;
                    }
                    case "addcompactorpressrecipe": {
                        CompactorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), CompactorManager.Mode.PRESS);
                        continue block74;
                    }
                    case "addcompactorstoragerecipe": {
                        CompactorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), CompactorManager.Mode.STORAGE);
                        continue block74;
                    }
                    case "addcompactormintrecipe": {
                        CompactorManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), CompactorManager.Mode.MINT);
                        continue block74;
                    }
                    case "addcruciblerecipe": {
                        CrucibleManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(OUTPUT)));
                        continue block74;
                    }
                    case "addrefineryrecipe": {
                        RefineryManager.addRecipe(nbt.func_74762_e(ENERGY), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(OUTPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_OUTPUT)));
                        continue block74;
                    }
                    case "addtransposerfillrecipe": {
                        TransposerManager.addFillRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID)), nbt.func_74767_n(REVERSIBLE));
                        continue block74;
                    }
                    case "addtransposerextractrecipe": {
                        TransposerManager.addExtractRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID)), nbt.func_74762_e(CHANCE), nbt.func_74767_n(REVERSIBLE));
                        continue block74;
                    }
                    case "addchargerrecipe": {
                        ChargerManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)));
                        continue block74;
                    }
                    case "addcentrifugerecipe": {
                        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
                        ArrayList<Integer> chance = new ArrayList<Integer>();
                        FluidStack fluid = null;
                        if (nbt.func_74764_b(OUTPUT)) {
                            NBTTagList list = nbt.func_150295_c(OUTPUT, 10);
                            for (int i = 0; i < list.func_74745_c(); ++i) {
                                NBTTagCompound tag = list.func_150305_b(i);
                                output.add(new ItemStack(tag));
                                if (tag.func_74764_b(CHANCE)) {
                                    chance.add(tag.func_74762_e(CHANCE));
                                    continue;
                                }
                                chance.add(100);
                            }
                        }
                        if (nbt.func_74764_b(FLUID)) {
                            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID));
                        }
                        CentrifugeManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(INPUT)), output, chance, fluid);
                        continue block74;
                    }
                    case "addbrewerrecipe": {
                        BrewerManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(SECONDARY_INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(OUTPUT)));
                        continue block74;
                    }
                    case "addenchanterrecipe": {
                        EnchanterManager.addRecipe(nbt.func_74762_e(ENERGY), new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)), new ItemStack(nbt.func_74775_l(PRIMARY_OUTPUT)), nbt.func_74762_e(EXPERIENCE), EnchanterManager.Type.STANDARD);
                        continue block74;
                    }
                    case "removefurnacerecipe": {
                        FurnaceManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removepulverizerrecipe": {
                        PulverizerManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removesawmillrecipe": {
                        SawmillManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removesmelterrecipe": {
                        SmelterManager.removeRecipe(new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)));
                        continue block74;
                    }
                    case "removeinsolatorrecipe": {
                        InsolatorManager.removeRecipe(new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)));
                        continue block74;
                    }
                    case "removecompactorpressrecipe": {
                        CompactorManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)), CompactorManager.Mode.PRESS);
                        continue block74;
                    }
                    case "removecompactorstoragerecipe": {
                        CompactorManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)), CompactorManager.Mode.STORAGE);
                        continue block74;
                    }
                    case "removecompactormintrecipe": {
                        CompactorManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)), CompactorManager.Mode.MINT);
                        continue block74;
                    }
                    case "removecruciblerecipe": {
                        CrucibleManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removerefineryrecipe": {
                        RefineryManager.removeRecipe(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removetransposerfillrecipe": {
                        TransposerManager.removeFillRecipe(new ItemStack(nbt.func_74775_l(INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID)));
                        continue block74;
                    }
                    case "removetransposerextractrecipe": {
                        TransposerManager.removeExtractRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removechargerrecipe": {
                        ChargerManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removecentrifugerecipe": {
                        CentrifugeManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block74;
                    }
                    case "removebrewerrecipe": {
                        BrewerManager.removeRecipe(new ItemStack(nbt.func_74775_l(INPUT)), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID)));
                        continue block74;
                    }
                    case "removeenchanterrecipe": {
                        EnchanterManager.removeRecipe(new ItemStack(nbt.func_74775_l(PRIMARY_INPUT)), new ItemStack(nbt.func_74775_l(SECONDARY_INPUT)));
                        continue block74;
                    }
                    case "addmagmaticfuel": {
                        MagmaticManager.addFuel(nbt.func_74779_i(FLUID_NAME).toLowerCase(Locale.ENGLISH), nbt.func_74762_e(ENERGY));
                        continue block74;
                    }
                    case "addcompressionfuel": {
                        CompressionManager.addFuel(nbt.func_74779_i(FLUID_NAME).toLowerCase(Locale.ENGLISH), nbt.func_74762_e(ENERGY));
                        continue block74;
                    }
                }
                ThermalExpansion.LOG.warn("Thermal Expansion received an invalid IMC from " + message.getSender() + "! Key was " + message.key);
            }
            catch (Exception e) {
                ThermalExpansion.LOG.warn("Thermal Expansion received a broken IMC from " + message.getSender() + "!");
                e.printStackTrace();
            }
        }
    }
}

