/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import cofh.core.inventory.ComparableItemStack;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class DiffuserManager {
    private static TObjectIntHashMap<ComparableItemStack> reagentAmpMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<ComparableItemStack> reagentDurMap = new TObjectIntHashMap();

    public static boolean isValidReagent(ItemStack stack) {
        return reagentAmpMap.containsKey((Object)new ComparableItemStack(stack));
    }

    public static int getReagentAmplifier(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return reagentAmpMap.get((Object)new ComparableItemStack(stack));
    }

    public static int getReagentDuration(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return reagentDurMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        DiffuserManager.addReagent(new ItemStack(Items.field_151137_ax), 0, 1);
        DiffuserManager.addReagent(new ItemStack(Items.field_151114_aO), 1, 0);
    }

    public static void refresh() {
        TObjectIntHashMap tempAmpMap = new TObjectIntHashMap(reagentAmpMap.size());
        TObjectIntHashMap tempDurMap = new TObjectIntHashMap(reagentDurMap.size());
        TObjectIntIterator it = reagentAmpMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempAmpMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        it = reagentDurMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempDurMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        reagentAmpMap.clear();
        reagentDurMap.clear();
        reagentAmpMap = tempAmpMap;
        reagentDurMap = tempDurMap;
    }

    private static void addReagent(ItemStack reagent, int amp, int dur) {
        reagentAmpMap.put((Object)new ComparableItemStack(reagent), amp);
        reagentDurMap.put((Object)new ComparableItemStack(reagent), dur);
    }

    private static void removeReagent(ItemStack reagent) {
        reagentAmpMap.remove((Object)new ComparableItemStack(reagent));
        reagentDurMap.remove((Object)new ComparableItemStack(reagent));
    }
}

