/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import cofh.core.inventory.ComparableItemStack;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class XpCollectorManager {
    private static TObjectIntHashMap<ComparableItemStack> catalystMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<ComparableItemStack> catalystFactorMap = new TObjectIntHashMap();

    public static int getCatalystXp(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return catalystMap.get((Object)new ComparableItemStack(stack));
    }

    public static int getCatalystFactor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return catalystFactorMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        XpCollectorManager.addCatalyst(new ItemStack(Blocks.field_150425_aM), 50, 50);
        XpCollectorManager.addCatalyst(new ItemStack(Items.field_151100_aR, 1, 4), 100, 100);
        XpCollectorManager.addCatalyst(ItemMaterial.dustMana, 200, 150);
    }

    public static void refresh() {
        TObjectIntHashMap tempCatalystMap = new TObjectIntHashMap(catalystMap.size());
        TObjectIntHashMap tempCatalystFactorMap = new TObjectIntHashMap(catalystFactorMap.size());
        TObjectIntIterator it = catalystMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempCatalystMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        it = catalystFactorMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempCatalystFactorMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        catalystMap.clear();
        catalystFactorMap.clear();
        catalystMap = tempCatalystMap;
        catalystFactorMap = tempCatalystFactorMap;
    }

    private static void addCatalyst(ItemStack catalyst, int xp, int factor) {
        catalystMap.put((Object)new ComparableItemStack(catalyst), xp);
        catalystFactorMap.put((Object)new ComparableItemStack(catalyst), factor);
    }

    private static void removeCatalyst(ItemStack catalyst) {
        catalystMap.remove((Object)new ComparableItemStack(catalyst));
        catalystFactorMap.remove((Object)new ComparableItemStack(catalyst));
    }
}

