/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;

public class EnchanterManager {
    private static Map<List<ComparableItemStackEnchanter>, EnchanterRecipe> recipeMap = new THashMap();
    private static Set<ComparableItemStackEnchanter> validationSet = new THashSet();
    private static Set<ComparableItemStackEnchanter> lockSet = new THashSet();
    public static final ItemStack ITEM_BOOK = new ItemStack(Items.field_151122_aG);
    public static final int[] DEFAULT_ENERGY = new int[]{4000, 8000, 12000, 16000, 20000};
    public static final int[] DEFAULT_EXPERIENCE = new int[]{500, 1500, 3000, 5000, 7500};

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return false;
        }
        ComparableItemStackEnchanter query = new ComparableItemStackEnchanter(primaryInput);
        ComparableItemStackEnchanter querySecondary = new ComparableItemStackEnchanter(secondaryInput);
        EnchanterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        return recipe == null && recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static EnchanterRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return null;
        }
        ComparableItemStackEnchanter query = new ComparableItemStackEnchanter(primaryInput);
        ComparableItemStackEnchanter querySecondary = new ComparableItemStackEnchanter(secondaryInput);
        EnchanterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return EnchanterManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static EnchanterRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new EnchanterRecipe[recipeMap.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains((Object)new ComparableItemStackEnchanter(input));
    }

    public static boolean isItemArcana(ItemStack input) {
        return !input.func_190926_b() && lockSet.contains((Object)new ComparableItemStackEnchanter(input));
    }

    public static void initialize() {
        ItemStack book = new ItemStack(Items.field_151122_aG);
        EnchanterManager.addArcana(book);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150343_Z), "unbreaking", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151156_bN), "mending", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_185162_cT), "binding_curse", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151042_j), "protection", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151064_bs), "fire_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151008_G), "feather_falling", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151016_H), "blast_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_185159_cQ), "projectile_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151115_aP, 1, 3), "respiration", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_179563_cD), "aqua_affinity", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_179562_cC), "depth_strider", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), "thorns", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150432_aD), "frost_walker", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151073_bk), "vanishing_curse", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151128_bU), "sharpness", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151078_bh), "smite", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151070_bp), "bane_of_arthropods", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150331_J), "knockback", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151072_bj), "fire_aspect", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151043_k), "looting", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151120_aE), "sweeping", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151137_ax), "efficiency", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151166_bC), "fortune", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151114_aO), "silk_touch", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151145_ak), "power", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151007_F), "punch", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151065_br), "flame", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151061_bv), "infinity", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151115_aP, 1, 2), "luck_of_the_sea", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151146_bM), "lure", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150486_ae), "cofhcore:holding", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151062_by), "cofhcore:insight", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150425_aM), "cofhcore:leech", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151032_g), "cofhcore:multishot", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150460_al), "cofhcore:smelting", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151144_bL, 1, 1), "cofhcore:vorpal", 3);
        EnchanterManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<ComparableItemStackEnchanter>, EnchanterRecipe> entry : recipeMap.entrySet()) {
            EnchanterRecipe tempRecipe = entry.getValue();
            ComparableItemStackEnchanter primary = new ComparableItemStackEnchanter(tempRecipe.primaryInput);
            ComparableItemStackEnchanter secondary = new ComparableItemStackEnchanter(tempRecipe.secondaryInput);
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        THashSet tempSet2 = new THashSet();
        for (ComparableItemStackEnchanter entry : lockSet) {
            ComparableItemStackEnchanter lock = new ComparableItemStackEnchanter(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static EnchanterRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack output, int experience, Type type) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || energy <= 0 || EnchanterManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        EnchanterRecipe recipe = new EnchanterRecipe(primaryInput, secondaryInput, output, experience, energy, type);
        recipeMap.put(Arrays.asList(new ComparableItemStackEnchanter(primaryInput), new ComparableItemStackEnchanter(secondaryInput)), recipe);
        validationSet.add(new ComparableItemStackEnchanter(primaryInput));
        validationSet.add(new ComparableItemStackEnchanter(secondaryInput));
        return recipe;
    }

    public static void addDefaultEnchantmentRecipe(ItemStack input, String enchantName, int tier) {
        if (tier < 0 || tier > 4) {
            return;
        }
        Enchantment enchant = Enchantment.func_180305_b((String)enchantName);
        if (enchant == null) {
            return;
        }
        EnchanterManager.addRecipe(DEFAULT_ENERGY[tier], ITEM_BOOK, input, ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchant, 1)), DEFAULT_EXPERIENCE[tier], Type.STANDARD);
    }

    public static EnchanterRecipe removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        return recipeMap.remove(Arrays.asList(new ComparableItemStackEnchanter(primaryInput), new ComparableItemStackEnchanter(secondaryInput)));
    }

    private static void addArcana(ItemStack arcana) {
        lockSet.add(new ComparableItemStackEnchanter(arcana));
    }

    public static class ComparableItemStackEnchanter
    extends ComparableItemStack {
        public static final String INGOT = "ingot";
        public static final String NUGGET = "nugget";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(INGOT) || oreName.startsWith(NUGGET);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackEnchanter.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackEnchanter(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackEnchanter.getOreID(stack);
        }
    }

    public static enum Type {
        STANDARD,
        EMPOWERED;

    }

    public static class EnchanterRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack output;
        final int experience;
        final int energy;
        final Type type;

        EnchanterRecipe(ItemStack primaryInput, ItemStack secondaryInput, ItemStack output, int experience, int energy, Type type) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.output = output;
            this.experience = experience;
            this.energy = energy;
            this.type = type;
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getExperience() {
            return this.experience;
        }

        public Type getType() {
            return this.type;
        }
    }
}

