/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Set;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RefineryManager {
    private static TIntObjectHashMap<RefineryRecipe> recipeMap = new TIntObjectHashMap();
    private static TIntObjectHashMap<RefineryRecipe> recipeMapPotion = new TIntObjectHashMap();
    private static Set<String> oilFluids = new THashSet();
    public static final int DEFAULT_ENERGY = 5000;

    public static RefineryRecipe getRecipe(FluidStack input) {
        return input == null ? null : (RefineryRecipe)recipeMap.get(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static RefineryRecipe getRecipePotion(FluidStack input) {
        return input == null ? null : (RefineryRecipe)recipeMapPotion.get(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static boolean recipeExists(FluidStack input) {
        return RefineryManager.getRecipe(input) != null;
    }

    public static boolean recipeExistsPotion(FluidStack input) {
        return RefineryManager.getRecipePotion(input) != null;
    }

    public static RefineryRecipe[] getRecipeList() {
        return (RefineryRecipe[])recipeMap.values((Object[])new RefineryRecipe[recipeMap.size()]);
    }

    public static RefineryRecipe[] getRecipeListPotion() {
        return (RefineryRecipe[])recipeMapPotion.values((Object[])new RefineryRecipe[recipeMapPotion.size()]);
    }

    public static boolean isFossilFuel(FluidStack fluid) {
        return fluid != null && oilFluids.contains(fluid.getFluid().getName());
    }

    public static void initialize() {
        int energy = 5000;
        RefineryManager.addFossilFuel(TFFluids.fluidCoal);
        RefineryManager.addFossilFuel(TFFluids.fluidCrudeOil);
        RefineryManager.addFossilFuel(TFFluids.fluidRefinedOil);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidCoal, 200), new FluidStack(TFFluids.fluidRefinedOil, 100), ItemMaterial.globTar, 75);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidCrudeOil, 200), new FluidStack(TFFluids.fluidRefinedOil, 150), ItemMaterial.globTar, 50);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidRefinedOil, 150), new FluidStack(TFFluids.fluidFuel, 100), ItemMaterial.dustSulfur, 50);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidResin, 100), new FluidStack(TFFluids.fluidTreeOil, 50), ItemMaterial.globRosin, 75);
        RefineryManager.addStrongPotionRecipes("leaping", 5);
        RefineryManager.addStrongPotionRecipes("swiftness", 5);
        RefineryManager.addStrongPotionRecipes("healing", 5);
        RefineryManager.addStrongPotionRecipes("harming", 5);
        RefineryManager.addStrongPotionRecipes("poison", 5);
        RefineryManager.addStrongPotionRecipes("regeneration", 5);
        RefineryManager.addStrongPotionRecipes("strength", 5);
        RefineryManager.addStrongPotionRecipes("haste", 4);
        RefineryManager.addStrongPotionRecipes("resistance", 5);
        RefineryManager.addStrongPotionRecipes("absorption", 5);
        RefineryManager.addStrongPotionRecipes("wither", 5);
        RefineryManager.loadRecipes();
    }

    public static void loadRecipes() {
        Fluid oil = FluidRegistry.getFluid((String)"oil");
        if (oil != null) {
            RefineryManager.addFossilFuel(oil);
            RefineryManager.addRecipe(5000, new FluidStack(oil, 200), new FluidStack(TFFluids.fluidRefinedOil, 150), ItemMaterial.globTar, 50);
        }
    }

    public static void refresh() {
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem, int chance) {
        if (input == null || outputFluid == null || energy <= 0 || RefineryManager.recipeExists(input)) {
            return null;
        }
        RefineryRecipe recipe = new RefineryRecipe(input, outputFluid, outputItem, energy, chance);
        recipeMap.put(FluidHelper.getFluidHash((FluidStack)input), (Object)recipe);
        return recipe;
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem) {
        return RefineryManager.addRecipe(energy, input, outputFluid, outputItem, 100);
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid) {
        return RefineryManager.addRecipe(energy, input, outputFluid, ItemStack.field_190927_a, 0);
    }

    public static RefineryRecipe addRecipePotion(int energy, FluidStack input, FluidStack outputFluid) {
        if (input == null || outputFluid == null || energy <= 0 || RefineryManager.recipeExistsPotion(input)) {
            return null;
        }
        RefineryRecipe recipe = new RefineryRecipe(input, outputFluid, ItemStack.field_190927_a, energy, 0);
        recipeMapPotion.put(FluidHelper.getFluidHash((FluidStack)input), (Object)recipe);
        return recipe;
    }

    public static RefineryRecipe removeRecipe(FluidStack input) {
        if (input == null) {
            return null;
        }
        return (RefineryRecipe)recipeMap.remove(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static RefineryRecipe removeRecipePotion(FluidStack input) {
        if (input == null) {
            return null;
        }
        return (RefineryRecipe)recipeMapPotion.remove(FluidHelper.getFluidHash((FluidStack)input));
    }

    private static void addFossilFuel(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        oilFluids.add(fluid.getName());
    }

    public static void addStrongPotionRecipes(String baseName, int maxRank) {
        int baseAmount = 50;
        for (int i = maxRank; i > 2; --i) {
            int outputAmount = baseAmount + baseAmount * (5 - i);
            int inputAmount = outputAmount + baseAmount;
            PotionType inputType = RefineryManager.getPotionType(baseName, i - 1);
            PotionType outputType = RefineryManager.getPotionType(baseName, i);
            if (inputType == PotionTypes.field_185229_a || outputType == PotionTypes.field_185229_a) continue;
            FluidStack inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotion, inputAmount), (PotionType)inputType);
            FluidStack outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotion, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
            inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionSplash, inputAmount), (PotionType)inputType);
            outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionSplash, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
            inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionLingering, inputAmount), (PotionType)inputType);
            outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionLingering, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
        }
    }

    public static PotionType getPotionType(String baseName, int rank) {
        PotionType ret;
        switch (rank) {
            case 1: {
                ret = PotionType.func_185168_a((String)baseName);
                break;
            }
            case 2: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + 2));
                if (ret != PotionTypes.field_185229_a) break;
                ret = PotionType.func_185168_a((String)("strong_" + baseName));
                break;
            }
            default: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + rank));
            }
        }
        return ret;
    }

    public static class RefineryRecipe {
        final FluidStack input;
        final FluidStack outputFluid;
        final ItemStack outputItem;
        final int energy;
        final int chance;

        RefineryRecipe(FluidStack input, FluidStack outputFluid, ItemStack outputItem, int energy, int chance) {
            this.input = input;
            this.outputFluid = outputFluid;
            this.outputItem = outputItem;
            this.energy = energy;
            this.chance = chance;
        }

        public FluidStack getInput() {
            return this.input;
        }

        public FluidStack getOutputFluid() {
            return this.outputFluid;
        }

        public ItemStack getOutputItem() {
            return this.outputItem;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

