/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.asm;

import java.util.Iterator;
import lumien.randomthings.asm.CustomClassWriter;
import lumien.randomthings.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    public static Logger logger = LogManager.getLogger((String)"RandomThingsCore");
    final String asmHandler = "lumien/randomthings/handler/AsmHandler";
    public static int transformations = 0;

    public ClassTransformer() {
        logger.log(Level.DEBUG, "Starting Class Transformation");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.world.World")) {
            ++transformations;
            return this.patchWorldClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.BlockRendererDispatcher")) {
            ++transformations;
            return this.patchBlockRendererDispatcher(basicClass);
        }
        if (transformedName.equals("net.minecraft.block.Block")) {
            ++transformations;
            return this.patchBlock(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            ++transformations;
            return this.patchRenderLivingBase(basicClass);
        }
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            ++transformations;
            return this.patchEntityLivingBase(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.RenderItem")) {
            ++transformations;
            return this.patchRenderItem(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.layers.LayerArmorBase")) {
            ++transformations;
            return this.patchLayerArmorBase(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.gen.structure.StructureOceanMonumentPieces$MonumentCoreRoom")) {
            ++transformations;
            return this.patchOceanMonument(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            ++transformations;
            return this.patchEntityRenderer(basicClass);
        }
        if (transformedName.equals("net.minecraft.entity.player.InventoryPlayer")) {
            ++transformations;
            return this.patchInventoryPlayer(basicClass);
        }
        if (transformedName.equals("net.minecraft.server.management.PlayerInteractionManager")) {
            ++transformations;
            return this.patchPlayerInteractionManager(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.gen.feature.WorldGenAbstractTree")) {
            ++transformations;
            return this.patchWorldGenTrees(basicClass);
        }
        if (transformedName.equals("net.minecraftforge.client.model.pipeline.VertexLighterFlat")) {
            ++transformations;
            return this.patchVertexLighterFlat(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.multiplayer.PlayerControllerMP")) {
            ++transformations;
            return this.patchPlayerController(basicClass);
        }
        if (transformedName.equals("net.minecraft.util.MovementInputFromOptions")) {
            ++transformations;
            return this.patchMovementInput(basicClass);
        }
        if (transformedName.equals("net.minecraft.entity.monster.EntitySlime")) {
            ++transformations;
            return this.patchEntitySlime(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.WorldEntitySpawner")) {
            ++transformations;
            return this.patchWorldEntitySpawner(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.gen.structure.StructureVillagePieces$Church")) {
            ++transformations;
            return this.patchVillageChurch(basicClass);
        }
        return basicClass;
    }

    private byte[] patchVillageChurch(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found VillagePiece Church Class: " + classNode.name);
        MethodNode addComponentParts = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_74875_a"))) continue;
            addComponentParts = mn;
        }
        if (addComponentParts != null) {
            logger.log(Level.DEBUG, " - Found addComponentParts");
            for (int i = 0; i < addComponentParts.instructions.size(); ++i) {
                InsnNode in;
                AbstractInsnNode ain = addComponentParts.instructions.get(i);
                if (!(ain instanceof InsnNode) || (in = (InsnNode)ain).getOpcode() != 172) continue;
                logger.log(Level.DEBUG, " - Patched addComponentParts");
                AbstractInsnNode before = addComponentParts.instructions.get(i - 1);
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/worldgen/WorldGenPeaceCandle", "addComponentParts", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;Lnet/minecraft/world/gen/structure/StructureVillagePieces$Church;)V", false));
                i += 5;
                addComponentParts.instructions.insertBefore(before, toInsert);
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWorldEntitySpawner(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found WorldEntitySpawner Class: " + classNode.name);
        MethodNode findChunksForSpawning = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_77192_a"))) continue;
            findChunksForSpawning = mn;
            break;
        }
        if (findChunksForSpawning != null) {
            logger.log(Level.DEBUG, " - Found findChunksForSpawning");
            for (int i = 0; i < findChunksForSpawning.instructions.size(); ++i) {
                AbstractInsnNode before;
                AbstractInsnNode ain = findChunksForSpawning.instructions.get(i);
                if (!(ain instanceof VarInsnNode)) continue;
                VarInsnNode vin = (VarInsnNode)ain;
                if (vin.var != 14 || vin.getOpcode() != 58 || !((before = findChunksForSpawning.instructions.get(i - 1)) instanceof MethodInsnNode)) continue;
                MethodInsnNode beforeMin = (MethodInsnNode)before;
                if (!beforeMin.name.equals("newArrayList")) continue;
                logger.log(Level.DEBUG, " - Patched findChunksForSpawning");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 11));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 14));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "modifyValidSpawningChunks", "(Lnet/minecraft/entity/EnumCreatureType;Ljava/util/List;)V", false));
                findChunksForSpawning.instructions.insert((AbstractInsnNode)vin, toInsert);
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntitySlime(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found EntitySlime Class: " + classNode.name);
        MethodNode getCanSpawnHere = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_70601_bi"))) continue;
            getCanSpawnHere = mn;
            break;
        }
        if (getCanSpawnHere != null) {
            logger.log(Level.DEBUG, " - Found getCanSpawnHere");
            for (int i = 0; i < getCanSpawnHere.instructions.size(); ++i) {
                AbstractInsnNode ain = getCanSpawnHere.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals("PEACEFUL")) continue;
                logger.log(Level.DEBUG, " - Found Insertion Point");
                AbstractInsnNode skip = getCanSpawnHere.instructions.get(i + 1);
                LabelNode l0 = new LabelNode(new Label());
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/monster/EntitySlime", MCPNames.field("field_70170_p"), "Lnet/minecraft/world/World;"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "overrideSlimeChunk", "(Lnet/minecraft/world/World;Lnet/minecraft/world/chunk/Chunk;)I", false));
                toInsert.add((AbstractInsnNode)new InsnNode(89));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(155, l0));
                toInsert.add((AbstractInsnNode)new InsnNode(172));
                toInsert.add((AbstractInsnNode)l0);
                toInsert.add((AbstractInsnNode)new InsnNode(87));
                getCanSpawnHere.instructions.insert(skip, toInsert);
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchMovementInput(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found MovementInputFromOptions Class: " + classNode.name);
        MethodNode updatePlayerMoveState = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78898_a"))) continue;
            updatePlayerMoveState = mn;
            break;
        }
        if (updatePlayerMoveState != null) {
            logger.log(Level.DEBUG, " - Found updatePlayerMoveState");
            for (int i = 0; i < updatePlayerMoveState.instructions.size(); ++i) {
                AbstractInsnNode ain = updatePlayerMoveState.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals(MCPNames.field("field_78899_d"))) continue;
                logger.log(Level.DEBUG, " - Found insert point");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "modifyInput", "(Lnet/minecraft/util/MovementInputFromOptions;)V", false));
                updatePlayerMoveState.instructions.insert((AbstractInsnNode)fin, toInsert);
                break;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPlayerController(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found PlayerControllerMP Class: " + classNode.name);
        MethodNode getBlockReachDistance = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78757_d"))) continue;
            getBlockReachDistance = mn;
            break;
        }
        if (getBlockReachDistance != null) {
            logger.log(Level.DEBUG, " - Found getBlockReachDistance");
            for (int i = 0; i < getBlockReachDistance.instructions.size(); ++i) {
                AbstractInsnNode ain = getBlockReachDistance.instructions.get(i);
                if (ain.getOpcode() != 174) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/multiplayer/PlayerControllerMP", MCPNames.field("field_78776_a"), "Lnet/minecraft/client/Minecraft;"));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/Minecraft", MCPNames.field("field_71439_g"), "Lnet/minecraft/client/entity/EntityPlayerSP;"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getPlayerRange", "(FLnet/minecraft/entity/player/EntityPlayer;)F", false));
                getBlockReachDistance.instructions.insertBefore(ain, toInsert);
                i += 4;
                break;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchVertexLighterFlat(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found VertexLighterFlat Class: " + classNode.name);
        MethodNode processQuad = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals("processQuad")) continue;
            processQuad = mn;
            break;
        }
        if (processQuad != null) {
            InsnList toInsert;
            LabelNode l1;
            logger.log(Level.DEBUG, " - Found processQuad");
            InsnList resetList = new InsnList();
            resetList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            resetList.add((AbstractInsnNode)new InsnNode(3));
            resetList.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "rtFullBright", "Z"));
            processQuad.instructions.insert(resetList);
            VarInsnNode tintTarget = null;
            int lightMapTarget = 0;
            MethodInsnNode updateColorTarget = null;
            LabelNode firstLabel = null;
            LabelNode lastLabel = null;
            for (int i = 0; i < processQuad.instructions.size(); ++i) {
                AbstractInsnNode ain = processQuad.instructions.get(i);
                if (ain instanceof VarInsnNode) {
                    VarInsnNode vin = (VarInsnNode)ain;
                    if (vin.var != 5 || !(processQuad.instructions.get(i - 1) instanceof MethodInsnNode)) continue;
                    tintTarget = vin;
                    continue;
                }
                if (ain instanceof LabelNode) {
                    LabelNode ln = (LabelNode)ain;
                    if (firstLabel == null) {
                        firstLabel = ln;
                    }
                    lastLabel = ln;
                    continue;
                }
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (min.name.equals(MCPNames.method("func_177369_e"))) {
                    lightMapTarget = i;
                    continue;
                }
                if (!min.name.equals("updateColor")) continue;
                updateColorTarget = min;
            }
            FieldNode fullBrightField = new FieldNode(2, "rtFullBright", "Z", null, (Object)false);
            classNode.fields.add(fullBrightField);
            if (lightMapTarget != 0) {
                logger.log(Level.DEBUG, " - Found patch target (lightmap) (1/4)");
                for (int i = lightMapTarget; i < processQuad.instructions.size(); ++i) {
                    InsnNode in;
                    AbstractInsnNode ain = processQuad.instructions.get(i);
                    if (!(ain instanceof InsnNode) || (in = (InsnNode)ain).getOpcode() != 50) continue;
                    logger.log(Level.DEBUG, " - Found lightmap array (2/4)");
                    LabelNode l0 = new LabelNode(new Label());
                    InsnList toInsert2 = new InsnList();
                    toInsert2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert2.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "rtFullBright", "Z"));
                    toInsert2.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                    toInsert2.add((AbstractInsnNode)new InsnNode(87));
                    toInsert2.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/randomthings/lib/Constants", "FULLBRIGHT_OVERRIDE", "[F"));
                    toInsert2.add((AbstractInsnNode)l0);
                    processQuad.instructions.insert((AbstractInsnNode)in, toInsert2);
                    break;
                }
            }
            if (tintTarget != null) {
                logger.log(Level.DEBUG, " - Found tintTarget (3/4");
                LabelNode l0 = new LabelNode(new Label());
                l1 = new LabelNode(new Label());
                toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "blockInfo", "Lnet/minecraftforge/client/model/pipeline/BlockInfo;"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/model/pipeline/BlockInfo", "getState", "()Lnet/minecraft/block/state/IBlockState;", false));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", MCPNames.method("func_177230_c"), "()Lnet/minecraft/block/Block;", true));
                toInsert.add((AbstractInsnNode)new TypeInsnNode(193, "lumien/randomthings/lib/ILuminousBlock"));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "blockInfo", "Lnet/minecraftforge/client/model/pipeline/BlockInfo;"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/model/pipeline/BlockInfo", "getState", "()Lnet/minecraft/block/state/IBlockState;", false));
                toInsert.add((AbstractInsnNode)new InsnNode(89));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", MCPNames.method("func_177230_c"), "()Lnet/minecraft/block/Block;", true));
                toInsert.add((AbstractInsnNode)new InsnNode(95));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "tint", "I"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(185, "lumien/randomthings/lib/ILuminousBlock", "shouldGlow", "(Lnet/minecraft/block/state/IBlockState;I)Z", true));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new InsnNode(3));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "diffuse", "Z"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new InsnNode(4));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "rtFullBright", "Z"));
                toInsert.add((AbstractInsnNode)l0);
                processQuad.instructions.insertBefore((AbstractInsnNode)tintTarget, toInsert);
            }
            if (updateColorTarget != null) {
                logger.log(Level.DEBUG, " - Found updateColor target (tint) (4/4)");
                LabelNode l0 = new LabelNode(new Label());
                l1 = new LabelNode(new Label());
                toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/pipeline/VertexLighterFlat", "rtFullBright", "Z"));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "updateColor", "([F[FFFFFI)V", false));
                toInsert.add((AbstractInsnNode)new InsnNode(87));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(167, l0));
                toInsert.add((AbstractInsnNode)l1);
                processQuad.instructions.insertBefore((AbstractInsnNode)updateColorTarget, toInsert);
                processQuad.instructions.insert((AbstractInsnNode)updateColorTarget, (AbstractInsnNode)l0);
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        try {
            byte[] result = writer.toByteArray();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }

    private byte[] patchWorldGenTrees(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found WorldGenAbstractTree Class: " + classNode.name);
        MethodNode setDirtAt = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_175921_a"))) continue;
            setDirtAt = mn;
            break;
        }
        if (setDirtAt != null) {
            logger.log(Level.DEBUG, " - Patching setDirtAt");
            for (int i = 0; i < setDirtAt.instructions.size(); ++i) {
                JumpInsnNode jin;
                AbstractInsnNode ain = setDirtAt.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jin = (JumpInsnNode)ain).getOpcode() != 165) continue;
                LabelNode l = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", MCPNames.method("func_180495_p"), "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", MCPNames.method("func_177230_c"), "()Lnet/minecraft/block/Block;", true));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "protectGround", "(Lnet/minecraft/block/Block;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(157, new LabelNode(l.getLabel())));
                setDirtAt.instructions.insert((AbstractInsnNode)jin, toInsert);
                logger.log(Level.DEBUG, " - Patched setDirtAt");
                break;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPlayerInteractionManager(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found PlayerInteractionManager Class: " + classNode.name);
        MethodNode tryHarvestBlock = null;
        MethodNode getBlockReachDistance = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_180237_b"))) {
                tryHarvestBlock = mn;
                continue;
            }
            if (!mn.name.equals("getBlockReachDistance")) continue;
            getBlockReachDistance = mn;
        }
        if (tryHarvestBlock != null) {
            logger.log(Level.DEBUG, " - Found tryHarvestBlock");
            InsnList startInsert = new InsnList();
            startInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            startInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "preHarvest", "(Lnet/minecraft/server/management/PlayerInteractionManager;)V", false));
            tryHarvestBlock.instructions.insert(startInsert);
            for (int i = 0; i < tryHarvestBlock.instructions.size(); ++i) {
                AbstractInsnNode ain = tryHarvestBlock.instructions.get(i);
                if (ain.getOpcode() != 172) continue;
                InsnList endInsert = new InsnList();
                endInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "postHarvest", "()V", false));
                tryHarvestBlock.instructions.insertBefore(ain, endInsert);
                ++i;
            }
        }
        if (getBlockReachDistance != null) {
            logger.log(Level.DEBUG, " - Found getBlockReachDistance");
            for (int i = 0; i < getBlockReachDistance.instructions.size(); ++i) {
                AbstractInsnNode ain = getBlockReachDistance.instructions.get(i);
                if (ain.getOpcode() != 175) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/server/management/PlayerInteractionManager", MCPNames.field("field_73090_b"), "Lnet/minecraft/entity/player/EntityPlayerMP;"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getPlayerRange", "(DLnet/minecraft/entity/player/EntityPlayer;)D", false));
                getBlockReachDistance.instructions.insertBefore(ain, toInsert);
                i += 3;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchInventoryPlayer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found InventoryPlayer Class: " + classNode.name);
        MethodNode dropAllItems = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_70436_m"))) continue;
            dropAllItems = mn;
            break;
        }
        if (dropAllItems != null) {
            logger.log(Level.DEBUG, " - Found dropAllItems (1/2)");
            for (int i = 0; i < dropAllItems.instructions.size(); ++i) {
                AbstractInsnNode before;
                JumpInsnNode jin;
                AbstractInsnNode ain = dropAllItems.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jin = (JumpInsnNode)ain).getOpcode() != 154 || !((before = dropAllItems.instructions.get(i - 1)) instanceof MethodInsnNode) || !((MethodInsnNode)before).name.equals(MCPNames.method("func_190926_b"))) continue;
                LabelNode l0 = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 3));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldPlayerDrop", "(Lnet/minecraft/entity/player/InventoryPlayer;ILnet/minecraft/item/ItemStack;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                dropAllItems.instructions.insert((AbstractInsnNode)jin, toInsert);
                i += 5;
                logger.log(Level.DEBUG, " - Patched dropAllItems (2/2)");
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLiquidBlock(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found BlockLiquid Class: " + classNode.name);
        MethodNode shouldSideBeRendered = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_176225_a"))) continue;
            shouldSideBeRendered = mn;
            break;
        }
        if (shouldSideBeRendered != null) {
            logger.log(Level.DEBUG, " - Found shouldSideBeRendered (1/1)");
            LabelNode l1 = new LabelNode(new Label());
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldLiquidSideBeRendered", "(Lnet/minecraft/block/BlockLiquid;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(155, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            shouldSideBeRendered.instructions.insert(toInsert);
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLayerArmorBase(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found LayerArmorBase Class: " + classNode.name);
        MethodNode renderEnchantedGlint = null;
        MethodNode renderArmorLayer = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_188364_a"))) {
                renderEnchantedGlint = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_188361_a"))) continue;
            renderArmorLayer = mn;
        }
        if (renderEnchantedGlint != null) {
            logger.log(Level.DEBUG, "- Found renderEnchantedGlint (Effect Rendering 1/2)");
            renderEnchantedGlint.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "preEnchantment", "()V", false));
            for (int i = 0; i < renderEnchantedGlint.instructions.size(); ++i) {
                AbstractInsnNode ain = renderEnchantedGlint.instructions.get(i);
                if (ain instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    if (!min.owner.equals("net/minecraft/client/renderer/GlStateManager") || !min.name.equals(MCPNames.method("func_179131_c"))) continue;
                    renderEnchantedGlint.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "armorEnchantmentHook", "()V", false));
                    continue;
                }
                if (ain.getOpcode() != 177) continue;
                renderEnchantedGlint.instructions.insertBefore(ain, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "postEnchantment", "()V", false));
                ++i;
            }
        }
        int renderCounter = 0;
        if (renderArmorLayer != null) {
            logger.log(Level.DEBUG, "- Found renderArmorLayer (ItemStack Information & Armor Coloring 2/2)");
            for (int i = 0; i < renderArmorLayer.instructions.size(); ++i) {
                InsnList toInsert;
                AbstractInsnNode ain = renderArmorLayer.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (min.name.equals(MCPNames.method("func_188364_a"))) {
                    logger.log(Level.DEBUG, "- Set currentlyRendering");
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 10));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderArmorLayer.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new InsnNode(1));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderArmorLayer.instructions.insert((AbstractInsnNode)min, toInsert);
                    i += 2;
                }
                if (!min.name.equals(MCPNames.method("func_78088_a"))) continue;
                if (renderCounter == 1) {
                    logger.log(Level.DEBUG, "- Found render");
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 10));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "armorColorHook", "(Lnet/minecraft/item/ItemStack;)V", false));
                    renderArmorLayer.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                }
                ++renderCounter;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRenderItem(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found RenderItem Class: " + classNode.name);
        MethodNode renderEffect = null;
        MethodNode renderItem = null;
        MethodNode renderQuads = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_191966_a"))) {
                renderEffect = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_180454_a")) && mn.desc.equals("(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V")) {
                renderItem = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_191970_a"))) continue;
            renderQuads = mn;
        }
        if (renderEffect != null) {
            logger.log(Level.DEBUG, "- Found renderEffect (1/3)");
            renderEffect.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "preEnchantment", "()V", false));
            for (int i = 0; i < renderEffect.instructions.size(); ++i) {
                AbstractInsnNode ain = renderEffect.instructions.get(i);
                if (ain instanceof LdcInsnNode) {
                    LdcInsnNode lin = (LdcInsnNode)ain;
                    if (!lin.cst.equals(new Integer(-8372020))) continue;
                    logger.log(Level.DEBUG, "- Found Texture Binding");
                    renderEffect.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "enchantmentColorHook", "()I", false));
                    renderEffect.instructions.remove((AbstractInsnNode)lin);
                    continue;
                }
                if (ain.getOpcode() != 177) continue;
                renderEffect.instructions.insertBefore(ain, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "postEnchantment", "()V", false));
                ++i;
            }
        }
        if (renderItem != null) {
            boolean found = false;
            logger.log(Level.DEBUG, "- Found renderItem (2/3) (" + renderItem.desc + ")");
            for (int i = 0; i < renderItem.instructions.size(); ++i) {
                AbstractInsnNode ain = renderItem.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!found && min.name.equals(MCPNames.method("func_191966_a"))) {
                    logger.log(Level.DEBUG, "- Found renderEffect calling");
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderItem.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new InsnNode(1));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderItem.instructions.insert((AbstractInsnNode)min, toInsert);
                    found = true;
                }
                if (!min.name.equals(MCPNames.method("func_179022_a"))) continue;
                LabelNode l1 = new LabelNode(new Label());
                LabelNode l2 = new LabelNode(new Label());
                logger.log(Level.DEBUG, "- Inserting TE Item Renderer");
                InsnList insertBefore = new InsnList();
                insertBefore.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/randomthings/client/RandomThingsTEItemRenderer", "instance", "Llumien/randomthings/client/RandomThingsTEItemRenderer;"));
                insertBefore.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertBefore.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/randomthings/client/RandomThingsTEItemRenderer", "renderByItem", "(Lnet/minecraft/item/ItemStack;)Z", false));
                insertBefore.add((AbstractInsnNode)new JumpInsnNode(153, l2));
                insertBefore.add((AbstractInsnNode)new InsnNode(87));
                insertBefore.add((AbstractInsnNode)new InsnNode(87));
                insertBefore.add((AbstractInsnNode)new JumpInsnNode(167, l1));
                insertBefore.add((AbstractInsnNode)l2);
                InsnList insertAfter = new InsnList();
                insertAfter.add((AbstractInsnNode)l1);
                renderItem.instructions.insertBefore((AbstractInsnNode)min, insertBefore);
                renderItem.instructions.insert((AbstractInsnNode)min, insertAfter);
                i += 8;
            }
        }
        if (renderQuads != null) {
            logger.log(Level.DEBUG, "- Found renderQuads (3/3) (" + renderQuads.desc + ")");
            String luminousHandler = "lumien/randomthings/handler/LuminousHandler";
            InsnList startInsrt = new InsnList();
            startInsrt.add((AbstractInsnNode)new VarInsnNode(25, 4));
            startInsrt.add((AbstractInsnNode)new VarInsnNode(25, 1));
            startInsrt.add((AbstractInsnNode)new MethodInsnNode(184, luminousHandler, "luminousHookStart", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/BufferBuilder;)V", false));
            renderQuads.instructions.insert(startInsrt);
            for (int i = 0; i < renderQuads.instructions.size(); ++i) {
                AbstractInsnNode ain = renderQuads.instructions.get(i);
                if (ain instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    if (!min.name.equals("renderQuadColor")) continue;
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 8));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/renderer/block/model/BakedQuad", MCPNames.method("func_178211_c"), "()I", false));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, luminousHandler, "luminousHookPre", "(I)V", false));
                    toInsert.add((AbstractInsnNode)new InsnNode(87));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(21, 9));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getColorFromItemStack", "(Lnet/minecraft/item/ItemStack;I)I", false));
                    renderQuads.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                    i += 7;
                    renderQuads.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, luminousHandler, "luminousHookPost", "()V", false));
                    continue;
                }
                if (ain.getOpcode() != 177) continue;
                renderQuads.instructions.insertBefore(ain, (AbstractInsnNode)new MethodInsnNode(184, luminousHandler, "luminousHookEnd", "()V", false));
                ++i;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityLivingBase(byte[] basicClass) {
        InsnList toInsert;
        AbstractInsnNode ain;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found EntityLivingBase Class: " + classNode.name);
        MethodNode updatePotionEffects = null;
        MethodNode travel = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_70679_bo"))) {
                updatePotionEffects = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_191986_a"))) continue;
            travel = mn;
        }
        if (updatePotionEffects != null) {
            logger.log(Level.DEBUG, "- Found updatePotionEffects (1/2)");
            for (int i = 0; i < updatePotionEffects.instructions.size(); ++i) {
                ain = updatePotionEffects.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals(MCPNames.field("field_70180_af"))) continue;
                AbstractInsnNode aload = updatePotionEffects.instructions.get(i - 1);
                toInsert = new InsnList();
                LabelNode l1 = new LabelNode(new Label());
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRenderPotionParticles", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(157, l1));
                toInsert.add((AbstractInsnNode)new InsnNode(177));
                toInsert.add((AbstractInsnNode)l1);
                updatePotionEffects.instructions.insertBefore(aload, toInsert);
                break;
            }
        }
        if (travel != null) {
            logger.log(Level.DEBUG, "- Found travel (2/2)");
            for (int i = 0; i < travel.instructions.size(); ++i) {
                AbstractInsnNode next;
                ain = travel.instructions.get(i);
                if (!(ain instanceof LdcInsnNode)) continue;
                LdcInsnNode lin = (LdcInsnNode)ain;
                if (!lin.cst.equals(new Float("0.91")) || (next = travel.instructions.get(i + 1)).getOpcode() != 106) continue;
                toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/EntityLivingBase", MCPNames.field("field_70170_p"), "Lnet/minecraft/world/World;"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 5));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", MCPNames.method("func_180495_p"), "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", MCPNames.method("func_177230_c"), "()Lnet/minecraft/block/Block;", true));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "slipFix", "(FLnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/block/Block;)F", false));
                travel.instructions.insert(next, toInsert);
                i += 6;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRenderLivingBase(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found RenderLivingBase Class: " + classNode.name);
        MethodNode canRenderName = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_177070_b"))) continue;
            canRenderName = mn;
            break;
        }
        if (canRenderName != null) {
            logger.log(Level.DEBUG, "- Found canRenderName (1/1)");
            LabelNode l1 = new LabelNode(new Label());
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "canRenderName", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(157, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(3));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            canRenderName.instructions.insert(toInsert);
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBlock(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found Block Class: " + classNode.name);
        MethodNode addCollisionBoxesToList = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_185477_a")) || !mn.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;Z)V")) continue;
            addCollisionBoxesToList = mn;
        }
        if (addCollisionBoxesToList != null) {
            logger.log(Level.DEBUG, "- Found addCollisionBoxesToList (1/1)");
            InsnList toInsert = new InsnList();
            LabelNode l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 5));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 6));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "addCollisionBoxesToList", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)Z", false));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(177));
            toInsert.add((AbstractInsnNode)l1);
            addCollisionBoxesToList.instructions.insert(toInsert);
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBlockRendererDispatcher(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found BlockRendererDispatcher Class: " + classNode.name);
        MethodNode renderBlock = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_175018_a"))) continue;
            renderBlock = mn;
        }
        if (renderBlock != null) {
            logger.log(Level.DEBUG, "- Found renderBlock (1/1)");
            InsnList toInsert = new InsnList();
            LabelNode l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "renderBlock", "(Lnet/minecraft/client/renderer/BlockRendererDispatcher;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/BufferBuilder;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new InsnNode(5));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(159, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            renderBlock.instructions.insert(toInsert);
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWorldClass(byte[] basicClass) {
        LabelNode l1;
        InsnList toInsert;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found World Class: " + classNode.name);
        MethodNode getRedstonePower = null;
        MethodNode getStrongPower = null;
        MethodNode isRainingAt = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_175651_c"))) {
                getRedstonePower = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_175627_a")) && mn.desc.equals("(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I")) {
                getStrongPower = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_175727_C"))) continue;
            isRainingAt = mn;
        }
        if (getRedstonePower != null) {
            logger.log(Level.DEBUG, "- Found getRedstonePower (1/3)");
            toInsert = new InsnList();
            l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getRedstonePower", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            getRedstonePower.instructions.insert(toInsert);
        }
        if (getStrongPower != null) {
            logger.log(Level.DEBUG, "- Found getStrongPower (2/3)");
            toInsert = new InsnList();
            l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getStrongPower", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            getStrongPower.instructions.insert(toInsert);
        }
        if (isRainingAt != null) {
            logger.log(Level.DEBUG, "- Found isRainingAt (3/3)");
            AbstractInsnNode returnNode = null;
            for (int i = 0; i < isRainingAt.instructions.size(); ++i) {
                AbstractInsnNode ain = isRainingAt.instructions.get(i);
                if (ain.getOpcode() != 172) continue;
                returnNode = ain;
            }
            InsnList toInsert2 = new InsnList();
            LabelNode returnLabel = new LabelNode(new Label());
            toInsert2.add((AbstractInsnNode)new InsnNode(89));
            toInsert2.add((AbstractInsnNode)new JumpInsnNode(153, returnLabel));
            toInsert2.add((AbstractInsnNode)new InsnNode(87));
            toInsert2.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert2.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert2.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            toInsert2.add((AbstractInsnNode)returnLabel);
            isRainingAt.instructions.insertBefore(returnNode, toInsert2);
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRenderer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found EntityRenderer Class: " + classNode.name);
        MethodNode renderRainSnow = null;
        MethodNode addRainParticles = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_78474_d"))) {
                renderRainSnow = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_78484_h"))) continue;
            addRainParticles = mn;
        }
        if (renderRainSnow != null) {
            logger.log(Level.DEBUG, "- Found renderRainSnow");
            VarInsnNode insnPoint = null;
            for (int i = 0; i < renderRainSnow.instructions.size(); ++i) {
                AbstractInsnNode jumpNode;
                AbstractInsnNode ain = renderRainSnow.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (min.name.equals(MCPNames.method("func_76738_d"))) {
                    logger.log(Level.DEBUG, "- Found canRain");
                    insnPoint = (VarInsnNode)renderRainSnow.instructions.get(i - 1);
                }
                if (!min.name.equals(MCPNames.method("func_76746_c"))) continue;
                logger.log(Level.DEBUG, "- Found getEnableSnow");
                int jumpCounter = i + 1;
                int worldIndex = 5;
                int blockPosIndex = 21;
                for (LocalVariableNode lv : renderRainSnow.localVariables) {
                    if (lv.desc.equals("Lnet/minecraft/client/multiplayer/WorldClient;") || lv.desc.equals("Lnet/minecraft/world/World;")) {
                        worldIndex = lv.index;
                        continue;
                    }
                    if (!lv.desc.equals("Lnet/minecraft/util/math/BlockPos$MutableBlockPos;")) continue;
                    blockPosIndex = lv.index;
                }
                while (!((jumpNode = renderRainSnow.instructions.get(jumpCounter)) instanceof JumpInsnNode)) {
                    ++jumpCounter;
                }
                JumpInsnNode jin = (JumpInsnNode)jumpNode;
                LabelNode labelNode = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, worldIndex));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, blockPosIndex));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
                renderRainSnow.instructions.insertBefore((AbstractInsnNode)insnPoint, toInsert);
                i += 4;
            }
        }
        if (addRainParticles != null) {
            logger.log(Level.DEBUG, "- Found addRainParticles");
            for (int i = 0; i < addRainParticles.instructions.size(); ++i) {
                JumpInsnNode jin;
                AbstractInsnNode ain = addRainParticles.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jin = (JumpInsnNode)ain).getOpcode() != 163) continue;
                LabelNode jumpTarget = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 15));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, jumpTarget));
                addRainParticles.instructions.insert((AbstractInsnNode)jin, toInsert);
                break;
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchOceanMonument(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found MonumentCoreRoom Class: " + classNode.name);
        MethodNode addComponentParts = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_74875_a"))) continue;
            addComponentParts = mn;
        }
        if (addComponentParts != null) {
            logger.log(Level.DEBUG, " - Found addComponentParts");
            for (int i = 0; i < addComponentParts.instructions.size(); ++i) {
                InsnNode in;
                AbstractInsnNode ain = addComponentParts.instructions.get(i);
                if (!(ain instanceof InsnNode) || (in = (InsnNode)ain).getOpcode() != 172) continue;
                logger.log(Level.DEBUG, " - Patched addComponentParts");
                AbstractInsnNode before = addComponentParts.instructions.get(i - 1);
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/worldgen/WorldGenOceanChest", "addComponentParts", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;Lnet/minecraft/world/gen/structure/StructureOceanMonumentPieces$MonumentCoreRoom;)V", false));
                i += 5;
                addComponentParts.instructions.insertBefore(before, toInsert);
            }
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public int getNextIndex(MethodNode mn) {
        Iterator it = mn.localVariables.iterator();
        int max = 0;
        int next = 0;
        while (it.hasNext()) {
            LocalVariableNode var = (LocalVariableNode)it.next();
            int index = var.index;
            if (index < max) continue;
            max = index;
            next = max + Type.getType((String)var.desc).getSize();
        }
        return next;
    }
}

