/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lumien.randomthings.asm.MCPNames;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.enchantment.ModEnchantments;
import lumien.randomthings.handler.ItemCatcher;
import lumien.randomthings.handler.redstonesignal.RedstoneSignalHandler;
import lumien.randomthings.item.ItemRedstoneTool;
import lumien.randomthings.item.ItemSpectreKey;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.item.spectretools.ItemSpectreSword;
import lumien.randomthings.lib.ISuperLubricent;
import lumien.randomthings.potion.ModPotions;
import lumien.randomthings.tileentity.TileEntityLightRedirector;
import lumien.randomthings.tileentity.TileEntityPeaceCandle;
import lumien.randomthings.tileentity.TileEntityRainShield;
import lumien.randomthings.tileentity.TileEntitySlimeCube;
import lumien.randomthings.tileentity.redstoneinterface.TileEntityRedstoneInterface;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class AsmHandler {
    static Random rng = new Random();
    static Field fluidRenderer;
    static PlayerInteractionManager interactionManager;
    static HashSet<BlockPos> posSet;
    static float enchantmentLightMapX;
    static float enchantmentLightMapY;
    public static ItemStack currentlyRendering;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyValidSpawningChunks(EnumCreatureType creatureType, List<ChunkPos> positions) {
        if (creatureType == EnumCreatureType.MONSTER) {
            HashSet<ChunkPos> toRemove = new HashSet<ChunkPos>();
            Set<TileEntityPeaceCandle> set = TileEntityPeaceCandle.candles;
            synchronized (set) {
                for (TileEntityPeaceCandle pc : TileEntityPeaceCandle.candles) {
                    if (pc.func_145837_r()) continue;
                    int cX = pc.func_174877_v().func_177958_n() >> 4;
                    int cZ = pc.func_174877_v().func_177952_p() >> 4;
                    for (int mX = -3; mX < 4; ++mX) {
                        for (int mZ = -3; mZ < 4; ++mZ) {
                            toRemove.add(new ChunkPos(cX + mX, cZ + mZ));
                        }
                    }
                }
            }
            if (!toRemove.isEmpty()) {
                Iterator<ChunkPos> iterator = positions.iterator();
                while (iterator.hasNext()) {
                    ChunkPos pos = iterator.next();
                    if (!toRemove.remove(pos)) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int overrideSlimeChunk(World worldObj, Chunk chunk) {
        Set<TileEntitySlimeCube> set = TileEntitySlimeCube.cubes;
        synchronized (set) {
            for (TileEntitySlimeCube core : TileEntitySlimeCube.cubes) {
                if (core.func_145837_r() || core.func_145831_w() != worldObj) continue;
                BlockPos pos = core.func_174877_v();
                int chunkX = pos.func_177958_n() >> 4;
                int chunkZ = pos.func_177952_p() >> 4;
                if (chunk.field_76635_g != chunkX || chunk.field_76647_h != chunkZ) continue;
                return core.isRedstonePowered() ? 0 : 1;
            }
        }
        return -1;
    }

    public static double getPlayerRange(double original, EntityPlayer player) {
        return AsmHandler.getPlayerRange((float)original, player);
    }

    public static float getPlayerRange(float original, EntityPlayer player) {
        if (player != null) {
            ItemStack holdingMain = player.func_184614_ca();
            ItemStack holdingOff = player.func_184592_cb();
            if (holdingMain.func_77973_b() == ModItems.spectrePickaxe || holdingMain.func_77973_b() == ModItems.spectreAxe || holdingMain.func_77973_b() == ModItems.spectreShovel) {
                return original + 3.0f;
            }
        }
        return original;
    }

    public static void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
    }

    public static boolean protectGround(Block b) {
        return b == ModBlocks.fertilizedDirt || b == ModBlocks.fertilizedDirtTilled;
    }

    public static void preHarvest(PlayerInteractionManager manager) {
        ItemStack tool = manager.field_73090_b.func_184614_ca();
        if (tool != null && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.magnetic, (ItemStack)tool) > 0) {
            ItemCatcher.startCatching();
            interactionManager = manager;
        }
    }

    public static void postHarvest() {
        if (ItemCatcher.isCatching() && interactionManager != null) {
            for (ItemStack is : ItemCatcher.stopCatching()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)AsmHandler.interactionManager.field_73090_b, (ItemStack)is.func_77946_l());
            }
            interactionManager = null;
        }
    }

    public static boolean shouldPlayerDrop(InventoryPlayer inventory, int slot, ItemStack item) {
        return !item.func_77942_o() || !item.func_77978_p().func_74764_b("spectreAnchor");
    }

    @SideOnly(value=Side.CLIENT)
    private static void getFields() {
        try {
            fluidRenderer = BlockRendererDispatcher.class.getDeclaredField(MCPNames.field("field_175025_e"));
            fluidRenderer.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColorFromItemStack(ItemStack is, int originalColor) {
        NBTTagCompound compound;
        if (!is.func_190926_b() && (compound = is.func_77978_p()) != null && compound.func_74764_b("rtDye")) {
            return compound.func_74762_e("rtDye") | 0xFF000000;
        }
        return originalColor;
    }

    public static boolean shouldRain(World worldObj, BlockPos pos) {
        return TileEntityRainShield.shouldRain(worldObj, pos.func_177982_a(0, -pos.func_177956_o(), 0));
    }

    public static boolean shouldRenderPotionParticles(EntityLivingBase entity) {
        ItemStack helmet;
        return entity == null || !(entity instanceof EntityPlayer) || (helmet = ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.HEAD)) == null || helmet.func_77973_b() != ModItems.magicHood;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean canRenderName(EntityLivingBase e) {
        ItemStack helmet;
        return e == null || !(e instanceof EntityPlayer) || (helmet = ((EntityPlayer)e).func_184582_a(EntityEquipmentSlot.HEAD)) == null || helmet.func_77973_b() != ModItems.magicHood;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static int renderBlock(BlockRendererDispatcher dispatcher, IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        Set<TileEntityLightRedirector> set = TileEntityLightRedirector.redirectorSet;
        synchronized (set) {
            if (!TileEntityLightRedirector.redirectorSet.isEmpty()) {
                blockAccess = Minecraft.func_71410_x().field_71441_e;
                BlockPos changedPos = AsmHandler.getSwitchedPosition(blockAccess, pos);
                posSet.clear();
                if (!changedPos.equals((Object)pos)) {
                    block15: {
                        state = blockAccess.func_180495_p(changedPos);
                        try {
                            EnumBlockRenderType enumblockrendertype = state.func_185901_i();
                            if (enumblockrendertype == EnumBlockRenderType.INVISIBLE) break block15;
                            if (blockAccess.func_175624_G() != WorldType.field_180272_g) {
                                try {
                                    state = state.func_185899_b(blockAccess, changedPos);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            switch (enumblockrendertype) {
                                case MODEL: {
                                    IBakedModel model = dispatcher.func_184389_a(state);
                                    state = state.func_177230_c().getExtendedState(state, blockAccess, changedPos);
                                    return dispatcher.func_175019_b().func_178267_a(blockAccess, model, state, pos, worldRendererIn, true) ? 1 : 0;
                                }
                                case ENTITYBLOCK_ANIMATED: {
                                    return 0;
                                }
                                case LIQUID: {
                                    return 2;
                                }
                            }
                            return 0;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
                            CrashReportCategory.func_180523_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.func_177230_c(), (int)state.func_177230_c().func_176201_c(state));
                            throw new ReportedException(crashreport);
                        }
                    }
                    return 0;
                }
            }
            return 2;
        }
    }

    public static BlockPos getSwitchedPosition(IBlockAccess access, BlockPos pos) {
        if (pos != null && access != null) {
            Iterator<TileEntityLightRedirector> iterator = TileEntityLightRedirector.redirectorSet.iterator();
            while (iterator.hasNext()) {
                BlockPos switched;
                TileEntityLightRedirector redirector = iterator.next();
                if (redirector.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                if (!redirector.established || posSet.contains(redirector.func_174877_v())) continue;
                posSet.add(redirector.func_174877_v());
                if (redirector.targets.isEmpty()) {
                    for (EnumFacing facing : EnumFacing.values()) {
                        redirector.targets.put(redirector.func_174877_v().func_177972_a(facing), redirector.func_174877_v().func_177972_a(facing.func_176734_d()));
                    }
                }
                if (!redirector.targets.containsKey(pos) || access.func_175623_d(switched = redirector.targets.get(pos))) continue;
                return AsmHandler.getSwitchedPosition(access, switched);
            }
        }
        return pos;
    }

    public static int getRedstonePower(World worldObj, BlockPos pos, EnumFacing facing) {
        return Math.max(TileEntityRedstoneInterface.getRedstonePower(worldObj, pos, facing), worldObj.field_72995_K ? 0 : RedstoneSignalHandler.getHandler().getStrongPower(worldObj, pos, facing));
    }

    public static int getStrongPower(World worldObj, BlockPos pos, EnumFacing facing) {
        return Math.max(TileEntityRedstoneInterface.getStrongPower(worldObj, pos, facing), worldObj.field_72995_K ? 0 : RedstoneSignalHandler.getHandler().getStrongPower(worldObj, pos, facing));
    }

    public static boolean addCollisionBoxesToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List list, Entity collidingEntity) {
        if (collidingEntity != null && collidingEntity instanceof EntityPlayer) {
            ItemStack boots;
            EntityPlayer player = (EntityPlayer)collidingEntity;
            if (state.func_177230_c() instanceof BlockLiquid && collidingEntity.field_70163_u > (double)pos.func_177956_o() + 0.9 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o(worldIn.func_180495_p(pos.func_177984_a())) != Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o(worldIn.func_180495_p(pos.func_177984_a())) != Material.field_151586_h && !player.func_70093_af() && (boots = (ItemStack)player.field_71071_by.field_70460_b.get(0)) != null && ((boots.func_77973_b() == ModItems.waterWalkingBoots || boots.func_77973_b() == ModItems.obsidianWaterWalkingBoots || boots.func_77973_b() == ModItems.lavaWader) && state.func_177230_c().func_149688_o(state) == Material.field_151586_h || boots.func_77973_b() == ModItems.lavaWader && state.func_177230_c().func_149688_o(state) == Material.field_151587_i)) {
                AxisAlignedBB bb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0);
                if (mask.func_72326_a(bb)) {
                    list.add(bb);
                }
                return true;
            }
        }
        return false;
    }

    public static void preEnchantment() {
        if (currentlyRendering != null && currentlyRendering.func_77942_o() && currentlyRendering.func_77978_p().func_74764_b("luminousEnchantment")) {
            enchantmentLightMapX = OpenGlHelper.lastBrightnessX;
            enchantmentLightMapY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
    }

    public static void postEnchantment() {
        if (currentlyRendering != null && currentlyRendering.func_77942_o() && currentlyRendering.func_77978_p().func_74764_b("luminousEnchantment")) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)enchantmentLightMapX, (float)enchantmentLightMapY);
        }
    }

    public static int enchantmentColorHook() {
        if (currentlyRendering != null) {
            if (currentlyRendering.func_77973_b() instanceof ItemRedstoneTool) {
                return Color.RED.darker().getRGB() | 0xFF000000;
            }
            if (currentlyRendering.func_77973_b() instanceof ItemSpectreKey) {
                return Color.CYAN.darker().getRGB() | 0xFF000000;
            }
            NBTTagCompound compound = currentlyRendering.func_77978_p();
            if (compound != null && compound.func_74764_b("enchantmentColor")) {
                return compound.func_74762_e("enchantmentColor") | 0xFF000000;
            }
            if (currentlyRendering.func_77973_b() instanceof ItemSpectreSword) {
                return Color.WHITE.darker().darker().getRGB() | 0xFF000000;
            }
        }
        return -8372020;
    }

    public static void armorColorHook(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("rtDye")) {
            Color c = new Color(compound.func_74762_e("rtDye"));
            GlStateManager.func_179124_c((float)(0.003921569f * (float)c.getRed()), (float)(0.003921569f * (float)c.getGreen()), (float)(0.003921569f * (float)c.getBlue()));
        }
    }

    public static void armorEnchantmentHook() {
        int color = AsmHandler.enchantmentColorHook();
        if (color != -8372020) {
            Color c = new Color(color);
            c = c.darker();
            GlStateManager.func_179124_c((float)(0.003921569f * (float)c.getRed()), (float)(0.003921569f * (float)c.getGreen()), (float)(0.003921569f * (float)c.getBlue()));
        }
    }

    public static float slipFix(float original, EntityLivingBase entity, Block b) {
        boolean wearsBoots = false;
        if (!entity.func_70093_af()) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (stack.func_190926_b() || stack.func_77973_b() != ModItems.superLubricentBoots) continue;
                wearsBoots = true;
                break;
            }
        }
        if (b instanceof ISuperLubricent || wearsBoots) {
            return 1.0f;
        }
        return original;
    }

    public static void modifyInput(MovementInputFromOptions input) {
        PotionEffect effect;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (effect = player.func_70660_b((Potion)ModPotions.collapse)) != null && effect.func_76458_c() == 0) {
            boolean left = input.field_187257_e;
            boolean right = input.field_187258_f;
            boolean forward = input.field_187255_c;
            boolean backwards = input.field_187256_d;
            if (left) {
                input.field_78902_a -= 2.0f;
                input.field_187257_e = false;
                input.field_187258_f = true;
            }
            if (right) {
                input.field_78902_a += 2.0f;
                input.field_187258_f = false;
                input.field_187257_e = true;
            }
            if (forward) {
                input.field_192832_b -= 2.0f;
                input.field_187255_c = false;
                input.field_187256_d = true;
            }
            if (backwards) {
                input.field_192832_b += 2.0f;
                input.field_187256_d = false;
                input.field_187255_c = true;
            }
        }
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            AsmHandler.getFields();
        }
        posSet = new HashSet();
        currentlyRendering = null;
    }
}

