/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContactButton;
import lumien.randomthings.block.BlockContactLever;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.client.models.blocks.ModelCustomWorkbench;
import lumien.randomthings.client.models.blocks.ModelFluidDisplay;
import lumien.randomthings.client.models.blocks.ModelInventoryRerouter;
import lumien.randomthings.client.models.blocks.ModelRune;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.config.Worldgen;
import lumien.randomthings.entitys.EntitySoul;
import lumien.randomthings.entitys.EntitySpirit;
import lumien.randomthings.handler.ItemCatcher;
import lumien.randomthings.handler.ModDimensions;
import lumien.randomthings.handler.RTWorldInformation;
import lumien.randomthings.handler.floo.FlooNetworkHandler;
import lumien.randomthings.handler.magicavoxel.ClientModelLibrary;
import lumien.randomthings.handler.magicavoxel.ServerModelLibrary;
import lumien.randomthings.handler.redstonesignal.RedstoneSignalHandler;
import lumien.randomthings.handler.spectre.SpectreHandler;
import lumien.randomthings.item.ItemIngredient;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.AtlasSprite;
import lumien.randomthings.lib.Colors;
import lumien.randomthings.lib.IEntityFilterItem;
import lumien.randomthings.lib.IExplosionImmune;
import lumien.randomthings.potion.ModPotions;
import lumien.randomthings.recipes.anvil.AnvilRecipe;
import lumien.randomthings.recipes.anvil.AnvilRecipeHandler;
import lumien.randomthings.tileentity.TileEntityChatDetector;
import lumien.randomthings.tileentity.TileEntityFlooBrick;
import lumien.randomthings.tileentity.TileEntityRainShield;
import lumien.randomthings.tileentity.TileEntityRedstoneObserver;
import lumien.randomthings.tileentity.TileEntityRuneBase;
import lumien.randomthings.util.EntityUtil;
import lumien.randomthings.util.InventoryUtil;
import lumien.randomthings.util.WorldUtil;
import lumien.randomthings.util.client.RenderUtils;
import lumien.randomthings.worldgen.WorldGenSakanade;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class RTEventHandler {
    static Random rng = new Random();
    public static int clientAnimationCounter;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientConnectingToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ClientModelLibrary.getInstance().reset();
            }
        });
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        ItemCatcher.entityJoinWorld(event);
    }

    @SubscribeEvent
    public void loadLootTable(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            if (Worldgen.LAVA_CHARM) {
                this.addSingleItemWithChance("lavaCharm", table, ModItems.lavaCharm, 0.1f);
            }
            if (Worldgen.SUMMONING_PENDULUM) {
                this.addSingleItemWithChance("summoningPendulum", table, ModItems.summoningPendulum, 0.1f);
            }
            if (Worldgen.MAGIC_HOOD) {
                this.addSingleItemWithChance("magicHood", table, (Item)ModItems.magicHood, 0.15f);
            }
            if (Worldgen.SLIME_CUBE) {
                this.addSingleItemWithChance("slimeCube", table, Item.func_150898_a((Block)ModBlocks.slimeCube), 0.3f);
            }
        } else if (Worldgen.LAVA_CHARM && event.getName().equals((Object)LootTableList.field_186425_g)) {
            this.addSingleItemWithChance("lavaCharm", table, ModItems.lavaCharm, 0.3f);
        } else if (Worldgen.MAGIC_HOOD && event.getName().equals((Object)LootTableList.field_186423_e)) {
            this.addSingleItemWithChance("magicHood", table, (Item)ModItems.magicHood, 0.02f);
        } else if (Worldgen.SUMMONING_PENDULUM && event.getName().equals((Object)LootTableList.field_186428_j)) {
            this.addSingleItemWithChance("summoningPendulum", table, ModItems.summoningPendulum, 0.5f);
        } else if (Worldgen.SLIME_CUBE && event.getName().equals((Object)LootTableList.field_186430_l)) {
            this.addSingleItemWithChance("slimeCube", table, Item.func_150898_a((Block)ModBlocks.slimeCube), 0.8f);
        }
        if (Worldgen.BIOME_CRYSTAL && event.getName().toString().startsWith("minecraft:chests/")) {
            LootEntryItem crystalEntry = new LootEntryItem((Item)ModItems.biomeCrystal, 1, 0, new LootFunction[]{new LootFunction(new LootCondition[0]){

                public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                    Object[] locationArray = Biome.field_185377_q.func_148742_b().toArray();
                    ResourceLocation randomLocation = (ResourceLocation)locationArray[rand.nextInt(locationArray.length)];
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74778_a("biomeName", randomLocation.toString());
                    return stack;
                }
            }}, new LootCondition[0], "randomthings:biomeCrystal");
            LootPool crystalPool = new LootPool(new LootEntry[]{crystalEntry}, new LootCondition[]{new RandomChance(0.2f)}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "randomthings:biomeCrystal");
            table.addPool(crystalPool);
        }
    }

    private void addSingleItemWithChance(String name, LootTable table, Item item, float chance) {
        table.addPool(new LootPool(new LootEntry[]{new LootEntryItem(item, 1, 0, new LootFunction[0], new LootCondition[0], "randomthings:" + name)}, new LootCondition[]{new RandomChance(chance)}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "randomthings:" + name));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && !event.isCanceled() && event.getOriginal() != null && !(event.getEntityPlayer() instanceof FakePlayer) && !event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            EntityPlayer oldPlayer = event.getOriginal();
            EntityPlayer newPlayer = event.getEntityPlayer();
            for (int i = 0; i < oldPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack is = oldPlayer.field_71071_by.func_70301_a(i);
                if (is.func_190926_b() || !is.func_77942_o() || !is.func_77978_p().func_74764_b("spectreAnchor")) continue;
                ItemStack newIs = newPlayer.field_71071_by.func_70301_a(i);
                if (newIs.func_190926_b()) {
                    newPlayer.field_71071_by.func_70299_a(i, is.func_77946_l());
                    continue;
                }
                ItemStack existing = newIs;
                int emptyStack = newPlayer.field_71071_by.func_70447_i();
                if (emptyStack != -1) {
                    newPlayer.field_71071_by.func_70299_a(emptyStack, existing);
                    newPlayer.field_71071_by.func_70299_a(i, is.func_77946_l());
                    continue;
                }
                RandomThings.instance.logger.log(Level.INFO, "Couldn't keep Anchored Item in the Inventory");
                WorldUtil.spawnItemStack(oldPlayer.field_70170_p, oldPlayer.field_70165_t, oldPlayer.field_70163_u, oldPlayer.field_70161_v, is);
            }
        }
    }

    @SubscribeEvent
    public void biomeDecoration(DecorateBiomeEvent event) {
        if (!(event instanceof DecorateBiomeEvent.Pre) && event instanceof DecorateBiomeEvent.Post) {
            WorldGenSakanade.instance.generate(event.getRand(), event.getPos().func_177958_n() >> 4, event.getPos().func_177952_p() >> 4, event.getWorld(), null, null);
        }
    }

    @SubscribeEvent
    public void explosionDetonate(ExplosionEvent.Detonate event) {
        Iterator iterator = event.getAffectedBlocks().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            if (!(event.getWorld().func_180495_p(pos).func_177230_c() instanceof IExplosionImmune)) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void tick(TickEvent tickEvent) {
        if ((tickEvent.type == TickEvent.Type.CLIENT || tickEvent.type == TickEvent.Type.SERVER) && tickEvent.phase == TickEvent.Phase.END) {
            TileEntityRainShield.rainCache.clear();
        }
        if (tickEvent.type == TickEvent.Type.CLIENT) {
            ++clientAnimationCounter;
        }
        if (tickEvent instanceof TickEvent.ServerTickEvent) {
            ServerModelLibrary.getInstance().tick();
        }
        if (tickEvent instanceof TickEvent.WorldTickEvent) {
            TickEvent.WorldTickEvent worldTickEvent = (TickEvent.WorldTickEvent)tickEvent;
            if (worldTickEvent.phase == TickEvent.Phase.END && !worldTickEvent.world.field_72995_K && worldTickEvent.world.field_73011_w.getDimension() == 0) {
                RedstoneSignalHandler.getHandler().tick();
            }
        }
    }

    @SubscribeEvent
    public void notifyNeighbors(BlockEvent.NeighborNotifyEvent event) {
        TileEntityRedstoneObserver.notifyNeighbor(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        PotionEffect effect;
        if (event.getEntity() instanceof EntityLivingBase && (effect = ((EntityLivingBase)event.getEntity()).func_70660_b((Potion)ModPotions.collapse)) != null && effect.func_76458_c() == 1) {
            event.setRoll(180.0f);
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            IBlockState targetState;
            PlayerInteractEvent.RightClickBlock rcEvent;
            ItemStack equipped = event.getEntityPlayer().func_184586_b(event.getHand());
            if (!equipped.func_190926_b() && equipped.func_77973_b() instanceof ItemSpade) {
                rcEvent = (PlayerInteractEvent.RightClickBlock)event;
                targetState = event.getWorld().func_180495_p(event.getPos());
                if (targetState.func_177230_c() == Blocks.field_180399_cE) {
                    event.getEntityPlayer().func_184609_a(event.getHand());
                    if (!event.getWorld().field_72995_K && !event.getWorld().field_72995_K) {
                        event.getWorld().func_175656_a(event.getPos(), ModBlocks.compressedSlimeBlock.func_176223_P());
                        event.getWorld().func_184148_a(null, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), Blocks.field_180399_cE.func_185467_w().func_185841_e(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        equipped.func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                    }
                }
            }
            if (!event.getWorld().field_72995_K && !equipped.func_190926_b() && equipped.func_77973_b() == Items.field_151121_aF) {
                rcEvent = (PlayerInteractEvent.RightClickBlock)event;
                targetState = event.getWorld().func_180495_p(event.getPos());
                if (targetState.func_177230_c() == ModBlocks.runeBase) {
                    TileEntityRuneBase te = (TileEntityRuneBase)event.getWorld().func_175625_s(rcEvent.getPos());
                    int[][] runeData = te.getRuneData();
                    int[] savedData = new int[16];
                    int counter = 0;
                    for (int y = 0; y < runeData[0].length; ++y) {
                        for (int x = 0; x < runeData.length; ++x) {
                            savedData[counter] = runeData[x][y];
                            ++counter;
                        }
                    }
                    ItemStack patternStack = new ItemStack((Item)ModItems.runePattern);
                    patternStack.func_77982_d(new NBTTagCompound());
                    patternStack.func_77978_p().func_74783_a("runeData", savedData);
                    ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.ALLOW);
                    if (equipped.func_190916_E() == 1) {
                        int slot = event.getHand() == EnumHand.MAIN_HAND ? event.getEntityPlayer().field_71071_by.field_70461_c : 40;
                        event.getEntityPlayer().field_71071_by.func_70299_a(slot, patternStack);
                    } else {
                        equipped.func_190918_g(1);
                        event.getEntityPlayer().field_71071_by.func_70441_a(patternStack);
                    }
                }
            }
            if (!event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
                for (EnumFacing facing : EnumFacing.values()) {
                    BlockPos pos = event.getPos().func_177972_a(facing);
                    IBlockState state = event.getWorld().func_180495_p(pos);
                    if (state.func_177230_c() == ModBlocks.contactButton) {
                        if (((EnumFacing)state.func_177229_b((IProperty)BlockContactButton.FACING)).func_176734_d() != facing) continue;
                        ((BlockContactButton)state.func_177230_c()).activate(event.getWorld(), event.getPos().func_177972_a(facing), facing.func_176734_d());
                        break;
                    }
                    if (state.func_177230_c() != ModBlocks.contactLever || ((EnumFacing)state.func_177229_b((IProperty)BlockContactLever.FACING)).func_176734_d() != facing) continue;
                    ((BlockContactLever)state.func_177230_c()).activate(event.getWorld(), event.getPos().func_177972_a(facing), facing.func_176734_d());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void livingExperience(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null && event.getAttackingPlayer().func_70644_a((Potion)ModPotions.imbueExperience)) {
            event.setDroppedExperience(event.getDroppedExperience() + event.getOriginalExperience());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void modelBake(ModelBakeEvent event) {
        ModelFluidDisplay modelFluidDisplay = new ModelFluidDisplay();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:fluidDisplay", "normal"), (Object)modelFluidDisplay);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:fluidDisplay", "inventory"), (Object)modelFluidDisplay);
        ModelCustomWorkbench modelCustomWorkbench = new ModelCustomWorkbench();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:customWorkbench", "normal"), (Object)modelCustomWorkbench);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:customWorkbench", "inventory"), (Object)modelCustomWorkbench);
        ModelRune runeBaseModel = new ModelRune();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:runeBase", "normal"), (Object)runeBaseModel);
        ModelInventoryRerouter inventoryRerouterModel = new ModelInventoryRerouter();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("randomthings:inventoryRerouter", "normal"), (Object)inventoryRerouterModel);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        try {
            ASMDataTable asmData = RandomThings.instance.getASMData();
            Set atlasSet = asmData.getAll(AtlasSprite.class.getName());
            for (ASMDataTable.ASMData data : atlasSet) {
                Class<?> clazz = Class.forName(data.getClassName());
                Field f = clazz.getDeclaredField(data.getObjectName());
                f.setAccessible(true);
                ResourceLocation rl = new ResourceLocation((String)data.getAnnotationInfo().get("resource"));
                f.set(null, event.getMap().func_174942_a(rl));
            }
        }
        catch (Exception e) {
            RandomThings.instance.logger.log(Level.ERROR, "Error stitching extra textures");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        BlockPos below = player.func_180425_c().func_177977_b();
        IBlockState state = player.field_70170_p.func_180495_p(below);
        ItemStack flooDust = player.func_184614_ca();
        if ((player.field_71075_bZ.field_75098_d || !flooDust.func_190926_b() && flooDust.func_77973_b() instanceof ItemIngredient && flooDust.func_77952_i() == ItemIngredient.INGREDIENT.FLOO_POWDER.id) && state.func_177230_c() == ModBlocks.flooBrick) {
            TileEntityFlooBrick masterBrick;
            FlooNetworkHandler networkHandler;
            TileEntity masterTE;
            String target = event.getMessage();
            TileEntityFlooBrick te = (TileEntityFlooBrick)player.field_70170_p.func_175625_s(below);
            UUID firePlaceUUID = te.getFirePlaceUid();
            if (firePlaceUUID != null && (masterTE = (networkHandler = FlooNetworkHandler.get(player.field_70170_p)).getFirePlaceTE(player.field_70170_p, firePlaceUUID)) instanceof TileEntityFlooBrick && (masterBrick = (TileEntityFlooBrick)masterTE).isMaster()) {
                boolean success = networkHandler.teleport(player.field_70170_p, masterBrick.func_174877_v(), masterBrick, player, target);
                if (success && !player.field_71075_bZ.field_75098_d) {
                    flooDust.func_190918_g(1);
                }
                event.setCanceled(true);
            }
            return;
        }
        Iterator<TileEntityChatDetector> iterator = TileEntityChatDetector.detectors.iterator();
        while (iterator.hasNext()) {
            TileEntityChatDetector chatDetector = iterator.next();
            if (chatDetector.func_145837_r()) {
                iterator.remove();
                continue;
            }
            if (!chatDetector.checkMessage(event.getUsername(), event.getMessage())) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void itemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77942_o()) {
            if (event.getItemStack().func_77978_p().func_74764_b("spectreAnchor")) {
                event.getToolTip().add(1, TextFormatting.DARK_AQUA.toString() + I18n.func_135052_a((String)"tooltip.spectreAnchor.item", (Object[])new Object[0]) + TextFormatting.RESET.toString());
            }
            if (event.getItemStack().func_77978_p().func_74764_b("luminousEnchantment")) {
                event.getToolTip().add(1, TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)"tooltip.luminousEnchantment", (Object[])new Object[0]) + TextFormatting.RESET.toString());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() != null && event instanceof RenderGameOverlayEvent.Post) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
                this.renderLavaCharm(event);
            } else if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
                this.renderRedstoneTool(event);
            }
        }
    }

    private void renderRedstoneTool(RenderGameOverlayEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemStack equippedItem = minecraft.field_71439_g.func_184614_ca();
        if (!equippedItem.func_190926_b()) {
            if (equippedItem.func_77973_b() == ModItems.redstoneTool) {
                IBlockState hitState;
                Block hitBlock;
                RayTraceResult objectMouseOver = minecraft.field_71476_x;
                if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK && (hitBlock = (hitState = minecraft.field_71441_e.func_180495_p(objectMouseOver.func_178782_a())).func_177230_c()) instanceof BlockRedstoneWire) {
                    int width = event.getResolution().func_78326_a();
                    int height = event.getResolution().func_78328_b();
                    int power = (Integer)hitState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
                    GlStateManager.func_179084_k();
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(power + "", width / 2 + 5, height / 2 + 5, Colors.RED_INT);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179147_l();
                }
            } else if (equippedItem.func_77973_b() == ModItems.ingredients && equippedItem.func_77952_i() == ItemIngredient.INGREDIENT.BIOME_SENSOR.id) {
                Biome b = minecraft.field_71441_e.func_180494_b(minecraft.field_71439_g.func_180425_c());
                int width = event.getResolution().func_78326_a();
                int height = event.getResolution().func_78328_b();
                GlStateManager.func_179084_k();
                Minecraft.func_71410_x().field_71466_p.func_78276_b(b.func_185359_l(), width / 2 + 5, height / 2 + 5, Colors.WHITE_INT);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
            }
        }
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        AnvilRecipe recipe;
        if (!event.getLeft().func_190926_b() && !event.getRight().func_190926_b() && (recipe = AnvilRecipeHandler.getRecipe(event.getLeft(), event.getRight())) != null) {
            event.setOutput(recipe.getOutput());
            event.setCost(recipe.getCost());
        }
    }

    private boolean arePairs(Object o1, Object o2, Object o3, Object o4) {
        return o1 == o3 && o2 == o4 || o1 == o4 && o2 == o3;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderLavaCharm(RenderGameOverlayEvent event) {
        NBTTagCompound compound;
        ItemStack boots;
        ItemStack lavaProtector = ItemStack.field_190927_a;
        ItemStack lavaCharm = ItemStack.field_190927_a;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        lavaCharm = InventoryUtil.getBauble(ModItems.lavaCharm, (EntityPlayer)player);
        if (lavaCharm.func_190926_b()) {
            lavaCharm = InventoryUtil.getPlayerInventoryItem(ModItems.lavaCharm, (EntityPlayer)player);
        }
        if (!lavaCharm.func_190926_b()) {
            lavaProtector = lavaCharm;
        }
        if (!(boots = player.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && boots.func_77973_b() == ModItems.lavaWader) {
            lavaProtector = boots;
        }
        if (!lavaProtector.func_190926_b() && (compound = lavaProtector.func_77978_p()) != null) {
            float charge = compound.func_74762_e("charge");
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71446_o.func_110577_a(new ResourceLocation("randomthings:textures/gui/lavaCharmBar.png"));
            GuiIngame ingameGui = mc.field_71456_v;
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            int count = (int)Math.floor(charge / 2.0f / 10.0f);
            int left = 0;
            int top = height - GuiIngameForge.left_height - 1;
            GuiIngameForge.left_height += 10;
            GlStateManager.func_179147_l();
            for (int i = 0; i < count + 1; ++i) {
                if (i == count + 1 - 1) {
                    float countFloat = charge / 2.0f / 10.0f + 10.0f;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(countFloat % (float)((int)countFloat)));
                }
                ingameGui.func_73729_b(width / 2 - 92 + left, top, 0, 0, 10, 10);
                left += 8;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            mc.field_71446_o.func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
        }
    }

    private void handleLavaProtection(LivingAttackEvent event) {
        int charge;
        NBTTagCompound compound;
        ItemStack boots;
        ItemStack lavaProtector = ItemStack.field_190927_a;
        ItemStack lavaCharm = ItemStack.field_190927_a;
        lavaCharm = InventoryUtil.getBauble(ModItems.lavaCharm, (EntityPlayer)event.getEntityLiving());
        if (lavaCharm.func_190926_b()) {
            lavaCharm = InventoryUtil.getPlayerInventoryItem(ModItems.lavaCharm, (EntityPlayer)event.getEntityLiving());
        }
        if (!lavaCharm.func_190926_b()) {
            lavaProtector = lavaCharm;
        }
        if (!(boots = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && boots.func_77973_b() == ModItems.lavaWader) {
            lavaProtector = boots;
        }
        if (!lavaProtector.func_190926_b() && (compound = lavaProtector.func_77978_p()) != null && (charge = compound.func_74762_e("charge")) > 0) {
            compound.func_74768_a("charge", charge - 1);
            compound.func_74768_a("chargeCooldown", 40);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingAttacked(LivingAttackEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityDamageSource damageSource;
            if (!event.isCanceled() && event.getAmount() > 0.0f && event.getEntityLiving() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
                if (event.getSource() == DamageSource.field_76371_c) {
                    this.handleLavaProtection(event);
                }
                if (event.getSource().func_76347_k() && event.getSource() != DamageSource.field_76371_c) {
                    this.handleFireProtection(event);
                }
            }
            if (!event.isCanceled() && event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect) && (damageSource = (EntityDamageSource)event.getSource()).func_76346_g() != null && damageSource.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)damageSource.func_76346_g();
                if (livingEntity.func_70644_a((Potion)ModPotions.imbueFire)) {
                    event.getEntityLiving().func_70015_d(10);
                } else if (livingEntity.func_70644_a((Potion)ModPotions.imbueWither)) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 1));
                } else if (livingEntity.func_70644_a((Potion)ModPotions.imbuePoison)) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 1));
                }
            }
        }
    }

    private void handleFireProtection(LivingAttackEvent event) {
        ItemStack skull;
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack baubleSkull = InventoryUtil.getBauble(ModItems.obsidianSkullRing, player);
        ItemStack inventorySkull = InventoryUtil.getPlayerInventoryItem(ModItems.obsidianSkull, player);
        ItemStack obsidianBoots = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!obsidianBoots.func_190926_b() && obsidianBoots.func_77973_b() != ModItems.obsidianWaterWalkingBoots && obsidianBoots.func_77973_b() != ModItems.lavaWader) {
            obsidianBoots = ItemStack.field_190927_a;
        }
        if ((skull = baubleSkull).func_190926_b()) {
            skull = inventorySkull;
        }
        if (skull.func_190926_b()) {
            skull = obsidianBoots;
        }
        if (!skull.func_190926_b()) {
            float amount = event.getAmount();
            float rngFloat = rng.nextFloat();
            float chance = amount / 100.0f;
            if (rngFloat > (chance *= amount * amount)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void useHoe(UseHoeEvent event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block == ModBlocks.fertilizedDirt) {
            event.setResult(Event.Result.ALLOW);
            event.getWorld().func_175656_a(event.getPos(), ModBlocks.fertilizedDirtTilled.func_176223_P());
            event.getWorld().func_184133_a(null, event.getPos().func_177963_a(0.5, 0.5, 0.5), ModBlocks.fertilizedDirtTilled.func_185467_w().func_185844_d(), SoundCategory.BLOCKS, (ModBlocks.fertilizedDirtTilled.func_185467_w().func_185843_a() + 1.0f) / 2.0f, ModBlocks.fertilizedDirtTilled.func_185467_w().func_185847_b() * 0.8f);
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                SpectreHandler spectreHandler;
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (player.field_71093_bK == ModDimensions.SPECTRE_ID && (spectreHandler = SpectreHandler.getInstance()) != null) {
                    spectreHandler.checkPosition((EntityPlayerMP)player);
                }
            }
        } else {
            ItemStack boots;
            EntityPlayer player;
            this.spawnEntityFilterParticles(event);
            if (!(!(event.getEntityLiving() instanceof EntityPlayer) || (player = (EntityPlayer)event.getEntityLiving()).func_70093_af() || (boots = (ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() || boots.func_77973_b() != ModItems.waterWalkingBoots && boots.func_77973_b() != ModItems.obsidianWaterWalkingBoots && boots.func_77973_b() != ModItems.lavaWader)) {
                BlockPos liquid = new BlockPos(Math.floor(player.field_70165_t), Math.floor(player.field_70163_u), Math.floor(player.field_70161_v));
                BlockPos air = new BlockPos((int)player.field_70165_t, (int)(player.field_70163_u + (double)player.field_70131_O), (int)player.field_70161_v);
                Block liquidBlock = player.field_70170_p.func_180495_p(liquid).func_177230_c();
                Material liquidMaterial = liquidBlock.func_149688_o(player.field_70170_p.func_180495_p(liquid));
                if ((liquidMaterial == Material.field_151586_h || boots.func_77973_b() == ModItems.lavaWader && liquidMaterial == Material.field_151587_i) && player.field_70170_p.func_180495_p(air).func_177230_c().isAir(player.field_70170_p.func_180495_p(air), (IBlockAccess)player.field_70170_p, air) && EntityUtil.isJumping((EntityLivingBase)player)) {
                    player.func_70091_d(MoverType.SELF, 0.0, 0.22, 0.0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEntityFilterParticles(LivingEvent.LivingUpdateEvent event) {
        IEntityFilterItem filterInstance;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack equipped = player.func_184614_ca();
        if (!equipped.func_190926_b() && equipped.func_77973_b() instanceof IEntityFilterItem && (filterInstance = (IEntityFilterItem)equipped.func_77973_b()).apply(equipped, (Entity)event.getEntityLiving())) {
            for (int i = 0; i < 1; ++i) {
                Particle particle = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.PORTAL.ordinal(), event.getEntityLiving().field_70165_t + (rng.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, event.getEntityLiving().field_70163_u + rng.nextDouble() * (double)event.getEntityLiving().field_70131_O - 0.25, event.getEntityLiving().field_70161_v + (rng.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, (rng.nextDouble() - 0.5) * 2.0, -rng.nextDouble(), (rng.nextDouble() - 0.5) * 2.0, new int[0]);
                particle.func_70538_b(0.2f, 0.2f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            RTWorldInformation rtInfo;
            if (event.getEntityLiving() instanceof EntityDragon && (rtInfo = RTWorldInformation.getInstance()) != null) {
                rtInfo.setEnderDragonDefeated(true);
            }
            if (event.getSource().func_76346_g() != null && !(event.getSource().func_76346_g() instanceof FakePlayer) && event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getEntity() instanceof EntitySpirit)) {
                double chance = Numbers.SPIRIT_CHANCE_NORMAL;
                RTWorldInformation rtInfo2 = RTWorldInformation.getInstance();
                if (rtInfo2 != null && rtInfo2.isDragonDefeated()) {
                    chance += Numbers.SPIRIT_CHANCE_END_INCREASE;
                }
                if (event.getEntityLiving().field_70170_p.func_175710_j(event.getEntityLiving().func_180425_c()) && !event.getEntityLiving().field_70170_p.func_72935_r()) {
                    chance += (double)(event.getEntityLiving().field_70170_p.func_130001_d() / 100.0f) * Numbers.SPIRIT_CHANCE_MOON_MULT;
                }
                if (Math.random() < chance) {
                    event.getEntityLiving().field_70170_p.func_72838_d((Entity)new EntitySpirit(event.getEntityLiving().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v));
                }
            }
            if (event.getEntityLiving() instanceof EntityPlayer && !(event.getEntityLiving() instanceof FakePlayer)) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (!event.isCanceled()) {
                    player.field_70170_p.func_72838_d((Entity)new EntitySoul(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.func_146103_bH().getName()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void potentialSpawns(WorldEvent.PotentialSpawns event) {
        if (event.getWorld().field_73011_w.getDimension() == ModDimensions.SPECTRE_ID) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderWorldPost(RenderWorldLastEvent event) {
        Item item;
        ItemStack itemStack;
        RandomThings.proxy.renderRedstoneInterfaceStuff(event.getPartialTicks());
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && !(itemStack = player.func_184614_ca()).func_190926_b() && (item = itemStack.func_77973_b()) == ModItems.positionFilter && itemStack.func_77978_p() != null) {
            NBTTagCompound compound = itemStack.func_77978_p();
            int dimension = compound.func_74762_e("dimension");
            int filterX = compound.func_74762_e("filterX");
            int filterY = compound.func_74762_e("filterY");
            int filterZ = compound.func_74762_e("filterZ");
            if (player.field_71093_bK == dimension) {
                double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
                double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
                double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
                GlStateManager.func_179147_l();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
                RenderUtils.drawCube((float)filterX - 0.01f, (float)filterY - 0.01f, (float)filterZ - 0.01f, 1.02f, 102, 0, 255, 51);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
            }
        }
    }
}

