/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.HashMap;
import java.util.List;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.lib.IEntityFilterItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemEntityFilter
extends ItemBase
implements IEntityFilterItem {
    HashMap<String, Class> classCache = new HashMap();

    public ItemEntityFilter() {
        super("entityFilter");
    }

    private Class getEntityClass(ItemStack filter) {
        NBTTagCompound compound = filter.func_77978_p();
        if (compound != null) {
            if (!compound.func_74764_b("entityKey")) {
                return null;
            }
            String entityKeyString = compound.func_74779_i("entityKey");
            Class clazz = EntityList.func_192839_a((String)entityKeyString);
            if (clazz != null) {
                return clazz;
            }
        }
        return null;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (!playerIn.field_70170_p.field_72995_K) {
            stack = playerIn.func_184614_ca();
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound compound = stack.func_77978_p();
            ResourceLocation entityKey = EntityList.func_191301_a((Entity)target);
            compound.func_74778_a("entityKey", entityKey.toString());
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, World world, List tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            if (!compound.func_74764_b("entityKey")) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.entityFilter.invalidEntity", (Object[])new Object[0]));
            } else {
                String entityKeyString = compound.func_74779_i("entityKey");
                Class clazz = EntityList.func_192839_a((String)entityKeyString);
                String translationKey = EntityList.func_191302_a((ResourceLocation)new ResourceLocation(entityKeyString));
                if (Keyboard.isKeyDown((int)42)) {
                    tooltip.add(entityKeyString);
                }
                tooltip.add(I18n.func_135052_a((String)("entity." + translationKey + ".name"), (Object[])new Object[0]));
            }
        }
    }

    @Override
    public boolean apply(ItemStack me, Entity entity) {
        Class filterClass = this.getEntityClass(me);
        if (filterClass != null) {
            return filterClass.isAssignableFrom(entity.getClass());
        }
        return true;
    }
}

