/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.UUID;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockBlockBreaker;
import lumien.randomthings.enchantment.EnchantmentMagnetic;
import lumien.randomthings.enchantment.ModEnchantments;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class TileEntityBlockBreaker
extends TileEntityBase
implements ITickable {
    public static final GameProfile breakerProfile = new GameProfile(UUID.nameUUIDFromBytes("RTBlockBreaker".getBytes(Charsets.UTF_8)), "RTBlockBreaker");
    UUID uuid;
    boolean mining;
    boolean canMine;
    WeakReference<FakePlayer> fakePlayer;
    float curBlockDamage;
    boolean firstTick = true;

    private void initFakePlayer() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.syncTE();
        }
        this.fakePlayer = new WeakReference<FakePlayer>(FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)breakerProfile));
        ItemStack unbreakingIronPickaxe = new ItemStack(Items.field_151035_b, 1);
        unbreakingIronPickaxe.func_77982_d(new NBTTagCompound());
        unbreakingIronPickaxe.func_77978_p().func_74757_a("Unbreakable", true);
        HashMap<EnchantmentMagnetic, Integer> enchantmentMap = new HashMap<EnchantmentMagnetic, Integer>();
        enchantmentMap.put(ModEnchantments.magnetic, 1);
        EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)unbreakingIronPickaxe);
        ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, unbreakingIronPickaxe);
        ((FakePlayer)this.fakePlayer.get()).field_70122_E = true;
        ((FakePlayer)this.fakePlayer.get()).field_71135_a = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)this.fakePlayer.get()){

            public void func_147359_a(Packet packetIn) {
            }
        };
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.firstTick) {
                this.firstTick = false;
                this.initFakePlayer();
                this.neighborChanged(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, null, null);
            }
            if (this.mining) {
                EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockBreaker.FACING);
                BlockPos targetPos = this.field_174879_c.func_177972_a(facing);
                IBlockState targetState = this.field_145850_b.func_180495_p(targetPos);
                this.curBlockDamage += targetState.func_185903_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, targetPos);
                if (this.curBlockDamage >= 1.0f) {
                    this.mining = false;
                    this.resetProgress();
                    FakePlayer player = (FakePlayer)this.fakePlayer.get();
                    if (player != null) {
                        boolean catching = false;
                        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
                        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                            catching = true;
                        }
                        player.field_71093_bK = this.field_145850_b.field_73011_w.getDimension();
                        player.field_71134_c.field_73092_a = player.field_70170_p = this.field_145850_b;
                        player.field_71134_c.func_180237_b(targetPos);
                        IItemHandler itemHandler = null;
                        if (catching) {
                            itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                        }
                        for (int i = 1; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack stack = player.field_71071_by.func_70301_a(i);
                            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                            if (stack.func_190926_b()) continue;
                            ItemStack remainder = stack;
                            if (catching) {
                                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                            }
                            if (remainder.func_190926_b()) continue;
                            WorldUtil.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177972_a(facing), stack);
                        }
                    }
                } else {
                    this.field_145850_b.func_175715_c(this.uuid.hashCode(), targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
                }
            }
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        if (this.uuid != null) {
            compound.func_74778_a("uuid", this.uuid.toString());
        }
        compound.func_74757_a("mining", this.mining);
        compound.func_74757_a("canMine", this.canMine);
        compound.func_74776_a("curBlockDamage", this.curBlockDamage);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("uuid")) {
            this.uuid = UUID.fromString(compound.func_74779_i("uuid"));
        }
        this.mining = compound.func_74767_n("mining");
        this.canMine = compound.func_74767_n("canMine");
        this.curBlockDamage = compound.func_74760_g("curBlockDamage");
    }

    @Override
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        BlockPos targetPos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBlockBreaker.FACING));
        this.canMine = worldIn.func_175687_A(pos) <= 0;
        IBlockState targetState = worldIn.func_180495_p(targetPos);
        if (this.canMine) {
            if (!worldIn.func_175623_d(targetPos)) {
                if (!this.mining) {
                    this.mining = true;
                    this.curBlockDamage = 0.0f;
                }
            } else {
                this.mining = false;
                this.resetProgress();
            }
        } else if (this.mining) {
            this.mining = false;
            this.resetProgress();
        }
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.mining && this.uuid != null) {
            this.resetProgress(state);
        }
    }

    private void resetProgress() {
        this.resetProgress(this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    private void resetProgress(IBlockState state) {
        if (this.uuid != null) {
            BlockPos targetPos = this.field_174879_c.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBlockBreaker.FACING));
            this.field_145850_b.func_175715_c(this.uuid.hashCode(), targetPos, -1);
            this.curBlockDamage = 0.0f;
        }
    }

    static {
        RandomThings.instance.logger.log(Level.DEBUG, "BlockBreakerUUID: " + breakerProfile.getId().toString());
    }
}

