/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import lumien.randomthings.block.BlockChatDetector;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChatDetector
extends TileEntityBase
implements ITickable {
    public static Set<TileEntityChatDetector> detectors = Collections.newSetFromMap(new WeakHashMap());
    UUID playerUUID;
    String chatMessage = "";
    boolean consume;
    boolean pulsing;
    int pulsingCounter;

    public TileEntityChatDetector() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            detectors.add(this);
        }
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.pulsing) {
            --this.pulsingCounter;
            if (this.pulsingCounter <= 0) {
                this.pulsing = false;
                this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.chatDetector.func_176223_P().func_177226_a((IProperty)BlockChatDetector.POWERED, (Comparable)Boolean.valueOf(this.pulsing)));
            }
        }
    }

    public boolean isPulsing() {
        return this.pulsing;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("consume", this.consume);
        compound.func_74778_a("chatMessage", this.chatMessage);
        if (this.playerUUID != null) {
            compound.func_74778_a("playerUUID", this.playerUUID.toString());
        }
        compound.func_74757_a("pulsing", this.pulsing);
        compound.func_74768_a("pulsingCounter", this.pulsingCounter);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.consume = compound.func_74767_n("consume");
        this.chatMessage = compound.func_74779_i("chatMessage");
        if (compound.func_74764_b("playerUUID")) {
            this.playerUUID = UUID.fromString(compound.func_74779_i("playerUUID"));
        }
        this.pulsing = compound.func_74767_n("pulsing");
        this.pulsingCounter = compound.func_74762_e("pulsingCounter");
    }

    public String getChatMessage() {
        return this.chatMessage;
    }

    public void setChatMessage(String chatMessage) {
        this.chatMessage = chatMessage;
        this.syncTE();
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    private void pulse() {
        this.pulsing = true;
        this.pulsingCounter = 20;
        this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.chatDetector.func_176223_P().func_177226_a((IProperty)BlockChatDetector.POWERED, (Comparable)Boolean.valueOf(this.pulsing)));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean checkMessage(String user, String sendMessage) {
        UUID sendUUID;
        if (!this.field_145850_b.field_72995_K && (sendUUID = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(user).func_146103_bH().getId()).equals(this.playerUUID) && this.chatMessage.equals(sendMessage)) {
            this.pulse();
            return this.consume;
        }
        return false;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public boolean consume() {
        return this.consume;
    }
}

