/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import com.google.common.base.Predicate;
import java.util.List;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.lib.IEntityFilterItem;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityEntityDetector
extends TileEntityBase
implements ITickable {
    boolean powered;
    int rangeX = 5;
    int rangeY = 5;
    int rangeZ = 5;
    boolean invert;
    boolean strongOutput;
    static final int MAX_RANGE = 10;
    FILTER filter = FILTER.ALL;
    InventoryBasic filterInventory = new InventoryBasic("tile.entityDetector", false, 1);

    public boolean strongOutput() {
        return this.strongOutput;
    }

    public IInventory getInventory() {
        return this.filterInventory;
    }

    public void func_73660_a() {
        boolean newPowered;
        if (!this.field_145850_b.field_72995_K && (newPowered = this.checkSupposedPowereredState()) != this.powered) {
            this.powered = newPowered;
            this.syncTE();
            if (!this.strongOutput) {
                this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.entityDetector, false);
            } else {
                this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.entityDetector, false);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(facing), (Block)ModBlocks.entityDetector, false);
                }
            }
        }
    }

    public void cycleFilter() {
        int index = this.filter.ordinal();
        this.filter = ++index < FILTER.values().length ? FILTER.values()[index] : FILTER.values()[0];
        this.syncTE();
    }

    private boolean checkSupposedPowereredState() {
        List entityList = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)this.rangeX, (double)this.rangeY, (double)this.rangeZ), (Predicate)new FilterPredicate(this.filter.filterClass, this.filterInventory.func_70301_a(0)));
        return !this.invert == (entityList != null && entityList.size() > 0);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("powered", this.powered);
        compound.func_74768_a("rangeX", this.rangeX);
        compound.func_74768_a("rangeY", this.rangeY);
        compound.func_74768_a("rangeZ", this.rangeZ);
        compound.func_74768_a("filter", this.filter.ordinal());
        compound.func_74757_a("invert", this.invert);
        compound.func_74757_a("strongOutput", this.strongOutput);
        NBTTagCompound inventoryCompound = new NBTTagCompound();
        InventoryUtil.writeInventoryToCompound(inventoryCompound, (IInventory)this.filterInventory);
        compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.powered = compound.func_74767_n("powered");
        this.rangeX = compound.func_74762_e("rangeX");
        this.rangeY = compound.func_74762_e("rangeY");
        this.rangeZ = compound.func_74762_e("rangeZ");
        this.filter = FILTER.values()[compound.func_74762_e("filter")];
        this.invert = compound.func_74767_n("invert");
        this.strongOutput = compound.func_74767_n("strongOutput");
        NBTTagCompound inventoryCompound = compound.func_74775_l("inventory");
        if (inventoryCompound != null) {
            InventoryUtil.readInventoryFromCompound(inventoryCompound, (IInventory)this.filterInventory);
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getRangeX() {
        return this.rangeX;
    }

    public void setRangeX(int rangeX) {
        this.rangeX = rangeX;
        if (this.rangeX < 0) {
            this.rangeX = 0;
        } else if (this.rangeX > 10) {
            this.rangeX = 10;
        }
        this.syncTE();
    }

    public int getRangeY() {
        return this.rangeY;
    }

    public void setRangeY(int rangeY) {
        this.rangeY = rangeY;
        if (this.rangeY < 0) {
            this.rangeY = 0;
        } else if (this.rangeY > 10) {
            this.rangeY = 10;
        }
        this.syncTE();
    }

    public int getRangeZ() {
        return this.rangeZ;
    }

    public void setRangeZ(int rangeZ) {
        this.rangeZ = rangeZ;
        if (this.rangeZ < 0) {
            this.rangeZ = 0;
        } else if (this.rangeZ > 10) {
            this.rangeZ = 10;
        }
        this.syncTE();
    }

    public void toggleInvert() {
        this.invert = !this.invert;
        this.syncTE();
    }

    public boolean invert() {
        return this.invert;
    }

    public FILTER getFilter() {
        return this.filter;
    }

    public void toggleStrongOutput() {
        this.strongOutput = !this.strongOutput;
        this.syncTE();
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.entityDetector, false);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(facing), (Block)ModBlocks.entityDetector, false);
        }
    }

    private class FilterPredicate
    implements Predicate<Entity> {
        Class filterClass;
        ItemStack filterItem;
        IEntityFilterItem filterInstance;

        public FilterPredicate(Class filterClass, ItemStack filterItem) {
            this.filterClass = filterClass;
            this.filterItem = filterItem;
            if (!filterItem.func_190926_b() && filterItem.func_77973_b() instanceof IEntityFilterItem) {
                this.filterInstance = (IEntityFilterItem)filterItem.func_77973_b();
            }
        }

        public boolean apply(Entity input) {
            if (this.filterClass == null && this.filterInstance == null) {
                return false;
            }
            return this.filterClass == null ? this.filterInstance.apply(this.filterItem, input) : this.filterClass.isAssignableFrom(input.getClass());
        }
    }

    public static enum FILTER {
        ALL("all", Entity.class),
        LIVING("living", EntityLivingBase.class),
        ANIMAL("animal", IAnimals.class),
        MONSTER("monster", IMob.class),
        PLAYER("player", EntityPlayer.class),
        ITEMS("item", EntityItem.class),
        CUSTOM("custom", null);

        String languageKey;
        Class filterClass;

        private FILTER(String languageKey, Class filterClass) {
            this.languageKey = "gui.entityDetector.filter." + languageKey;
            this.filterClass = filterClass;
        }

        public String getLanguageKey() {
            return this.languageKey;
        }
    }
}

