/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import lumien.randomthings.recipes.imbuing.ImbuingRecipeHandler;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;

public class TileEntityImbuingStation
extends TileEntityBase
implements IInventory,
ITickable {
    InventoryBasic inventory;
    public int imbuingProgress;
    ItemStack currentOutput = ItemStack.field_190927_a;
    public static final int IMBUING_LENGTH = 200;

    public TileEntityImbuingStation() {
        this.inventory = new InventoryBasic("Imbuing Station", false, 5);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("imbuingProgress", this.imbuingProgress);
        InventoryUtil.writeInventoryToCompound(nbt, (IInventory)this.inventory);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt) {
        this.imbuingProgress = nbt.func_74762_e("imbuingProgress");
        InventoryUtil.readInventoryFromCompound(nbt, (IInventory)this.inventory);
        this.currentOutput = ImbuingRecipeHandler.getRecipeOutput((IInventory)this.inventory);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack validOutput = ImbuingRecipeHandler.getRecipeOutput((IInventory)this.inventory);
            if (!ItemStack.func_77989_b((ItemStack)validOutput, (ItemStack)this.currentOutput) && this.canHandleOutput(validOutput)) {
                this.imbuingProgress = 0;
                this.currentOutput = validOutput;
            }
            if (!this.currentOutput.func_190926_b()) {
                ++this.imbuingProgress;
                if (this.imbuingProgress >= 200) {
                    this.imbuingProgress = 0;
                    this.imbue();
                }
            } else {
                this.imbuingProgress = 0;
            }
        }
    }

    private boolean canHandleOutput(ItemStack validOutput) {
        ItemStack requiredOutput;
        if (validOutput.func_190926_b() || this.inventory.func_70301_a(4).func_190926_b()) {
            return true;
        }
        ItemStack currentInOutput = this.inventory.func_70301_a(4);
        if (!ItemStack.func_179545_c((ItemStack)currentInOutput, (ItemStack)(requiredOutput = validOutput)) || !ItemStack.func_77970_a((ItemStack)currentInOutput, (ItemStack)requiredOutput)) {
            return false;
        }
        return currentInOutput.func_190916_E() + requiredOutput.func_190916_E() <= currentInOutput.func_77976_d();
    }

    private void imbue() {
        if (this.inventory.func_70301_a(4).func_190926_b()) {
            this.inventory.func_70299_a(4, this.currentOutput.func_77946_l());
        } else {
            this.inventory.func_70301_a(4).func_190917_f(this.currentOutput.func_190916_E());
        }
        for (int slot = 0; slot < this.inventory.func_70302_i_() - 1; ++slot) {
            this.inventory.func_70298_a(slot, 1);
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 4;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "Imbuing Station";
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }
}

