/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import lumien.randomthings.block.BlockItemProjector;
import lumien.randomthings.entitys.EntityProjectedItem;
import lumien.randomthings.lib.ContainerSynced;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.RandomUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemProjector
extends TileEntityBase
implements ITickable {
    @ContainerSynced
    SELECTION_MODE selectionMode = SELECTION_MODE.LAST;
    int cooldownTimer;

    public TileEntityItemProjector() {
        this.setItemHandler((IItemHandler)new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                TileEntityItemProjector.this.func_70296_d();
            }
        });
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("cooldownTimer", this.cooldownTimer);
        compound.func_74768_a("selectionMode", this.selectionMode.ordinal());
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.cooldownTimer = compound.func_74762_e("cooldownTimer");
        this.selectionMode = SELECTION_MODE.values()[compound.func_74762_e("selectionMode")];
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.cooldownTimer;
            if (this.cooldownTimer >= 10) {
                this.cooldownTimer = 0;
                this.project();
            }
        }
    }

    private void project() {
        ItemStack stack;
        IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        int projectedSlot = -1;
        block0 : switch (this.selectionMode) {
            case BIGGEST: {
                int i;
                int maxSize = 0;
                int maxSlot = -1;
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack is = itemHandler.getStackInSlot(i);
                    if (is == null || is.func_190916_E() <= maxSize) continue;
                    maxSize = is.func_190916_E();
                    maxSlot = i;
                }
                projectedSlot = maxSlot;
                break;
            }
            case FIRST: {
                int i;
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    if (itemHandler.getStackInSlot(i) == null) continue;
                    projectedSlot = i;
                    break block0;
                }
                break;
            }
            case LAST: {
                int i;
                for (i = itemHandler.getSlots() - 1; i >= 0; --i) {
                    if (itemHandler.getStackInSlot(i) == null) continue;
                    projectedSlot = i;
                    break block0;
                }
                break;
            }
        }
        if (projectedSlot != -1 && !(stack = itemHandler.extractItem(projectedSlot, 64, false)).func_190926_b()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockItemProjector.FACING);
            EntityProjectedItem itemEntity = new EntityProjectedItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.625, (double)this.field_174879_c.func_177956_o() + 0.5 + (facing == EnumFacing.UP ? 0.6 : (facing == EnumFacing.DOWN ? -0.75 : (double)facing.func_96559_d() * 0.625)), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.625, stack.func_77946_l(), facing);
            itemEntity.setLifeSpan(500);
            this.field_145850_b.func_72838_d((Entity)itemEntity);
        }
    }

    public void rotateSelectionMode() {
        this.selectionMode = RandomUtil.rotateEnum(this.selectionMode);
    }

    public static enum SELECTION_MODE {
        FIRST,
        LAST,
        BIGGEST;

    }
}

