/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.UUID;
import lumien.randomthings.lib.IRedstoneSensitive;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.MessageNotification;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityNotificationInterface
extends TileEntityBase
implements IRedstoneSensitive {
    UUID owner;
    String title = "Title";
    String description = "Description";

    public TileEntityNotificationInterface() {
        this.setItemHandler((IItemHandler)new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TileEntityNotificationInterface.this.func_70296_d();
            }
        });
        this.setItemHandlerInternal();
    }

    public void setData(String title, String description) {
        this.title = title;
        this.description = description;
        this.func_70296_d();
        this.syncTE();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    private void notifyGo() {
        EntityPlayerMP player;
        if (this.owner != null && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.owner)) != null) {
            MessageNotification message = new MessageNotification(this.title, this.description, this.getItemHandler().getStackInSlot(0));
            PacketHandler.INSTANCE.sendTo(message, player);
        }
    }

    @Override
    public void redstoneChange(boolean oldState, boolean newState) {
        if (!oldState && newState) {
            this.notifyGo();
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74778_a("title", this.title);
        compound.func_74778_a("description", this.description);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.title = compound.func_74779_i("title");
        this.description = compound.func_74779_i("description");
        if (compound.func_74764_b("owner")) {
            this.owner = UUID.fromString(compound.func_74779_i("owner"));
        }
    }

    public void setPlayerUUID(UUID id) {
        this.owner = id;
    }

    public UUID getOwner() {
        return this.owner;
    }
}

